/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.ui.text.CBreakIterator;
import org.eclipse.cdt.internal.ui.util.NameComposer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class GetterSetterNameGenerator {
    private GetterSetterNameGenerator() {
    }

    public static String generateGetterName(IASTName fieldName) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.getter.capitalization", 3, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.wordDelimiter", "", null);
        String prefix = GetterSetterNameGenerator.isBooleanDecaratorName(fieldName) ? preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.prefixForBoolean", "is", null) : preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.prefix", "get", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        String name = GetterSetterNameGenerator.trimFieldName(fieldName.toString());
        return composer.compose(name);
    }

    private static boolean isBooleanDecaratorName(IASTName name) {
        IASTDeclarator declarator;
        IType type;
        return IASTDeclarator.DECLARATOR_NAME.equals(name.getPropertyInParent()) && (type = CPPVisitor.createType((IASTDeclarator)(declarator = (IASTDeclarator)name.getParent()))) instanceof IBasicType && ((IBasicType)type).getKind() == IBasicType.Kind.eBoolean;
    }

    public static String generateSetterName(IASTName fieldName) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.setter.capitalization", 3, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.setter.wordDelimiter", "", null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.setter.prefix", "set", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.setter.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        String name = GetterSetterNameGenerator.trimFieldName(fieldName.toString());
        return composer.compose(name);
    }

    public static String trimFieldName(String fieldName) {
        int end;
        CBreakIterator iterator = new CBreakIterator();
        iterator.setText(fieldName);
        int firstWordStart = -1;
        int firstWordEnd = -1;
        int secondWordStart = -1;
        int lastWordEnd = -1;
        int start = iterator.first();
        while ((end = iterator.next()) != -1) {
            if (Character.isLetterOrDigit(fieldName.charAt(start))) {
                int pos = end;
                while (--pos >= start && !Character.isLetterOrDigit(fieldName.charAt(pos))) {
                }
                lastWordEnd = pos + 1;
                if (firstWordStart < 0) {
                    firstWordStart = start;
                    firstWordEnd = lastWordEnd;
                } else if (secondWordStart < 0) {
                    secondWordStart = start;
                }
            }
            start = end;
        }
        if (firstWordStart >= 0 && firstWordStart + 1 == firstWordEnd && secondWordStart >= 0) {
            firstWordStart = secondWordStart;
        }
        if (firstWordStart < 0) {
            return fieldName;
        }
        return fieldName.substring(firstWordStart, lastWordEnd);
    }
}

