/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringMatch;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRefactoringMatchStore {
    private Map<IFile, IPath> fFileToPathMap = new HashMap<IFile, IPath>();
    private Map<IPath, SortedMap<CRefactoringMatch, CRefactoringMatch>> fPathToMatches = new HashMap<IPath, SortedMap<CRefactoringMatch, CRefactoringMatch>>();
    private Comparator<CRefactoringMatch> fOffsetComparator = new Comparator<CRefactoringMatch>(){

        @Override
        public int compare(CRefactoringMatch o1, CRefactoringMatch o2) {
            return o1.getOffset() - o2.getOffset();
        }
    };

    public void addMatch(CRefactoringMatch match) {
        IPath path = this.resolvePath(match.getFile());
        if (path != null) {
            Map<CRefactoringMatch, CRefactoringMatch> matchesForPath = this.getMapForPath(path, true);
            matchesForPath.put(match, match);
        }
    }

    private Map<CRefactoringMatch, CRefactoringMatch> getMapForPath(IPath path, boolean create) {
        SortedMap<CRefactoringMatch, CRefactoringMatch> map = this.fPathToMatches.get(path);
        if (map == null && create) {
            map = new TreeMap<CRefactoringMatch, CRefactoringMatch>(this.fOffsetComparator);
            this.fPathToMatches.put(path, map);
        }
        return map;
    }

    private IPath resolvePath(IFile file) {
        IPath path = this.fFileToPathMap.get(file);
        if (path == null) {
            path = file.getLocation();
            if (path == null) {
                path = file.getFullPath();
            }
            this.fFileToPathMap.put(file, path);
        }
        return path;
    }

    public int getFileCount() {
        return this.fFileToPathMap.size();
    }

    public List<IFile> getFileList() {
        return new ArrayList<IFile>(this.fFileToPathMap.keySet());
    }

    public boolean contains(IResource file) {
        return this.fFileToPathMap.containsKey(file);
    }

    public Collection<CRefactoringMatch> getMatchesForFile(IResource file) {
        return this.getMatchesForPath(this.fFileToPathMap.get(file));
    }

    public Collection<CRefactoringMatch> getMatchesForPath(IPath path) {
        Map map;
        if (path != null && (map = (Map)this.fPathToMatches.get(path)) != null) {
            return map.keySet();
        }
        return Collections.emptySet();
    }

    public CRefactoringMatch findMatch(IPath path, int nodeOffset) {
        Map map = this.fPathToMatches.get(path);
        if (map != null) {
            return (CRefactoringMatch)map.get(new CRefactoringMatch(null, nodeOffset, 0, 0));
        }
        return null;
    }

    public void removePath(IPath path) {
        Map map = this.fPathToMatches.remove(path);
        if (map != null && !map.isEmpty()) {
            IFile file = ((CRefactoringMatch)map.values().iterator().next()).getFile();
            this.fFileToPathMap.remove(file);
        }
    }

    public Collection<CRefactoringMatch> findMatchesInRange(Path path, int offset, int end) {
        SortedMap<CRefactoringMatch, CRefactoringMatch> map;
        if (path != null && (map = this.fPathToMatches.get(path)) != null) {
            return map.subMap(new CRefactoringMatch(null, offset, 0, 0), new CRefactoringMatch(null, end, 0, 0)).keySet();
        }
        return Collections.emptySet();
    }
}

