/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.browser.typeinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.IndexTypeInfo;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSelectionDialog
extends TwoPaneElementSelector {
    private static final String DIALOG_SETTINGS = TypeSelectionDialog.class.getName();
    private static final String SETTINGS_X_POS = "x";
    private static final String SETTINGS_Y_POS = "y";
    private static final String SETTINGS_WIDTH = "width";
    private static final String SETTINGS_HEIGHT = "height";
    private static final String SETTINGS_SHOW_NAMESPACES = "show_namespaces";
    private static final String SETTINGS_SHOW_CLASSES = "show_classes";
    private static final String SETTINGS_SHOW_STRUCTS = "show_structs";
    private static final String SETTINGS_SHOW_TYPEDEFS = "show_typedefs";
    private static final String SETTINGS_SHOW_ENUMS = "show_enums";
    private static final String SETTINGS_SHOW_UNIONS = "show_unions";
    private static final String SETTINGS_SHOW_FUNCTIONS = "show_functions";
    private static final String SETTINGS_SHOW_VARIABLES = "show_variables";
    private static final String SETTINGS_SHOW_ENUMERATORS = "show_enumerators";
    private static final String SETTINGS_SHOW_MACROS = "show_macros";
    private static final String SETTINGS_SHOW_LOWLEVEL = "show_lowlevel";
    private static final TypeInfoLabelProvider fElementRenderer = new TypeInfoLabelProvider(17);
    private static final TypeInfoLabelProvider fQualifierRenderer = new TypeInfoLabelProvider(28);
    private static final StringComparator fStringComparator = new StringComparator();
    private static final int[] ALL_TYPES = new int[]{61, 65, 67, 80, 63, 69, 74, 76, 81, 79};
    private final TypeFilterMatcher fFilterMatcher = new TypeFilterMatcher();
    private Set<Integer> fKnownTypes = new HashSet<Integer>(ALL_TYPES.length);
    private Text fTextWidget;
    private boolean fSelectFilterText = false;
    private FilteredList fNewFilteredList;
    private String fDialogSection;
    private Point fLocation;
    private Point fSize;

    public TypeSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)fElementRenderer, (ILabelProvider)fQualifierRenderer);
        this.setMatchEmptyString(false);
        this.setUpperListLabel(TypeInfoMessages.TypeSelectionDialog_upperLabel);
        this.setLowerListLabel(TypeInfoMessages.TypeSelectionDialog_lowerLabel);
        this.setVisibleTypes(ALL_TYPES);
        this.setDialogSettings(DIALOG_SETTINGS);
    }

    public void setFilter(String filter, boolean selectText) {
        super.setFilter(filter);
        this.fSelectFilterText = selectText;
    }

    public void setVisibleTypes(int[] types) {
        this.fKnownTypes.clear();
        int i = 0;
        while (i < types.length) {
            this.fKnownTypes.add(new Integer(types[i]));
            ++i;
        }
    }

    protected boolean isVisibleType(int type) {
        return this.fKnownTypes.contains(new Integer(type));
    }

    public void setDialogSettings(String section) {
        this.fDialogSection = String.valueOf(section) + "Settings";
    }

    protected Text createFilterText(Composite parent) {
        this.fTextWidget = super.createFilterText(parent);
        this.createTypeFilterArea(parent);
        return this.fTextWidget;
    }

    protected FilteredList createFilteredList(Composite parent) {
        this.fNewFilteredList = super.createFilteredList(parent);
        this.fNewFilteredList.setFilterMatcher((FilteredList.FilterMatcher)this.fFilterMatcher);
        this.fNewFilteredList.setComparator((Comparator)fStringComparator);
        if (this.fNewFilteredList != null) {
            this.fNewFilteredList.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = TypeInfoMessages.TypeSelectionDialog_upperLabel;
                }
            });
        }
        return this.fNewFilteredList;
    }

    public void create() {
        super.create();
        if (this.fSelectFilterText) {
            this.fTextWidget.selectAll();
        }
    }

    public boolean close() {
        this.writeSettings(this.getDialogSettings());
        return super.close();
    }

    protected Control createContents(Composite parent) {
        this.readSettings(this.getDialogSettings());
        return super.createContents(parent);
    }

    private void createTypeCheckbox(Composite parent, Integer typeObject) {
        String name;
        int type = typeObject;
        switch (type) {
            case 61: {
                name = TypeInfoMessages.TypeSelectionDialog_filterNamespaces;
                break;
            }
            case 65: {
                name = TypeInfoMessages.TypeSelectionDialog_filterClasses;
                break;
            }
            case 67: {
                name = TypeInfoMessages.TypeSelectionDialog_filterStructs;
                break;
            }
            case 80: {
                name = TypeInfoMessages.TypeSelectionDialog_filterTypedefs;
                break;
            }
            case 63: {
                name = TypeInfoMessages.TypeSelectionDialog_filterEnums;
                break;
            }
            case 69: {
                name = TypeInfoMessages.TypeSelectionDialog_filterUnions;
                break;
            }
            case 74: {
                name = TypeInfoMessages.TypeSelectionDialog_filterFunctions;
                break;
            }
            case 76: {
                name = TypeInfoMessages.TypeSelectionDialog_filterVariables;
                break;
            }
            case 81: {
                name = TypeInfoMessages.TypeSelectionDialog_filterEnumerators;
                break;
            }
            case 79: {
                name = TypeInfoMessages.TypeSelectionDialog_filterMacros;
                break;
            }
            default: {
                return;
            }
        }
        Image icon = TypeInfoLabelProvider.getTypeIcon(type);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        final Integer fTypeObject = typeObject;
        Button checkbox = new Button(composite, 32);
        checkbox.setFont(composite.getFont());
        checkbox.setImage(icon);
        checkbox.setSelection(this.fFilterMatcher.getVisibleTypes().contains(fTypeObject));
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    Button checkbox = (Button)e.widget;
                    if (checkbox.getSelection()) {
                        TypeSelectionDialog.this.fFilterMatcher.getVisibleTypes().add(fTypeObject);
                    } else {
                        TypeSelectionDialog.this.fFilterMatcher.getVisibleTypes().remove(fTypeObject);
                    }
                    TypeSelectionDialog.this.updateElements();
                }
            }
        });
        checkbox.setText(name);
    }

    private void createTypeFilterArea(Composite parent) {
        this.createLabel(parent, TypeInfoMessages.TypeSelectionDialog_filterLabel);
        Composite upperRow = new Composite(parent, 0);
        int columns = this.fKnownTypes.size() > 6 ? 4 : 3;
        GridLayout upperLayout = new GridLayout(columns, true);
        upperLayout.verticalSpacing = 2;
        upperLayout.marginHeight = 0;
        upperLayout.marginWidth = 0;
        upperRow.setLayout((Layout)upperLayout);
        int i = 0;
        while (i < ALL_TYPES.length) {
            Integer typeObject = new Integer(ALL_TYPES[i]);
            if (this.fKnownTypes.contains(typeObject)) {
                this.createTypeCheckbox(upperRow, typeObject);
            }
            ++i;
        }
        if (this.showLowLevelFilter()) {
            Composite lowerRow = new Composite(parent, 0);
            GridLayout lowerLayout = new GridLayout(1, true);
            lowerLayout.verticalSpacing = 2;
            lowerLayout.marginHeight = 0;
            upperLayout.marginWidth = 0;
            lowerRow.setLayout((Layout)lowerLayout);
            Composite composite = new Composite(lowerRow, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            String name = TypeInfoMessages.TypeSelectionDialog_filterLowLevelTypes;
            Button checkbox = new Button(composite, 32);
            checkbox.setFont(composite.getFont());
            checkbox.setText(name);
            checkbox.setSelection(this.fFilterMatcher.getShowLowLevelTypes());
            checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof Button) {
                        Button button = (Button)e.widget;
                        TypeSelectionDialog.this.fFilterMatcher.setShowLowLevelTypes(button.getSelection());
                        TypeSelectionDialog.this.updateElements();
                    }
                }
            });
        }
    }

    void updateElements() {
        this.fNewFilteredList.setFilter(this.fTextWidget.getText());
        this.handleSelectionChanged();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings allSettings = CUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = allSettings.getSection(this.fDialogSection);
        if (section == null) {
            section = allSettings.addNewSection(this.fDialogSection);
            this.writeDefaultSettings(section);
        }
        return section;
    }

    protected void writeSettings(IDialogSettings section) {
        Point location = this.getShell().getLocation();
        section.put(SETTINGS_X_POS, location.x);
        section.put(SETTINGS_Y_POS, location.y);
        if (this.getTray() == null) {
            Point size = this.getShell().getSize();
            section.put(SETTINGS_WIDTH, size.x);
            section.put(SETTINGS_HEIGHT, size.y);
        }
        section.put(SETTINGS_SHOW_NAMESPACES, this.fFilterMatcher.getVisibleTypes().contains(new Integer(61)));
        section.put(SETTINGS_SHOW_CLASSES, this.fFilterMatcher.getVisibleTypes().contains(new Integer(65)));
        section.put(SETTINGS_SHOW_STRUCTS, this.fFilterMatcher.getVisibleTypes().contains(new Integer(67)));
        section.put(SETTINGS_SHOW_TYPEDEFS, this.fFilterMatcher.getVisibleTypes().contains(new Integer(80)));
        section.put(SETTINGS_SHOW_ENUMS, this.fFilterMatcher.getVisibleTypes().contains(new Integer(63)));
        section.put(SETTINGS_SHOW_UNIONS, this.fFilterMatcher.getVisibleTypes().contains(new Integer(69)));
        section.put(SETTINGS_SHOW_FUNCTIONS, this.fFilterMatcher.getVisibleTypes().contains(new Integer(74)));
        section.put(SETTINGS_SHOW_VARIABLES, this.fFilterMatcher.getVisibleTypes().contains(new Integer(76)));
        section.put(SETTINGS_SHOW_ENUMERATORS, this.fFilterMatcher.getVisibleTypes().contains(new Integer(81)));
        section.put(SETTINGS_SHOW_MACROS, this.fFilterMatcher.getVisibleTypes().contains(new Integer(79)));
        section.put(SETTINGS_SHOW_LOWLEVEL, this.fFilterMatcher.getShowLowLevelTypes());
    }

    protected void writeDefaultSettings(IDialogSettings section) {
        section.put(SETTINGS_SHOW_NAMESPACES, true);
        section.put(SETTINGS_SHOW_CLASSES, true);
        section.put(SETTINGS_SHOW_STRUCTS, true);
        section.put(SETTINGS_SHOW_TYPEDEFS, true);
        section.put(SETTINGS_SHOW_ENUMS, true);
        section.put(SETTINGS_SHOW_UNIONS, true);
        section.put(SETTINGS_SHOW_FUNCTIONS, true);
        section.put(SETTINGS_SHOW_VARIABLES, true);
        section.put(SETTINGS_SHOW_ENUMERATORS, true);
        section.put(SETTINGS_SHOW_MACROS, true);
        section.put(SETTINGS_SHOW_LOWLEVEL, false);
    }

    protected void readSettings(IDialogSettings section) {
        Integer typeObject;
        try {
            int x = section.getInt(SETTINGS_X_POS);
            int y = section.getInt(SETTINGS_Y_POS);
            this.fLocation = new Point(x, y);
            int width = section.getInt(SETTINGS_WIDTH);
            int height = section.getInt(SETTINGS_HEIGHT);
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
            this.fSize = null;
        }
        if (section.getBoolean(SETTINGS_SHOW_NAMESPACES) && this.fKnownTypes.contains(typeObject = new Integer(61))) {
            this.fFilterMatcher.getVisibleTypes().add(typeObject);
        }
        if (section.getBoolean(SETTINGS_SHOW_CLASSES) && this.fKnownTypes.contains(typeObject = new Integer(65))) {
            this.fFilterMatcher.getVisibleTypes().add(typeObject);
        }
        if (section.getBoolean(SETTINGS_SHOW_STRUCTS) && this.fKnownTypes.contains(typeObject = new Integer(67))) {
            this.fFilterMatcher.getVisibleTypes().add(typeObject);
        }
        if (section.getBoolean(SETTINGS_SHOW_TYPEDEFS) && this.fKnownTypes.contains(typeObject = new Integer(80))) {
            this.fFilterMatcher.getVisibleTypes().add(typeObject);
        }
        if (section.getBoolean(SETTINGS_SHOW_ENUMS) && this.fKnownTypes.contains(typeObject = new Integer(63))) {
            this.fFilterMatcher.getVisibleTypes().add(typeObject);
        }
        if (section.getBoolean(SETTINGS_SHOW_UNIONS) && this.fKnownTypes.contains(typeObject = new Integer(69))) {
            this.fFilterMatcher.getVisibleTypes().add(typeObject);
        }
        if (section.getBoolean(SETTINGS_SHOW_FUNCTIONS) && this.fKnownTypes.contains(typeObject = new Integer(74))) {
            this.fFilterMatcher.getVisibleTypes().add(typeObject);
        }
        if (section.getBoolean(SETTINGS_SHOW_VARIABLES) && this.fKnownTypes.contains(typeObject = new Integer(76))) {
            this.fFilterMatcher.getVisibleTypes().add(typeObject);
        }
        if (section.getBoolean(SETTINGS_SHOW_ENUMERATORS) && this.fKnownTypes.contains(typeObject = new Integer(81))) {
            this.fFilterMatcher.getVisibleTypes().add(typeObject);
        }
        if (section.getBoolean(SETTINGS_SHOW_MACROS) && this.fKnownTypes.contains(typeObject = new Integer(79))) {
            this.fFilterMatcher.getVisibleTypes().add(typeObject);
        }
        if (this.showLowLevelFilter()) {
            this.fFilterMatcher.setShowLowLevelTypes(section.getBoolean(SETTINGS_SHOW_LOWLEVEL));
        } else {
            this.fFilterMatcher.setShowLowLevelTypes(true);
        }
    }

    protected boolean showLowLevelFilter() {
        return true;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.fSize != null) {
            result.x = Math.max(result.x, this.fSize.x);
            result.y = Math.max(result.y, this.fSize.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.fLocation != null) {
            int ye;
            result.x = this.fLocation.x;
            result.y = this.fLocation.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    protected void computeResult() {
        ITypeInfo selection = (ITypeInfo)this.getLowerSelectedElement();
        if (selection == null) {
            return;
        }
        ArrayList<ITypeInfo> result = new ArrayList<ITypeInfo>(1);
        result.add(selection);
        this.setResult(result);
    }

    public Object[] getFoldedElements(int index) {
        ArrayList<IndexTypeInfo> result = new ArrayList<IndexTypeInfo>();
        Object[] typeInfos = super.getFoldedElements(index);
        if (typeInfos != null) {
            Object[] objectArray = typeInfos;
            int n = typeInfos.length;
            int n2 = 0;
            while (n2 < n) {
                Object typeInfo = objectArray[n2];
                if (typeInfo instanceof IndexTypeInfo) {
                    this.addFoldedElements((IndexTypeInfo)typeInfo, result);
                }
                ++n2;
            }
        }
        return result.toArray();
    }

    private void addFoldedElements(IndexTypeInfo typeInfo, ArrayList<IndexTypeInfo> result) {
        ITypeReference[] refs;
        ITypeReference[] iTypeReferenceArray = refs = typeInfo.getReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeReference ref = iTypeReferenceArray[n2];
            result.add(IndexTypeInfo.create((IndexTypeInfo)typeInfo, (ITypeReference)ref));
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String left, String right) {
            int result = left.compareToIgnoreCase(right);
            if (result == 0) {
                result = left.compareTo(right);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeFilterMatcher
    implements FilteredList.FilterMatcher {
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private StringMatcher fNameMatcher = null;
        private StringMatcher[] fSegmentMatchers = null;
        private boolean fMatchGlobalNamespace = false;
        private Collection<Integer> fVisibleTypes = new HashSet<Integer>();
        private boolean fShowLowLevelTypes = false;

        private TypeFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
            QualifiedTypeName qualifiedName = new QualifiedTypeName(pattern);
            String[] segments = qualifiedName.segments();
            int length = segments.length;
            segments[length - 1] = TypeFilterMatcher.adjustPattern(segments[length - 1]);
            this.fMatchGlobalNamespace = false;
            this.fSegmentMatchers = new StringMatcher[length];
            int count = 0;
            int i = 0;
            while (i < length) {
                if (segments[i].length() > 0) {
                    this.fSegmentMatchers[count++] = new StringMatcher(segments[i], ignoreCase, ignoreWildCards);
                } else if (i == 0) {
                    this.fMatchGlobalNamespace = true;
                }
                ++i;
            }
            if (count != length) {
                if (count > 0) {
                    StringMatcher[] newMatchers = new StringMatcher[count];
                    System.arraycopy(this.fSegmentMatchers, 0, newMatchers, 0, count);
                    this.fSegmentMatchers = newMatchers;
                } else {
                    this.fSegmentMatchers = new StringMatcher[1];
                    this.fSegmentMatchers[0] = new StringMatcher(String.valueOf('*'), ignoreCase, ignoreWildCards);
                }
            }
            this.fNameMatcher = this.fSegmentMatchers[this.fSegmentMatchers.length - 1];
        }

        public Collection<Integer> getVisibleTypes() {
            return this.fVisibleTypes;
        }

        public void setShowLowLevelTypes(boolean show) {
            this.fShowLowLevelTypes = show;
        }

        public boolean getShowLowLevelTypes() {
            return this.fShowLowLevelTypes;
        }

        public boolean match(Object element) {
            if (!(element instanceof ITypeInfo)) {
                return false;
            }
            ITypeInfo info = (ITypeInfo)element;
            IQualifiedTypeName qualifiedName = info.getQualifiedTypeName();
            if (this.fVisibleTypes != null && !this.fVisibleTypes.contains(new Integer(info.getCElementType()))) {
                return false;
            }
            if (!this.fShowLowLevelTypes && qualifiedName.isLowLevel()) {
                return false;
            }
            if (this.fSegmentMatchers.length == 1 && !this.fMatchGlobalNamespace) {
                return this.fNameMatcher.match(qualifiedName.getName());
            }
            return this.matchQualifiedName(info);
        }

        private boolean matchQualifiedName(ITypeInfo info) {
            IQualifiedTypeName qualifiedName = info.getQualifiedTypeName();
            if (this.fSegmentMatchers.length != qualifiedName.segmentCount()) {
                return false;
            }
            if (this.fMatchGlobalNamespace && qualifiedName.segment(0).length() > 0) {
                return false;
            }
            boolean matchFound = true;
            int max = Math.min(this.fSegmentMatchers.length, qualifiedName.segmentCount());
            int i = 0;
            while (i < max) {
                StringMatcher matcher = this.fSegmentMatchers[i];
                String name = qualifiedName.segment(i);
                if (name == null || !matcher.match(name)) {
                    matchFound = false;
                    break;
                }
                ++i;
            }
            return matchFound;
        }

        private static String adjustPattern(String pattern) {
            int length = pattern.length();
            if (length > 0) {
                switch (pattern.charAt(length - 1)) {
                    case '<': {
                        return pattern.substring(0, length - 1);
                    }
                    case '*': {
                        return pattern;
                    }
                }
            }
            return String.valueOf(pattern) + '*';
        }
    }
}

