/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.cdtvariables.CdtVariable;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.cdtvariables.CoreMacroSupplierBase;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;
import org.eclipse.core.resources.IWorkspace;

public class EnvironmentVariableSupplier
extends CoreMacroSupplierBase {
    private static EnvironmentVariableSupplier fInstance;
    private EnvironmentVariableManager fEnvironmentProvider;

    protected EnvironmentVariableSupplier() {
        this(EnvironmentVariableManager.getDefault());
    }

    public EnvironmentVariableSupplier(EnvironmentVariableManager varProvider) {
        this.fEnvironmentProvider = varProvider;
    }

    private static boolean isTextList(String str, String delimiter) {
        if (delimiter == null || "".equals(delimiter)) {
            return false;
        }
        String patternStr = "([^" + delimiter + "]+" + delimiter + ")+[^" + delimiter + "]*";
        return Pattern.matches(patternStr, str);
    }

    public ICdtVariable createBuildMacro(IEnvironmentVariable var) {
        if (var != null) {
            return new EnvVarMacro(var);
        }
        return null;
    }

    public static EnvironmentVariableSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new EnvironmentVariableSupplier();
        }
        return fInstance;
    }

    public ICdtVariable getMacro(String macroName, int contextType, Object contextData) {
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        IEnvironmentVariable var = null;
        switch (contextType) {
            case 3: {
                if (!(contextData instanceof ICConfigurationDescription)) break;
                var = this.fEnvironmentProvider.getVariable(macroName, (ICConfigurationDescription)contextData, false);
                break;
            }
            case 5: {
                if (contextData != null && !(contextData instanceof IWorkspace)) break;
                var = this.fEnvironmentProvider.getVariable(macroName, null, false);
            }
        }
        if (var != null && var.getOperation() != 2) {
            return new EnvVarMacro(var);
        }
        return null;
    }

    public ICdtVariable[] getMacros(int contextType, Object contextData) {
        IEnvironmentVariable[] vars = null;
        switch (contextType) {
            case 3: {
                if (!(contextData instanceof ICConfigurationDescription)) break;
                vars = this.fEnvironmentProvider.getVariables((ICConfigurationDescription)contextData, false);
                break;
            }
            case 5: {
                if (contextData != null && !(contextData instanceof IWorkspace)) break;
                vars = this.fEnvironmentProvider.getVariables(null, false);
            }
        }
        if (vars != null) {
            ICdtVariable[] macros = new EnvVarMacro[vars.length];
            int i = 0;
            while (i < macros.length) {
                macros[i] = new EnvVarMacro(vars[i]);
                ++i;
            }
            return macros;
        }
        return null;
    }

    public class EnvVarMacro
    extends CdtVariable {
        private IEnvironmentVariable fVariable;

        private EnvVarMacro(IEnvironmentVariable var) {
            this.fName = var.getName();
            this.fVariable = var;
        }

        private void loadValue(IEnvironmentVariable var) {
            String value;
            String delimiter = var.getDelimiter();
            String string = value = var.getOperation() != 2 ? var.getValue() : null;
            if (EnvironmentVariableSupplier.isTextList(value, delimiter)) {
                this.fType = 2;
                if (value != null) {
                    List<String> list = EnvVarOperationProcessor.convertToList(value, delimiter);
                    this.fStringListValue = list.toArray(new String[list.size()]);
                } else {
                    this.fStringListValue = null;
                }
            } else {
                this.fType = 1;
                this.fStringValue = value;
            }
        }

        public int getValueType() {
            if (this.fVariable != null) {
                this.loadValue(this.fVariable);
                this.fVariable = null;
            }
            return super.getValueType();
        }

        public String getStringValue() throws CdtVariableException {
            if (this.fVariable != null) {
                this.loadValue(this.fVariable);
                this.fVariable = null;
            }
            return super.getStringValue();
        }

        public String[] getStringListValue() throws CdtVariableException {
            if (this.fVariable != null) {
                this.loadValue(this.fVariable);
                this.fVariable = null;
            }
            return super.getStringListValue();
        }
    }
}

