/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.edc.MessageLogger;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.internal.snapshot.ISnapshotAlbumEventListener;
import org.eclipse.cdt.debug.edc.internal.snapshot.Snapshot;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class EDCDebugUI
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.edc.ui";
    private static EDCDebugUI plugin;
    private IPreferenceStore preferenceStore;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.startSnapshotViewSupport();
    }

    private void startSnapshotViewSupport() {
        Album.addSnapshotAlbumEventListener((ISnapshotAlbumEventListener)new ISnapshotAlbumEventListener(){

            public void snapshotSessionEnded(Album album, DsfSession session) {
            }

            public void snapshotOpened(Snapshot snapshot) {
            }

            public void snapshotCreated(final Album album, final Snapshot snapshot, final DsfSession session, final Stack.StackFrameDMC stackFrame) {
                UIJob openViewJob = new UIJob("Open Snapshot Album View"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                        if (workbenchWindow != null) {
                            IWorkbenchPage page = workbenchWindow.getActivePage();
                            IViewPart snapshotView = page.findView("org.eclipse.cdt.debug.edc.ui.views.SnapshotView");
                            boolean firstTime = snapshotView == null;
                            try {
                                if (firstTime) {
                                    snapshotView = page.showView("org.eclipse.cdt.debug.edc.ui.views.SnapshotView");
                                    ((ISnapshotAlbumEventListener)snapshotView).snapshotCreated(album, snapshot, session, stackFrame);
                                } else if (!page.isPartVisible((IWorkbenchPart)snapshotView)) {
                                    snapshotView = page.showView("org.eclipse.cdt.debug.edc.ui.views.SnapshotView");
                                }
                            }
                            catch (PartInitException e) {
                                EDCDebugUI.logError("", e);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                openViewJob.schedule();
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static EDCDebugUI getDefault() {
        return plugin;
    }

    public static MessageLogger getMessageLogger() {
        return new MessageLogger(){

            public String getPluginID() {
                return EDCDebugUI.PLUGIN_ID;
            }

            public Plugin getPlugin() {
                return plugin;
            }
        };
    }

    public static BundleContext getBundleContext() {
        return EDCDebugUI.getDefault().getBundle().getBundleContext();
    }

    public static IStatus newErrorStatus(int errCode, String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, errCode, message, exception);
    }

    public static void logError(String message, Throwable t) {
        EDCDebugUI.getMessageLogger().log(4, message, t);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.cdt.debug.edc");
        }
        return this.preferenceStore;
    }

    public static IStatus dsfRequestFailedStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 10004, message, exception);
    }

    protected Shell getShell() {
        CDebugUIPlugin.getDefault();
        IWorkbenchWindow w = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getShell();
        }
        return null;
    }

    public ICProject chooseCProject() {
        Object[] projects;
        block5: {
            projects = CoreModel.getDefault().getCModel().getCProjects();
            if (projects.length != 0) break block5;
            return null;
        }
        try {
            if (projects.length == 1) {
                return projects[0];
            }
            CElementLabelProvider labelProvider = new CElementLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle("Project Selection");
            dialog.setMessage("Choose Project");
            dialog.setElements(projects);
            if (dialog.open() == 0) {
                return (ICProject)dialog.getFirstResult();
            }
        }
        catch (CModelException e) {
            EDCDebugUI.getMessageLogger().logError(null, (Throwable)e);
        }
        return null;
    }
}

