/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.debug.edc.ITCFAgentLauncher;
import org.eclipse.cdt.debug.edc.ITCFConnectionListener;
import org.eclipse.cdt.debug.edc.ITCFServiceManager;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.WaitForResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tm.tcf.core.AbstractPeer;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILocator;
import org.eclipse.tm.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFServiceManager
implements ITCFServiceManager {
    private static List<String> localIPAddresses;
    private List<ITCFAgentLauncher> tcfAgentLaunchers;
    private static final String EXTENSION_POINT_NAME = "tcfAgentLauncher";
    private List<ITCFAgentLauncher> launchedtcfAgentLaunchers;
    private ListenerList peerChannelListeners = new ListenerList();

    static {
        try {
            localIPAddresses = TCFServiceManager.getLocalIPAddresses();
        }
        catch (CoreException e) {
            EDCDebugger.getMessageLogger().logError("Problem getting local IP addresses", e);
        }
    }

    public TCFServiceManager() {
        IExtension[] extensions;
        this.tcfAgentLaunchers = new ArrayList<ITCFAgentLauncher>();
        this.launchedtcfAgentLaunchers = new ArrayList<ITCFAgentLauncher>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.cdt.debug.edc", EXTENSION_POINT_NAME);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement element = elements[0];
            boolean failed = false;
            CoreException exc = null;
            try {
                Object extObject = element.createExecutableExtension("class");
                if (extObject instanceof ITCFAgentLauncher) {
                    this.tcfAgentLaunchers.add((ITCFAgentLauncher)extObject);
                } else {
                    failed = true;
                }
            }
            catch (CoreException e) {
                failed = true;
                exc = e;
            }
            if (failed) {
                EDCDebugger.getMessageLogger().logError("Unable to load tcfAgentLauncher extension from " + extension.getContributor().getName(), exc);
            }
            ++n2;
        }
    }

    public static boolean matchesAllAttributes(Map<String, String> attributes, Map<String, String> attributesToMatch) {
        if (attributesToMatch.isEmpty()) {
            return false;
        }
        for (String key : attributesToMatch.keySet()) {
            if (!attributes.containsKey(key)) {
                return false;
            }
            if (attributesToMatch.get(key).equals(attributes.get(key))) continue;
            return false;
        }
        return true;
    }

    public static boolean isInternalLocalPeer(IPeer p) {
        assert (Protocol.isDispatchThread());
        return p.getID().equals("TCFLocal");
    }

    public ITCFAgentLauncher[] findSuitableAgentLaunchers(String serviceName, Map<String, String> attributesToMatch, boolean localAgentsOnly) {
        ArrayList<String> registeredPeerLabels = new ArrayList<String>();
        ArrayList<ITCFAgentLauncher> registeredAgents = new ArrayList<ITCFAgentLauncher>();
        for (ITCFAgentLauncher descriptor : this.tcfAgentLaunchers) {
            if (!descriptor.getServiceNames().contains(serviceName) || !TCFServiceManager.matchesAllAttributes(descriptor.getPeerAttributes(), attributesToMatch) || !descriptor.isLaunchable()) continue;
            registeredPeerLabels.add(String.valueOf(descriptor.getPeerName()) + " (local registered non-started)");
            registeredAgents.add(descriptor);
        }
        return registeredAgents.toArray(new ITCFAgentLauncher[registeredAgents.size()]);
    }

    public IPeer[] getRunningPeers(final String serviceName, final Map<String, String> attributesToMatch, final boolean localAgentsOnly) throws CoreException {
        final ArrayList runningCandidates1 = new ArrayList();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                Collection peers = Protocol.getLocator().getPeers().values();
                for (IPeer p : peers) {
                    if (TCFServiceManager.isInternalLocalPeer(p) || !TCFServiceManager.matchesAllAttributes(p.getAttributes(), attributesToMatch)) continue;
                    runningCandidates1.add(p);
                }
            }
        });
        final ArrayList runningCandidates2 = new ArrayList();
        final ArrayList runningLocalAgentPorts = new ArrayList();
        for (final IPeer peer : runningCandidates1) {
            TCFTask<Object> task = new TCFTask<Object>(3000L){

                public void run() {
                    IChannel ch;
                    String port;
                    final boolean isLocalAgent = TCFServiceManager.isInLocalAgent(peer);
                    if (isLocalAgent && (port = (String)peer.getAttributes().get("Port")) != null) {
                        if (runningLocalAgentPorts.contains(port)) {
                            this.done((Object)this);
                            return;
                        }
                        runningLocalAgentPorts.add(port);
                    }
                    if ((ch = TCFServiceManager.this.getChannelForPeer(peer)) != null) {
                        if (!$assertionsDisabled && ch.getState() != 1) {
                            throw new AssertionError();
                        }
                        if (ch.getRemoteService(serviceName) != null && (isLocalAgent || !localAgentsOnly)) {
                            runningCandidates2.add(peer);
                        }
                        this.done((Object)this);
                    } else {
                        final IChannel channel = peer.openChannel();
                        IChannel.IChannelListener listener = new IChannel.IChannelListener(){

                            public void onChannelOpened() {
                                if (channel.getRemoteService(serviceName) != null && (isLocalAgent || !localAgentsOnly)) {
                                    runningCandidates2.add(peer);
                                }
                                TCFServiceManager.this.fireConnectionOpened(peer, channel);
                                this.done(this);
                            }

                            public void onChannelClosed(Throwable error) {
                                TCFServiceManager.this.fireConnectionClosed(peer, channel, error);
                                channel.removeChannelListener((IChannel.IChannelListener)this);
                            }

                            public void congestionLevel(int level) {
                            }
                        };
                        channel.addChannelListener(listener);
                    }
                }
            };
            try {
                task.get();
            }
            catch (Exception exception) {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    public void run() {
                        try {
                            ((AbstractPeer)peer).dispose();
                        }
                        catch (AssertionError assertionError) {}
                    }
                });
            }
        }
        return runningCandidates2.toArray(new IPeer[runningCandidates2.size()]);
    }

    public static boolean isInLocalAgent(IPeer peer) {
        assert (Protocol.isDispatchThread());
        String ipHost = (String)peer.getAttributes().get("Host");
        return localIPAddresses.contains(ipHost);
    }

    @Override
    public IChannel findOrCreateChannelForPeer(final IPeer peer) throws CoreException {
        IChannel channel = null;
        channel = this.getChannelForPeer(peer);
        if (channel != null) {
            return channel;
        }
        assert (!Protocol.isDispatchThread());
        final WaitForResult waitForChannel = new WaitForResult();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                try {
                    final IChannel newChannel = peer.openChannel();
                    newChannel.addChannelListener(new IChannel.IChannelListener(){

                        public void onChannelOpened() {
                            waitForChannel.setData(newChannel);
                            TCFServiceManager.this.fireConnectionOpened(peer, newChannel);
                        }

                        public void onChannelClosed(Throwable error) {
                            waitForChannel.handleException(error);
                            TCFServiceManager.this.fireConnectionClosed(peer, newChannel, error);
                            newChannel.removeChannelListener((IChannel.IChannelListener)this);
                        }

                        public void congestionLevel(int level) {
                        }
                    });
                }
                catch (Throwable exc) {
                    waitForChannel.handleException(exc);
                }
            }
        });
        try {
            channel = (IChannel)waitForChannel.get(15L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw EDCDebugger.newCoreException("Failed to open channel for " + peer.getID(), e);
        }
        catch (Exception e) {
            throw EDCDebugger.newCoreException("Time out getting open channel for peer.", e);
        }
        return channel;
    }

    @Override
    public IChannel getChannelForPeer(final IPeer peer) {
        final IChannel[] ret = new IChannel[1];
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                IChannel[] channels;
                String peerName = peer.getName();
                String peerID = peer.getID();
                IChannel[] iChannelArray = channels = Protocol.getOpenChannels();
                int n = channels.length;
                int n2 = 0;
                while (n2 < n) {
                    IChannel channel = iChannelArray[n2];
                    IPeer remotePeer = channel.getRemotePeer();
                    if (remotePeer.getName().equals(peerName) && remotePeer.getID().equals(peerID)) {
                        ret[0] = channel;
                        return;
                    }
                    ++n2;
                }
            }
        });
        return ret[0];
    }

    public IService getPeerService(IPeer peer, final String serviceName) throws CoreException {
        final WaitForResult waitForService = new WaitForResult();
        final IChannel channel = this.findOrCreateChannelForPeer(peer);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                try {
                    IService service = channel.getRemoteService(serviceName);
                    if (service == null) {
                        service = new IService(){

                            public String getName() {
                                return null;
                            }
                        };
                    }
                    waitForService.setData(service);
                }
                catch (Exception e) {
                    waitForService.handleException(e);
                }
            }
        });
        try {
            IService service = (IService)waitForService.get();
            return service.getName() == null ? null : service;
        }
        catch (Exception e) {
            throw EDCDebugger.newCoreException("Fail to get TCF service [" + serviceName + "] from peer.", e);
        }
    }

    public IPeer launchAgent(ITCFAgentLauncher descriptor, final Map<String, String> peerAttrs) throws CoreException {
        final WaitForResult<IPeer> waitForPeer = new WaitForResult<IPeer>(){};
        final ILocator.LocatorListener listener = new ILocator.LocatorListener(){

            public void peerRemoved(String id) {
            }

            public void peerHeartBeat(String id) {
            }

            public void peerChanged(IPeer peer) {
            }

            public void peerAdded(IPeer peer) {
                if (TCFServiceManager.matchesAllAttributes(peer.getAttributes(), peerAttrs)) {
                    waitForPeer.setData(peer);
                }
            }
        };
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                Protocol.getLocator().addListener(listener);
            }
        });
        IPeer launchedPeer = null;
        try {
            try {
                descriptor.launch();
            }
            catch (Exception e) {
                throw EDCDebugger.newCoreException(MessageFormat.format("Failed to launch the TCF agent that hosts peer \"{0}\". Cause: {1}", descriptor.getPeerName(), e.getLocalizedMessage()), e);
            }
            try {
                launchedPeer = (IPeer)waitForPeer.get();
            }
            catch (Exception e) {
                if (e.getCause() instanceof TimeoutException) {
                    throw EDCDebugger.newCoreException(MessageFormat.format("Timed out waiting for the launched TCF agent to make peer \"{0}\" available.", descriptor.getPeerName()), null);
                }
                throw EDCDebugger.newCoreException(MessageFormat.format("Error waiting for the launched TCF agent to make peer \"{0}\" available. Cause: {1}", descriptor.getPeerName(), e.getLocalizedMessage()), e);
            }
            this.launchedtcfAgentLaunchers.add(descriptor);
        }
        catch (Throwable throwable) {
            Protocol.invokeAndWait((Runnable)new Runnable(listener){
                private final /* synthetic */ ILocator.LocatorListener val$listener;
                {
                    this.val$listener = locatorListener;
                }

                public void run() {
                    Protocol.getLocator().removeListener(this.val$listener);
                }
            });
            throw throwable;
        }
        Protocol.invokeAndWait((Runnable)new /* invalid duplicate definition of identical inner class */);
        return launchedPeer;
    }

    /*
     * Unable to fully structure code
     */
    private static List<String> getLocalIPAddresses() throws CoreException {
        ret = new ArrayList<String>();
        try {
            e = NetworkInterface.getNetworkInterfaces();
            if (true) ** GOTO lbl15
        }
        catch (SocketException v0) {
            throw EDCDebugger.newCoreException("Host is required to connect to a network but it isn't.");
        }
        do {
            f = e.nextElement();
            n = f.getInetAddresses();
            while (n.hasMoreElements()) {
                addr = n.nextElement();
                ret.add(addr.getHostAddress());
            }
lbl15:
            // 2 sources

        } while (e.hasMoreElements());
        try {
            localHost = InetAddress.getLocalHost();
            if (localHost != null) {
                ret.add(localHost.getHostName());
                ret.add(localHost.getCanonicalHostName());
            }
        }
        catch (UnknownHostException exc) {
            EDCDebugger.getMessageLogger().logError("", exc);
        }
        return ret;
    }

    public void shutdown() {
        for (ITCFAgentLauncher desc : this.launchedtcfAgentLaunchers) {
            try {
                desc.shutdown();
            }
            catch (Exception exception) {}
        }
        this.launchedtcfAgentLaunchers.clear();
    }

    @Override
    public void addConnectionListener(ITCFConnectionListener listener) {
        this.peerChannelListeners.add((Object)listener);
    }

    @Override
    public void removeConnectionListener(ITCFConnectionListener listener) {
        this.peerChannelListeners.remove((Object)listener);
    }

    protected void fireConnectionOpened(final IPeer peer, final IChannel channel) {
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                Object[] objectArray = TCFServiceManager.this.peerChannelListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    try {
                        ((ITCFConnectionListener)o).peerChannelOpened(peer, channel);
                    }
                    catch (Throwable t) {
                        EDCDebugger.getMessageLogger().logError("Exception thrown from connection listener", t);
                    }
                    ++n2;
                }
            }
        });
    }

    protected void fireConnectionClosed(final IPeer peer, final IChannel channel, final Throwable exception) {
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                Object[] objectArray = TCFServiceManager.this.peerChannelListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    try {
                        ((ITCFConnectionListener)o).peerChannelClosed(peer, channel, exception);
                    }
                    catch (Throwable t) {
                        EDCDebugger.getMessageLogger().logError("Exception thrown from connection listener", t);
                    }
                    ++n2;
                }
            }
        });
    }
}

