/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import java.text.MessageFormat;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.ArrayDimensionType;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.CompoundInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.IArrayDimensionType;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.IAggregate;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.IBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.IEnumeration;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.ITypedef;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.debug.edc.symbols.VariableLocationFactory;
import org.eclipse.core.runtime.CoreException;

public class ArraySubscript
extends CompoundInstruction {
    public ArraySubscript(int start) {
        super(start);
    }

    public void execute() throws CoreException {
        OperandValue subscriptOperand = this.popValue();
        OperandValue variableOperand = this.popValue();
        long subscript = 0L;
        if (subscriptOperand.isFloating()) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.ArraySubscript_SubscriptMustBeInteger);
        }
        subscript = subscriptOperand.getLongValue();
        IType variableType = TypeUtils.getStrippedType(variableOperand.getValueType());
        IVariableLocation location = null;
        IType arrayElementType = variableType instanceof IArrayDimensionType ? TypeUtils.getStrippedType(((IArrayDimensionType)((Object)variableType)).getArrayType().getType()) : TypeUtils.getStrippedType(variableType.getType());
        if (arrayElementType == null) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.ArraySubscript_MustSubscriptArray);
        }
        int byteSize = variableType instanceof IArrayType ? variableType.getByteSize() : arrayElementType.getByteSize();
        IVariableLocation varLocation = variableOperand.getValueLocation();
        if (varLocation == null) {
            String stringValue = variableOperand.getStringValue();
            if (stringValue != null) {
                if (subscript < (long)stringValue.length()) {
                    this.pushNewValue(arrayElementType, (int)stringValue.charAt((int)subscript));
                } else if (subscript == (long)stringValue.length()) {
                    this.pushNewValue(arrayElementType, 0);
                } else {
                    throw EDCDebugger.newCoreException(ASTEvalMessages.ArraySubscript_ReadingPastEndOfString);
                }
                return;
            }
            throw EDCDebugger.newCoreException(ASTEvalMessages.ArraySubscript_CannotIndirectTemporary);
        }
        if (variableType instanceof IPointerType) {
            IPointerType pointerType = (IPointerType)variableType;
            BigInteger ptrValue = varLocation.readValue(pointerType.getByteSize());
            location = VariableLocationFactory.createMemoryVariableLocation(this.fInterpreter.getServicesTracker(), this.fInterpreter.getContext(), ptrValue.add(BigInteger.valueOf((long)byteSize * subscript)));
            OperandValue op = new OperandValue(pointerType.getType());
            op.setValueLocation(VariableLocationFactory.createMemoryVariableLocation(this.fInterpreter.getServicesTracker(), this.fInterpreter.getContext(), location.getAddress().getValue()));
            Number newValue = op.getValueByType(op.getValueType(), op.getValueLocation());
            op.setValue(newValue);
            this.push(op);
            return;
        }
        if (variableType instanceof IArrayType) {
            IArrayType arrayType = (IArrayType)variableType;
            if (arrayType.getBoundsCount() == 0) {
                throw EDCDebugger.newCoreException(ASTEvalMessages.ArraySubscript_ArrayHasNoBounds);
            }
            location = varLocation.addOffset(arrayType.getBounds()[0].getElementCount() * (long)byteSize * subscript);
            if (arrayType.getBoundsCount() == 1) {
                this.pushArrayElement(variableOperand, location, arrayElementType);
            } else {
                String name = String.valueOf(variableOperand.getValueType().getName()) + "[" + subscript + "]";
                ArrayDimensionType arrayDimensionType = new ArrayDimensionType(name, variableOperand, arrayType, location);
                OperandValue opValue = new OperandValue(arrayDimensionType);
                opValue.setAddressValue(location);
                opValue.setValueLocation(location);
                this.push(opValue);
            }
            return;
        }
        if (!(variableType instanceof IArrayDimensionType)) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.ArraySubscript_MustSubscriptArray);
        }
        ArrayDimensionType arrayDimension = (ArrayDimensionType)variableType;
        IArrayType arrayType = arrayDimension.getArrayType();
        arrayElementType = TypeUtils.getStrippedType(arrayType.getType());
        byteSize = arrayElementType.getByteSize();
        if (arrayElementType instanceof ITypedef) {
            byteSize = TypeUtils.getStrippedType(arrayElementType.getType()).getByteSize();
        }
        arrayDimension.addDimension(subscript, arrayType.getBound(arrayDimension.getDimensionCount()).getElementCount() * (long)byteSize * subscript);
        location = arrayDimension.getLocation();
        if (arrayDimension.getDimensionCount() >= arrayType.getBoundsCount()) {
            this.pushArrayElement(arrayDimension.getOperandValue(), location, arrayElementType);
        } else {
            variableOperand.setAddressValue(location);
            variableOperand.setValueLocation(location);
            this.push(variableOperand);
        }
    }

    private void pushArrayElement(OperandValue originalVariableValue, IVariableLocation location, IType arrayElementType) throws CoreException {
        OperandValue varValue = new OperandValue(arrayElementType);
        varValue.setValueLocation(location);
        if (arrayElementType instanceof IBasicType || arrayElementType instanceof IEnumeration || arrayElementType instanceof IPointerType) {
            int byteSize = arrayElementType.getByteSize();
            if (byteSize != 1 && byteSize != 2 && byteSize != 4 && byteSize != 8) {
                throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.UnhandledSize, byteSize));
            }
            Number newValue = originalVariableValue.getValueByType(arrayElementType, location);
            varValue.setValue(newValue);
            this.push(varValue);
        } else if (arrayElementType instanceof IAggregate) {
            varValue.setAddressValue(location);
            this.push(varValue);
        } else {
            throw EDCDebugger.newCoreException(ASTEvalMessages.ArraySubscript_ErrorDereferencingArray);
        }
    }
}

