/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.edc.ITCFAgentLauncher;
import org.eclipse.cdt.debug.edc.ITCFConnectionListener;
import org.eclipse.cdt.debug.edc.ITCFServiceManager;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.TCFServiceManager;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Breakpoints;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Memory;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Processes;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.launch.ChooseProcessItem;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.launch.LaunchUtils;
import org.eclipse.cdt.debug.edc.services.IDSFServiceUsingTCF;
import org.eclipse.cdt.debug.edc.services.Registers;
import org.eclipse.cdt.debug.edc.tcf.extension.services.ISimpleRegisters;
import org.eclipse.cdt.debug.edc.tcf.extension.services.SimpleRegistersProxy;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IProcesses;
import org.eclipse.tm.tcf.util.TCFTask;

public abstract class AbstractFinalLaunchSequence
extends Sequence {
    private EDCLaunch launch;
    protected DsfServicesTracker tracker;
    protected List<Sequence.Step> steps = new ArrayList<Sequence.Step>();
    private IPeer tcfPeer;
    protected final Map<String, String> peerAttributes = new HashMap<String, String>();
    protected final Sequence.Step trackerStep = new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            AbstractFinalLaunchSequence.this.tracker = new DsfServicesTracker(EDCDebugger.getDefault().getBundle().getBundleContext(), AbstractFinalLaunchSequence.this.launch.getSession().getId());
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            if (AbstractFinalLaunchSequence.this.tracker != null) {
                AbstractFinalLaunchSequence.this.tracker.dispose();
            }
            AbstractFinalLaunchSequence.this.tracker = null;
            requestMonitor.done();
        }
    };
    protected final Sequence.Step cleanupStep = new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            AbstractFinalLaunchSequence.this.tracker.dispose();
            AbstractFinalLaunchSequence.this.tracker = null;
            requestMonitor.done();
        }
    };
    protected Sequence.Step initFindPeerStep = new Sequence.Step(){

        public String getTaskName() {
            return "Find or launch TCF peer";
        }

        public void execute(RequestMonitor requestMonitor) {
            AbstractFinalLaunchSequence.this.findPeer(requestMonitor);
            requestMonitor.done();
        }
    };
    protected Sequence.Step rememberTCFChannelStep = new Sequence.StepWithProgress(){

        public String getTaskName() {
            return "Remember TCF Channel";
        }

        public void execute(RequestMonitor rm, IProgressMonitor pm) {
            try {
                IPeer peer = AbstractFinalLaunchSequence.this.getTCFPeer();
                if (!$assertionsDisabled && peer == null) {
                    throw new AssertionError((Object)"initFindPeerStep must be run prior to this one");
                }
                ITCFServiceManager tcfServiceManager = EDCDebugger.getDefault().getServiceManager();
                IChannel channel = tcfServiceManager.getChannelForPeer(peer);
                if (channel == null) {
                    if (!$assertionsDisabled && channel == null) {
                        throw new AssertionError((Object)"No open channel found to the peer");
                    }
                } else {
                    AbstractFinalLaunchSequence.this.launch.usingTCFChannel(channel);
                }
            }
            finally {
                rm.done();
            }
        }
    };
    protected Sequence.Step initDetectConnectionErrorStep = new Sequence.Step(){
        final TCFConnectionListener peerListener = new TCFConnectionListener();

        public String getTaskName() {
            return "Init connection error listener";
        }

        public void execute(RequestMonitor requestMonitor) {
            IPeer thePeer = AbstractFinalLaunchSequence.this.getTCFPeer();
            if (thePeer != null) {
                EDCDebugger.getDefault().getServiceManager().addConnectionListener(this.peerListener);
                IChannel channel = EDCDebugger.getDefault().getServiceManager().getChannelForPeer(thePeer);
                if (channel != null && channel.getState() == 1) {
                    this.peerListener.peerChannelOpened(thePeer, channel);
                }
            }
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor rm) {
            EDCDebugger.getDefault().getServiceManager().removeConnectionListener(this.peerListener);
            super.rollBack(rm);
        }

        class TCFConnectionListener
        implements ITCFConnectionListener {
            private IChannel myPeerChannel;

            TCFConnectionListener() {
            }

            public void peerChannelOpened(IPeer peer, IChannel channel) {
                if (peer == AbstractFinalLaunchSequence.this.getTCFPeer()) {
                    this.myPeerChannel = channel;
                }
            }

            public void peerChannelClosed(IPeer peer, IChannel channel, Throwable error) {
                if (peer == AbstractFinalLaunchSequence.this.getTCFPeer() && channel == this.myPeerChannel) {
                    try {
                        AbstractFinalLaunchSequence.this.handleConnectionClosed(channel, error);
                    }
                    finally {
                        EDCDebugger.getDefault().getServiceManager().removeConnectionListener(this);
                    }
                }
            }
        }
    };
    protected Sequence.Step initRunControlStep = new Sequence.Step(){

        public String getTaskName() {
            return "Init RunControl service";
        }

        public void execute(RequestMonitor requestMonitor) {
            if (!$assertionsDisabled && AbstractFinalLaunchSequence.this.getTCFPeer() == null) {
                throw new AssertionError((Object)"initFindPeerStep must be run prior to this one");
            }
            RunControl runcontrol = (RunControl)AbstractFinalLaunchSequence.this.tracker.getService(RunControl.class);
            AbstractFinalLaunchSequence.this.findTCFServiceForDSFService(runcontrol, "RunControl", requestMonitor);
            requestMonitor.done();
        }
    };
    protected Sequence.Step initRegistersServiceStep = new Sequence.Step(){

        public String getTaskName() {
            return "Init Registers service";
        }

        public void execute(final RequestMonitor requestMonitor) {
            IPeer peer = AbstractFinalLaunchSequence.this.getTCFPeer();
            if (!$assertionsDisabled && peer == null) {
                throw new AssertionError((Object)"initFindPeerStep must be run prior to this one");
            }
            final Registers registers = (Registers)AbstractFinalLaunchSequence.this.tracker.getService(Registers.class);
            ITCFServiceManager tcfServiceManager = EDCDebugger.getDefault().getServiceManager();
            final IChannel channel = tcfServiceManager.getChannelForPeer(peer);
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    IService regSvc = null;
                    try {
                        regSvc = AbstractFinalLaunchSequence.this.getTCFService("Registers");
                    }
                    catch (CoreException coreException) {}
                    if (regSvc != null) {
                        registers.tcfServiceReady(regSvc);
                    } else {
                        try {
                            regSvc = AbstractFinalLaunchSequence.this.getTCFService("SimpleRegisters");
                        }
                        catch (CoreException coreException) {}
                        if (regSvc == null) {
                            requestMonitor.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "Fail to find Registers service in agent."));
                        } else {
                            ISimpleRegisters simpleRegProxy = (ISimpleRegisters)channel.getRemoteService(ISimpleRegisters.class);
                            if (simpleRegProxy == null) {
                                simpleRegProxy = new SimpleRegistersProxy(channel);
                                channel.setServiceProxy(ISimpleRegisters.class, (IService)simpleRegProxy);
                            }
                            registers.tcfServiceReady((IService)simpleRegProxy);
                        }
                    }
                    requestMonitor.done();
                }
            });
        }
    };
    protected Sequence.Step initMemoryServiceStep = new Sequence.Step(){

        public String getTaskName() {
            return "Init Memory service";
        }

        public void execute(RequestMonitor requestMonitor) {
            if (!$assertionsDisabled && AbstractFinalLaunchSequence.this.getTCFPeer() == null) {
                throw new AssertionError((Object)"initFindPeerStep must be run prior to this one");
            }
            Memory memory = (Memory)AbstractFinalLaunchSequence.this.tracker.getService(Memory.class);
            AbstractFinalLaunchSequence.this.findTCFServiceForDSFService(memory, "Memory", requestMonitor);
            requestMonitor.done();
        }
    };
    protected Sequence.Step initBreakpointsServiceStep = new Sequence.Step(){

        public String getTaskName() {
            return "Init Breakpoints service";
        }

        public void execute(RequestMonitor requestMonitor) {
            if (!$assertionsDisabled && AbstractFinalLaunchSequence.this.getTCFPeer() == null) {
                throw new AssertionError((Object)"initFindPeerStep must be run prior to this one");
            }
            Breakpoints breakpoints = (Breakpoints)AbstractFinalLaunchSequence.this.tracker.getService(Breakpoints.class);
            AbstractFinalLaunchSequence.this.findTCFServiceForDSFService(breakpoints, "Breakpoints", requestMonitor);
            requestMonitor.done();
        }
    };
    protected Sequence.Step initProcessesServiceStep = new Sequence.Step(){

        public String getTaskName() {
            return "Init Processes service";
        }

        public void execute(RequestMonitor requestMonitor) {
            if (!$assertionsDisabled && AbstractFinalLaunchSequence.this.getTCFPeer() == null) {
                throw new AssertionError((Object)"initFindPeerStep must be run prior to this one");
            }
            Processes p = (Processes)AbstractFinalLaunchSequence.this.tracker.getService(Processes.class);
            AbstractFinalLaunchSequence.this.findTCFServiceForDSFService(p, "Processes", requestMonitor);
            requestMonitor.done();
        }
    };
    protected Sequence.Step launchStep = new Sequence.Step(){

        public String getTaskName() {
            return "Launch target";
        }

        public void execute(RequestMonitor requestMonitor) {
            IService service;
            if (!$assertionsDisabled && AbstractFinalLaunchSequence.this.getTCFPeer() == null) {
                throw new AssertionError((Object)"initFindPeerStep must be run prior to this one");
            }
            try {
                service = AbstractFinalLaunchSequence.this.getTCFService("Processes");
            }
            catch (CoreException e1) {
                requestMonitor.setStatus(e1.getStatus());
                requestMonitor.done();
                return;
            }
            AbstractFinalLaunchSequence.this.launchProcess((ILaunch)AbstractFinalLaunchSequence.this.launch, (IProcesses)service, requestMonitor);
        }
    };
    protected Sequence.Step attachStep = new Sequence.Step(){

        public String getTaskName() {
            return "Attach";
        }

        public void execute(RequestMonitor requestMonitor) {
            IService service;
            if (!$assertionsDisabled && AbstractFinalLaunchSequence.this.getTCFPeer() == null) {
                throw new AssertionError((Object)"initFindPeerStep must be run prior to this one");
            }
            try {
                service = AbstractFinalLaunchSequence.this.getTCFService("Processes");
            }
            catch (CoreException e1) {
                requestMonitor.setStatus(e1.getStatus());
                requestMonitor.done();
                return;
            }
            AbstractFinalLaunchSequence.this.attachProcess(AbstractFinalLaunchSequence.this.launch, (IProcesses)service, requestMonitor);
        }
    };

    protected IService getTCFService(String tcfServiceName) throws CoreException {
        TCFServiceManager tcfServiceManager = (TCFServiceManager)EDCDebugger.getDefault().getServiceManager();
        return tcfServiceManager.getPeerService(this.getTCFPeer(), tcfServiceName);
    }

    protected void findPeer(RequestMonitor requestMonitor) {
        try {
            int index;
            ITCFAgentLauncher[] agentLaunchers;
            int index2;
            boolean useLocalAgentOnly;
            if (this.getTCFPeer() != null) {
                return;
            }
            this.tcfPeer = this.selectExplicitPeer();
            if (this.tcfPeer != null) {
                return;
            }
            TCFServiceManager tcfServiceManager = (TCFServiceManager)EDCDebugger.getDefault().getServiceManager();
            IPeer[] runningPeers = tcfServiceManager.getRunningPeers("RunControl", this.peerAttributes, useLocalAgentOnly = this.useLocalAgentOnly());
            if (runningPeers.length > 0 && (index2 = this.selectPeer(runningPeers)) >= 0 && index2 < runningPeers.length) {
                this.tcfPeer = runningPeers[index2];
                return;
            }
            ArrayList<IPeer> launchedPeers = new ArrayList<IPeer>();
            ITCFAgentLauncher[] iTCFAgentLauncherArray = agentLaunchers = tcfServiceManager.findSuitableAgentLaunchers("RunControl", this.peerAttributes, useLocalAgentOnly);
            int n = agentLaunchers.length;
            int n2 = 0;
            while (n2 < n) {
                ITCFAgentLauncher agentLauncher = iTCFAgentLauncherArray[n2];
                IPeer peer = tcfServiceManager.launchAgent(agentLauncher, this.peerAttributes);
                if (peer != null) {
                    launchedPeers.add(peer);
                }
                ++n2;
            }
            if (launchedPeers.size() > 0 && (index = this.selectPeer(launchedPeers.toArray(new IPeer[launchedPeers.size()]))) >= 0 && index < launchedPeers.size()) {
                this.tcfPeer = (IPeer)launchedPeers.get(index);
                return;
            }
            requestMonitor.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "Could not find a suitable TCF peer", null));
        }
        catch (CoreException e) {
            requestMonitor.setStatus(e.getStatus());
        }
    }

    protected IPeer selectExplicitPeer() throws CoreException {
        return null;
    }

    public int selectPeer(IPeer[] peers) {
        assert (peers.length > 0);
        return 0;
    }

    protected void findTCFServiceForDSFService(IDSFServiceUsingTCF dsfService, String tcfServiceName, RequestMonitor rm) {
        try {
            IService service = this.getTCFService(tcfServiceName);
            if (service == null) {
                throw EDCDebugger.newCoreException("Required service \"" + tcfServiceName + "\" is not available.");
            }
            dsfService.tcfServiceReady(service);
        }
        catch (CoreException e1) {
            if (e1.getStatus().matches(8)) {
                rm.cancel();
            }
            rm.setStatus(e1.getStatus());
        }
    }

    public AbstractFinalLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm) {
        this(executor, launch, pm, "Configuring Debugger", "Aborting configuring debugger");
    }

    public AbstractFinalLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm, String sequenceName, String abortName) {
        super(executor, pm, sequenceName, abortName);
        this.launch = launch;
        this.specifyRequiredPeer();
    }

    public Sequence.Step[] getSteps() {
        return this.steps.toArray(new Sequence.Step[this.steps.size()]);
    }

    protected void launchProcess(ILaunch launch, final IProcesses ps, final RequestMonitor requestMonitor) {
        try {
            ILaunchConfiguration cfg = launch.getLaunchConfiguration();
            ICProject cproject = LaunchUtils.getCProject(cfg);
            IPath program = LaunchUtils.verifyProgramPath(cfg, cproject);
            final String file = program.toOSString();
            final String workingDirectory = LaunchUtils.getWorkingDirectoryPath(cfg);
            final String[] args = LaunchUtils.getProgramArgumentsArray(cfg);
            final Map<String, String> env = LaunchUtils.getEnvironmentVariables(cfg);
            final boolean append = cfg.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
            final IProcesses.DoneGetEnvironment done_env = new IProcesses.DoneGetEnvironment(){

                public void doneGetEnvironment(IToken token, Exception error, Map<String, String> def) {
                    if (error != null) {
                        requestMonitor.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), error.getLocalizedMessage(), (Throwable)error));
                        requestMonitor.done();
                        return;
                    }
                    final HashMap<String, String> vars = new HashMap<String, String>();
                    if (append) {
                        vars.putAll(def);
                    }
                    if (env != null) {
                        vars.putAll(env);
                    }
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        public void run() {
                            ps.start(workingDirectory, file, args, vars, false, new IProcesses.DoneStart(){

                                public void doneStart(IToken token, Exception error, IProcesses.ProcessContext process) {
                                    if (error != null) {
                                        requestMonitor.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), error.getLocalizedMessage(), (Throwable)error));
                                        requestMonitor.done();
                                        return;
                                    }
                                    requestMonitor.done();
                                }
                            });
                        }
                    });
                }
            };
            if (append) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    public void run() {
                        ps.getEnvironment(done_env);
                    }
                });
            } else {
                done_env.doneGetEnvironment(null, null, null);
            }
        }
        catch (Exception x) {
            requestMonitor.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), x.getLocalizedMessage(), (Throwable)x));
            requestMonitor.done();
        }
    }

    public void attachProcess(EDCLaunch launch, IProcesses service, RequestMonitor requestMonitor) {
        try {
            int pid = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
            String preTargetedID = Integer.toString(pid);
            String[] processes = this.getProcessList(service);
            int numProcesses = processes.length;
            ChooseProcessItem[] items = null;
            IProcesses.ProcessContext[] contexts = null;
            items = new ChooseProcessItem[numProcesses];
            contexts = new IProcesses.ProcessContext[numProcesses];
            int i = 0;
            while (i < numProcesses) {
                ChooseProcessItem item;
                contexts[i] = this.getProcessContext(processes[i], service);
                String procID = contexts[i].getProperties().get("OSID").toString();
                if (procID == null) {
                    procID = "unknown";
                }
                items[i] = item = new ChooseProcessItem(procID, contexts[i].getName());
                ++i;
            }
            int selectedIndex = 0;
            if (pid == -1) {
                ChooseProcessItem selected = this.chooseProcess(items, "");
                selectedIndex = 0;
                while (selectedIndex < numProcesses) {
                    if (!selected.processID.equals(items[selectedIndex].processID)) {
                        ++selectedIndex;
                        continue;
                    }
                    break;
                }
            } else {
                int i2 = 0;
                while (i2 < contexts.length) {
                    String procID = (String)contexts[i2].getProperties().get("OSID");
                    if (procID.equals(preTargetedID)) {
                        selectedIndex = i2;
                        break;
                    }
                    ++i2;
                }
            }
            this.doAttachTask(contexts[selectedIndex]);
        }
        catch (CoreException e) {
            if (e.getStatus().matches(8)) {
                requestMonitor.cancel();
            }
            requestMonitor.setStatus(e.getStatus());
        }
        requestMonitor.done();
    }

    protected void doAttachTask(final IProcesses.ProcessContext context) throws CoreException {
        TCFTask<Object> task = new TCFTask<Object>(){

            public void run() {
                context.attach(new IProcesses.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error == null) {
                            this.done(this);
                        } else {
                            this.error(error);
                        }
                    }
                });
            }
        };
        try {
            task.getE();
        }
        catch (Error e) {
            String msg = "failed to attach to process: " + context.getID() + ", caused by: " + e.getCause().getMessage();
            if (!task.isCancelled()) {
                EDCDebugger.getMessageLogger().logError(msg, e);
                throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), msg, (Throwable)e));
            }
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    protected IProcesses.ProcessContext getProcessContext(final String processID, final IProcesses service) throws CoreException {
        TCFTask<IProcesses.ProcessContext> task = new TCFTask<IProcesses.ProcessContext>(){

            public void run() {
                service.getContext(processID, new IProcesses.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                        if (error == null) {
                            this.done(context);
                        } else {
                            this.error(error);
                        }
                    }
                });
            }
        };
        try {
            return (IProcesses.ProcessContext)task.getE();
        }
        catch (Error e) {
            String msg = "failed to create context for process: " + processID + ", caused by: " + e.getCause().getMessage();
            if (!task.isCancelled()) {
                EDCDebugger.getMessageLogger().logError(msg, e);
                throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), msg, (Throwable)e));
            }
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    protected IProcesses.ProcessContext getProcessContextByName(String contextName, IProcesses ps) throws CoreException {
        String[] contextIDs;
        String[] stringArray = contextIDs = this.getProcessList(ps);
        int n = contextIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String contextID = stringArray[n2];
            IProcesses.ProcessContext context = this.getProcessContext(contextID, ps);
            if (context.getName().equals(contextName)) {
                return context;
            }
            ++n2;
        }
        return null;
    }

    protected String[] getProcessList(final IProcesses service) throws CoreException {
        String[] ids;
        TCFTask<String[]> task = new TCFTask<String[]>(){

            public void run() {
                service.getChildren(null, false, new IProcesses.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] contextIds) {
                        if (error == null) {
                            this.done(contextIds);
                        } else {
                            this.error(error);
                        }
                    }
                });
            }
        };
        try {
            ids = (String[])task.getE();
        }
        catch (Error e) {
            String msg = "failed to get process list from target,  caused by: " + e.getCause().getMessage();
            if (!task.isCancelled()) {
                EDCDebugger.getMessageLogger().logError(msg, e);
                throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), msg, (Throwable)e));
            }
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (ids.length == 0) {
            String msg = "Failed to get running processes from target";
            throw new CoreException((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), msg, null));
        }
        return ids;
    }

    protected ChooseProcessItem chooseProcess(ChooseProcessItem[] processes, String defaultSelection) throws CoreException {
        return null;
    }

    protected abstract void specifyRequiredPeer();

    protected final IPeer getTCFPeer() {
        return this.tcfPeer;
    }

    protected abstract boolean useLocalAgentOnly();

    protected void handleConnectionClosed(IChannel channel, Throwable error) {
        if (this.launch != null && !this.launch.isTerminated()) {
            if (error != null) {
                EDCDebugger.getMessageLogger().logError("Connection lost; terminating debug session", error);
            }
            this.launch.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
        }
    }

    public EDCLaunch getLaunch() {
        return this.launch;
    }
}

