/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.tests;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocator;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.tests.AbstractDebugTest;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.core.runtime.CoreException;

public class ProjectWithSpaceTests
extends AbstractDebugTest {
    public static Test suite() {
        return new AbstractDebugTest.DebugTestWrapper(ProjectWithSpaceTests.class){};
    }

    protected String getProjectName() {
        return "with space";
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createDebugSession();
        ProjectWithSpaceTests.assertNotNull((Object)this.currentTarget);
        this.currentTarget.deleteAllBreakpoints();
        this.pause();
    }

    protected void tearDown() throws Exception {
        targets[0].terminate();
        int x = 0;
        while (!targets[0].isTerminated() && x < 30) {
            Thread.sleep(100L);
        }
        if (!targets[0].isTerminated()) {
            targets[0].terminate();
        }
        super.tearDown();
    }

    public void testLineBreak() throws CoreException, MIException, IOException, CDIException, InterruptedException {
        ICDITarget cdiTarget = this.currentTarget;
        ICDILineLocation location = cdiTarget.createLineLocation("main.c", 7);
        ProjectWithSpaceTests.assertNotNull((Object)location);
        cdiTarget.setLineBreakpoint(0, location, null, false);
        targets = session.getTargets();
        ProjectWithSpaceTests.assertTrue((targets.length == 1 ? 1 : 0) != 0);
        ICDITarget target = targets[0];
        target.resume(false);
        int x = 0;
        while (x < 100) {
            if (target.isSuspended() || target.isTerminated()) break;
            Thread.sleep(100L);
            ++x;
        }
        ProjectWithSpaceTests.assertTrue((String)("Suspended: " + target.isSuspended() + " Terminated: " + target.isTerminated()), (boolean)target.isSuspended());
        ICDILocator locator = this.getCurrentLocator();
        ProjectWithSpaceTests.assertTrue((locator.getLineNumber() == 7 ? 1 : 0) != 0);
        ProjectWithSpaceTests.assertTrue((boolean)locator.getFunction().equals("func1"));
        ProjectWithSpaceTests.assertTrue((boolean)locator.getFile().endsWith("main.c"));
    }
}

