/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.FunctionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetterSetterInsertEditProvider
implements Comparable<GetterSetterInsertEditProvider> {
    private IASTSimpleDeclaration functionDeclaration;
    private AccessorKind kind;
    private IASTName fieldName;
    private IASTSimpleDeclaration fieldDeclaration;

    public GetterSetterInsertEditProvider(IASTName fieldName, IASTSimpleDeclaration fieldDeclaration, AccessorKind kind) {
        switch (kind) {
            case GETTER: {
                this.functionDeclaration = FunctionFactory.createGetterDeclaration(fieldName, fieldDeclaration);
                break;
            }
            case SETTER: {
                this.functionDeclaration = FunctionFactory.createSetterDeclaration(fieldName, fieldDeclaration);
            }
        }
        this.kind = kind;
        this.fieldName = fieldName;
        this.fieldDeclaration = fieldDeclaration;
    }

    public String toString() {
        IASTDeclarator declarator = this.functionDeclaration.getDeclarators()[0];
        while (declarator.getNestedDeclarator() != null) {
            declarator = declarator.getNestedDeclarator();
        }
        return declarator.getName().toString();
    }

    public IASTFunctionDefinition getFunctionDefinition(boolean qualifedName) {
        IASTFunctionDefinition definition = null;
        ICPPASTQualifiedName qname = qualifedName ? this.getClassname() : null;
        switch (this.kind) {
            case GETTER: {
                definition = FunctionFactory.createGetterDefinition(this.fieldName, this.fieldDeclaration, qname);
                break;
            }
            case SETTER: {
                definition = FunctionFactory.createSetterDefinition(this.fieldName, this.fieldDeclaration, qname);
            }
        }
        return definition;
    }

    private ICPPASTQualifiedName getClassname() {
        IASTNode n = this.fieldDeclaration.getParent();
        while (!(n instanceof IASTCompositeTypeSpecifier)) {
            n = n.getParent();
        }
        IASTCompositeTypeSpecifier comp = (IASTCompositeTypeSpecifier)n;
        CPPASTQualifiedName qname = new CPPASTQualifiedName();
        qname.addName(comp.getName().copy(IASTNode.CopyStyle.withLocations));
        return qname;
    }

    public IASTSimpleDeclaration getFunctionDeclaration() {
        return this.functionDeclaration;
    }

    public AccessorKind getType() {
        return this.kind;
    }

    @Override
    public int compareTo(GetterSetterInsertEditProvider o) {
        return this.toString().compareTo(o.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessorKind {
        GETTER,
        SETTER;

    }
}

