/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.ILineNumbers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineNumbersProxy
implements ILineNumbers {
    private final IChannel channel;

    public LineNumbersProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public String getName() {
        return "LineNumbers";
    }

    @Override
    public IToken mapToSource(String context_id, Number start_address, Number end_address, final ILineNumbers.DoneMapToSource done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"mapToSource", (Object[])new Object[]{context_id, start_address, end_address}){

            public void done(Exception error, Object[] args) {
                ILineNumbers.CodeArea[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = LineNumbersProxy.this.toTextAreaArray(args[1]);
                }
                done.doneMapToSource(this.token, error, arr);
            }
        }.token;
    }

    @Override
    public IToken mapToMemory(String context_id, String file, int line, int column, final ILineNumbers.DoneMapToMemory done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"mapToMemory", (Object[])new Object[]{context_id, file, Integer.valueOf((int)line), Integer.valueOf((int)column)}){

            public void done(Exception error, Object[] args) {
                ILineNumbers.CodeArea[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = LineNumbersProxy.this.toTextAreaArray(args[1]);
                }
                done.doneMapToMemory(this.token, error, arr);
            }
        }.token;
    }

    private static int getInteger(Map<String, Object> map, String name, int def) {
        Number n = (Number)map.get(name);
        if (n == null) {
            return def;
        }
        return n.intValue();
    }

    private static String getString(Map<String, Object> map, String name, String def) {
        String s = (String)map.get(name);
        if (s == null) {
            return def;
        }
        return s;
    }

    private static boolean getBoolean(Map<String, Object> map, String name) {
        Boolean b = (Boolean)map.get(name);
        if (b == null) {
            return false;
        }
        return b;
    }

    private ILineNumbers.CodeArea[] toTextAreaArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        int n = 0;
        ILineNumbers.CodeArea[] arr = new ILineNumbers.CodeArea[c.size()];
        String directory = null;
        String file = null;
        for (Map area : c) {
            directory = LineNumbersProxy.getString(area, "Dir", directory);
            file = LineNumbersProxy.getString(area, "File", file);
            arr[n++] = new ILineNumbers.CodeArea(directory, file, LineNumbersProxy.getInteger(area, "SLine", 0), LineNumbersProxy.getInteger(area, "SCol", 0), LineNumbersProxy.getInteger(area, "ELine", 0), LineNumbersProxy.getInteger(area, "ECol", 0), (Number)area.get("SAddr"), (Number)area.get("EAddr"), LineNumbersProxy.getInteger(area, "ISA", 0), LineNumbersProxy.getBoolean(area, "IsStmt"), LineNumbersProxy.getBoolean(area, "BasicBlock"), LineNumbersProxy.getBoolean(area, "PrologueEnd"), LineNumbersProxy.getBoolean(area, "EpilogueBegin"));
        }
        return arr;
    }
}

