/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.model;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.tm.internal.tcf.debug.Activator;
import org.eclipse.tm.internal.tcf.debug.actions.TCFAction;
import org.eclipse.tm.internal.tcf.debug.launch.TCFLaunchDelegate;
import org.eclipse.tm.internal.tcf.debug.model.TCFBreakpointsStatus;
import org.eclipse.tm.internal.tcf.debug.model.TCFError;
import org.eclipse.tm.internal.tcf.debug.model.TCFMemoryRegion;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IFileSystem;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IMemoryMap;
import org.eclipse.tm.tcf.services.IPathMap;
import org.eclipse.tm.tcf.services.IProcesses;
import org.eclipse.tm.tcf.services.IProcessesV1;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.IStreams;
import org.eclipse.tm.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFLaunch
extends Launch {
    public static final String PROP_MMAP_ID = "ID";
    private static final Collection<LaunchListener> listeners = new ArrayList<LaunchListener>();
    private final Collection<ActionsListener> action_listeners = new ArrayList<ActionsListener>();
    private IChannel channel;
    private Throwable error;
    private TCFBreakpointsStatus breakpoints_status;
    private String mode;
    private boolean connecting;
    private boolean disconnecting;
    private boolean disconnected;
    private boolean terminated;
    private boolean shutdown;
    private boolean last_context_exited;
    private long actions_timestamp;
    private long actions_interval = 125L;
    private String peer_name;
    private Runnable update_memory_maps;
    private IProcesses.ProcessContext process;
    private Collection<Map<String, Object>> process_signals;
    private IToken process_start_command;
    private String process_input_stream_id;
    private int process_exit_code;
    private final HashMap<String, String> process_env = new HashMap();
    private final HashMap<String, TCFAction> active_actions = new HashMap();
    private final HashMap<String, LinkedList<TCFAction>> context_action_queue = new HashMap();
    private final HashMap<String, String> stream_ids = new HashMap();
    private final LinkedList<LaunchStep> launch_steps = new LinkedList();
    private final LinkedList<String> redirection_path = new LinkedList();
    private ArrayList<TCFLaunchDelegate.PathMapRule> filepath_map;
    private Set<String> context_filter;
    private final IStreams.StreamsListener streams_listener = new IStreams.StreamsListener(){

        public void created(String stream_type, String stream_id, String context_id) {
            if (!$assertionsDisabled && !"Processes".equals(stream_type)) {
                throw new AssertionError();
            }
            if (TCFLaunch.this.process_start_command == null) {
                TCFLaunch.this.disconnectStream(stream_id);
            } else {
                TCFLaunch.this.stream_ids.put(stream_id, context_id);
            }
        }

        public void disposed(String stream_type, String stream_id) {
        }
    };
    private final IProcesses.ProcessesListener prs_listener = new IProcesses.ProcessesListener(){

        public void exited(String process_id, int exit_code) {
            if (process_id.equals(TCFLaunch.this.process.getID())) {
                TCFLaunch.this.process_exit_code = exit_code;
            }
        }
    };

    public TCFLaunch(ILaunchConfiguration launchConfiguration, String mode) {
        super(launchConfiguration, mode, null);
        for (LaunchListener l : listeners) {
            l.onCreated(this);
        }
    }

    private void onConnected() throws Exception {
        IPathMap path_map_service;
        final ILaunchConfiguration cfg = this.getLaunchConfiguration();
        if (cfg != null && (path_map_service = this.getService(IPathMap.class)) != null) {
            new LaunchStep(){

                void start() throws Exception {
                    String s = cfg.getAttribute("org.eclipse.tm.tcf.debug.PathMap", "");
                    TCFLaunch.this.filepath_map = TCFLaunchDelegate.parsePathMapAttribute(s);
                    path_map_service.set(TCFLaunch.this.filepath_map.toArray(new IPathMap.PathMapRule[TCFLaunch.this.filepath_map.size()]), new IPathMap.DoneSet(){

                        public void doneSet(IToken token, Exception error) {
                            if (error != null) {
                                TCFLaunch.this.channel.terminate((Throwable)error);
                            } else {
                                this.done();
                            }
                        }
                    });
                }
            };
        }
        if (this.redirection_path.size() > 0) {
            new LaunchStep(){

                void start() throws Exception {
                    TCFLaunch.this.channel.redirect((String)TCFLaunch.this.redirection_path.removeFirst());
                }
            };
        } else {
            final IStreams streams = this.getService(IStreams.class);
            if (streams != null) {
                new LaunchStep(){

                    void start() {
                        streams.subscribe("Processes", TCFLaunch.this.streams_listener, new IStreams.DoneSubscribe(){

                            public void doneSubscribe(IToken token, Exception error) {
                                if (error != null) {
                                    TCFLaunch.this.channel.terminate((Throwable)error);
                                } else {
                                    this.done();
                                }
                            }
                        });
                    }
                };
            }
            if (this.mode.equals("debug")) {
                String attach_to_context = this.getAttribute("attach_to_context");
                if (attach_to_context != null) {
                    this.context_filter = new HashSet<String>();
                    this.context_filter.add(attach_to_context);
                }
                if (cfg != null && this.channel.getRemoteService(IMemoryMap.class) != null) {
                    final String maps = cfg.getAttribute("org.eclipse.tm.tcf.debug.MemoryMap", "null");
                    new LaunchStep(){

                        void start() throws Exception {
                            TCFLaunch.this.downloadMemoryMaps(maps, this);
                        }
                    };
                }
                new LaunchStep(){

                    void start() throws Exception {
                        TCFLaunch.this.breakpoints_status = new TCFBreakpointsStatus(TCFLaunch.this);
                        Activator.getBreakpointsModel().downloadBreakpoints(TCFLaunch.this.channel, this);
                    }
                };
            }
            new LaunchStep(){

                void start() {
                    TCFLaunch.this.runLaunchSequence(this);
                }
            };
            if (cfg != null) {
                this.startRemoteProcess(cfg);
            }
            new LaunchStep(){

                void start() {
                    TCFLaunch.this.connecting = false;
                    for (LaunchListener l : listeners) {
                        l.onConnected(TCFLaunch.this);
                    }
                    TCFLaunch.this.fireChanged();
                }
            };
        }
        this.launch_steps.removeFirst().start();
    }

    private void onDisconnected(Throwable error) {
        assert (!this.disconnected);
        assert (!this.shutdown);
        this.error = error;
        this.breakpoints_status = null;
        this.connecting = false;
        this.disconnected = true;
        for (LaunchListener l : listeners) {
            l.onDisconnected(this);
        }
        if (DebugPlugin.getDefault() != null) {
            this.fireChanged();
        }
        this.runShutdownSequence(new Runnable(){

            public void run() {
                TCFLaunch.this.shutdown = true;
                if (DebugPlugin.getDefault() != null) {
                    TCFLaunch.this.fireTerminate();
                }
            }
        });
    }

    protected void runLaunchSequence(Runnable done) {
        done.run();
    }

    private void readMapsConfiguration(HashMap<String, ArrayList<TCFMemoryRegion>> maps, String cfg) throws Exception {
        Collection list = (Collection)JSON.parseOne((byte[])cfg.getBytes("UTF-8"));
        if (list == null) {
            return;
        }
        for (Map map : list) {
            String id = (String)map.get(PROP_MMAP_ID);
            if (id == null) continue;
            ArrayList<TCFMemoryRegion> l = maps.get(id);
            if (l == null) {
                l = new ArrayList();
                maps.put(id, l);
            }
            l.add(new TCFMemoryRegion(map));
        }
    }

    private void downloadMemoryMaps(String cfg, final Runnable done) throws Exception {
        final IMemory mem = (IMemory)this.channel.getRemoteService(IMemory.class);
        final IMemoryMap mmap = (IMemoryMap)this.channel.getRemoteService(IMemoryMap.class);
        if (mem == null || mmap == null) {
            done.run();
            return;
        }
        final HashSet deleted_maps = new HashSet();
        final HashMap<String, ArrayList<TCFMemoryRegion>> maps = new HashMap<String, ArrayList<TCFMemoryRegion>>();
        this.readMapsConfiguration(maps, cfg);
        final HashSet mems = new HashSet();
        final HashSet<IToken> cmds = new HashSet<IToken>();
        final HashMap mem2map = new HashMap();
        final Runnable done_all = new Runnable(){
            boolean launch_done;

            public void run() {
                mems.clear();
                deleted_maps.clear();
                if (this.launch_done) {
                    return;
                }
                done.run();
                this.launch_done = true;
            }
        };
        final IMemoryMap.DoneSet done_set_mmap = new IMemoryMap.DoneSet(){

            public void doneSet(IToken token, Exception error) {
                cmds.remove(token);
                if (cmds.isEmpty()) {
                    done_all.run();
                }
            }
        };
        final IMemory.DoneGetContext done_get_context = new IMemory.DoneGetContext(){

            public void doneGetContext(IToken token, Exception error, IMemory.MemoryContext context) {
                cmds.remove(token);
                if (context != null && mems.add(context.getID())) {
                    String id = context.getName();
                    if (id == null) {
                        id = context.getID();
                    }
                    if (id != null) {
                        ArrayList map = (ArrayList)maps.get(id);
                        if (map != null) {
                            IMemoryMap.MemoryRegion[] arr = map.toArray(new TCFMemoryRegion[map.size()]);
                            cmds.add(mmap.set(context.getID(), arr, done_set_mmap));
                            mem2map.put(context.getID(), id);
                        } else if (deleted_maps.contains(id)) {
                            cmds.add(mmap.set(context.getID(), null, done_set_mmap));
                            mem2map.remove(context.getID());
                        }
                    }
                }
                if (cmds.isEmpty()) {
                    done_all.run();
                }
            }
        };
        final IMemory.DoneGetChildren done_get_children = new IMemory.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] ids) {
                cmds.remove(token);
                if (ids != null) {
                    String[] stringArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        cmds.add(mem.getChildren(id, (IMemory.DoneGetChildren)this));
                        cmds.add(mem.getContext(id, done_get_context));
                        ++n2;
                    }
                }
                if (cmds.isEmpty()) {
                    done_all.run();
                }
            }
        };
        cmds.add(mem.getChildren(null, done_get_children));
        mem.addListener(new IMemory.MemoryListener(){

            public void memoryChanged(String context_id, Number[] addr, long[] size) {
            }

            public void contextRemoved(String[] context_ids) {
                String[] stringArray = context_ids;
                int n = context_ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    mems.remove(id);
                    mem2map.remove(id);
                    ++n2;
                }
            }

            public void contextChanged(IMemory.MemoryContext[] contexts) {
                IMemory.MemoryContext[] memoryContextArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    ArrayList map;
                    IMemory.MemoryContext context = memoryContextArray[n2];
                    String id = context.getName();
                    if (id == null) {
                        id = context.getID();
                    }
                    if (id != null && !id.equals(mem2map.get(context.getID())) && (map = (ArrayList)maps.get(id)) != null) {
                        IMemoryMap.MemoryRegion[] arr = map.toArray(new TCFMemoryRegion[map.size()]);
                        cmds.add(mmap.set(context.getID(), arr, done_set_mmap));
                        mem2map.put(context.getID(), id);
                    }
                    ++n2;
                }
            }

            public void contextAdded(IMemory.MemoryContext[] contexts) {
                IMemory.MemoryContext[] memoryContextArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemory.MemoryContext context = memoryContextArray[n2];
                    if (mems.add(context.getID())) {
                        ArrayList map;
                        String id = context.getName();
                        if (id == null) {
                            id = context.getID();
                        }
                        if (id != null && (map = (ArrayList)maps.get(id)) != null) {
                            IMemoryMap.MemoryRegion[] arr = map.toArray(new TCFMemoryRegion[map.size()]);
                            cmds.add(mmap.set(context.getID(), arr, done_set_mmap));
                            mem2map.put(context.getID(), id);
                        }
                    }
                    ++n2;
                }
            }
        });
        this.update_memory_maps = new Runnable(){

            public void run() {
                try {
                    maps.clear();
                    mems.clear();
                    String s = TCFLaunch.this.getLaunchConfiguration().getAttribute("org.eclipse.tm.tcf.debug.MemoryMap", "null");
                    TCFLaunch.this.readMapsConfiguration(maps, s);
                    for (String id : mem2map.values()) {
                        if (maps.get(id) != null) continue;
                        deleted_maps.add(id);
                    }
                    cmds.add(mem.getChildren(null, done_get_children));
                }
                catch (Throwable x) {
                    TCFLaunch.this.channel.terminate(x);
                }
            }
        };
    }

    private String[] toArgsArray(String file, String cmd) {
        int i = 0;
        int l = cmd.length();
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(file);
        while (true) {
            if (i < l && cmd.charAt(i) == ' ') {
                ++i;
                continue;
            }
            if (i >= l) break;
            String s = null;
            if (cmd.charAt(i) == '\"') {
                ++i;
                StringBuffer bf = new StringBuffer();
                while (i < l) {
                    char ch;
                    if ((ch = cmd.charAt(i++)) == '\"') break;
                    if (ch == '\\' && i < l) {
                        ch = cmd.charAt(i++);
                    }
                    bf.append(ch);
                }
                s = bf.toString();
            } else {
                int i0 = i;
                while (i < l && cmd.charAt(i) != ' ') {
                    ++i;
                }
                s = cmd.substring(i0, i);
            }
            arr.add(s);
        }
        return arr.toArray(new String[arr.size()]);
    }

    private void copyFileToRemoteTarget(String local_file, String remote_file, final Runnable done) {
        if (local_file == null) {
            this.channel.terminate((Throwable)new Exception("Program does not exist"));
            return;
        }
        final IFileSystem fs = (IFileSystem)this.channel.getRemoteService(IFileSystem.class);
        if (fs == null) {
            this.channel.terminate((Throwable)new Exception("Cannot download program file: target does not provide File System service"));
            return;
        }
        try {
            final FileInputStream inp = new FileInputStream(local_file);
            int flags = 26;
            fs.open(remote_file, flags, null, new IFileSystem.DoneOpen(){
                IFileSystem.IFileHandle handle;
                long offset = 0L;
                final Set<IToken> cmds = new HashSet<IToken>();
                final byte[] buf = new byte[4096];

                public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                    this.handle = handle;
                    if (error != null) {
                        TCFLaunch.this.error = new Exception("Cannot download program file", (Throwable)error);
                        TCFLaunch.this.fireChanged();
                        done.run();
                    } else {
                        this.write_next();
                    }
                }

                private void write_next() {
                    try {
                        while (this.cmds.size() < 8) {
                            int rd = inp.read(this.buf);
                            if (rd < 0) {
                                this.close();
                                break;
                            }
                            this.cmds.add(fs.write(this.handle, this.offset, this.buf, 0, rd, new IFileSystem.DoneWrite(){

                                public void doneWrite(IToken token, IFileSystem.FileSystemException error) {
                                    cmds.remove(token);
                                    if (error != null) {
                                        TCFLaunch.this.channel.terminate((Throwable)error);
                                    } else {
                                        this.write_next();
                                    }
                                }
                            }));
                            this.offset += (long)rd;
                        }
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                    }
                }

                private void close() {
                    if (this.cmds.size() > 0) {
                        return;
                    }
                    try {
                        inp.close();
                        fs.close(this.handle, new IFileSystem.DoneClose(){

                            public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                                if (error != null) {
                                    TCFLaunch.this.channel.terminate((Throwable)error);
                                } else {
                                    done.run();
                                }
                            }
                        });
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                    }
                }
            });
        }
        catch (Throwable x) {
            this.channel.terminate(x);
        }
    }

    private void startRemoteProcess(ILaunchConfiguration cfg) throws Exception {
        String attach_to_process;
        final String project = cfg.getAttribute("org.eclipse.tm.tcf.debug.ProjectName", "");
        final String local_file = cfg.getAttribute("org.eclipse.tm.tcf.debug.LocalProgramFile", "");
        final String remote_file = cfg.getAttribute("org.eclipse.tm.tcf.debug.ProgramFile", "");
        if (local_file.length() != 0 && remote_file.length() != 0) {
            new LaunchStep(){

                void start() throws Exception {
                    TCFLaunch.this.copyFileToRemoteTarget(TCFLaunchDelegate.getProgramPath(project, local_file), remote_file, this);
                }
            };
        }
        if ((attach_to_process = this.getAttribute("attach_to_process")) != null) {
            final IProcesses ps = (IProcesses)this.channel.getRemoteService(IProcesses.class);
            if (ps == null) {
                throw new Exception("Target does not provide Processes service");
            }
            new LaunchStep(){

                void start() {
                    IProcesses.DoneGetContext done = new IProcesses.DoneGetContext(){

                        public void doneGetContext(IToken token, Exception error, final IProcesses.ProcessContext process) {
                            if (error != null) {
                                TCFLaunch.this.channel.terminate((Throwable)error);
                            } else {
                                process.attach(new IProcesses.DoneCommand(){

                                    public void doneCommand(IToken token, Exception error) {
                                        if (error != null) {
                                            TCFLaunch.this.channel.terminate((Throwable)error);
                                        } else {
                                            TCFLaunch.this.context_filter = new HashSet();
                                            TCFLaunch.this.context_filter.add(process.getID());
                                            TCFLaunch.this.process = process;
                                            ps.addListener(TCFLaunch.this.prs_listener);
                                            TCFLaunch.this.connectProcessStreams();
                                            this.done();
                                        }
                                    }
                                });
                            }
                        }
                    };
                    ps.getContext(attach_to_process, done);
                }
            };
        } else if (local_file.length() != 0 || remote_file.length() != 0) {
            final IProcesses ps = (IProcesses)this.channel.getRemoteService(IProcesses.class);
            if (ps == null) {
                throw new Exception("Target does not provide Processes service");
            }
            boolean append = cfg.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
            if (append) {
                new LaunchStep(){

                    void start() throws Exception {
                        ps.getEnvironment(new IProcesses.DoneGetEnvironment(){

                            public void doneGetEnvironment(IToken token, Exception error, Map<String, String> env) {
                                if (error != null) {
                                    TCFLaunch.this.channel.terminate((Throwable)error);
                                } else {
                                    if (env != null) {
                                        TCFLaunch.this.process_env.putAll(env);
                                    }
                                    this.done();
                                }
                            }
                        });
                    }
                };
            }
            final String dir = cfg.getAttribute("org.eclipse.tm.tcf.debug.WorkingDirectory", "");
            final String args = cfg.getAttribute("org.eclipse.tm.tcf.debug.ProgramArguments", "");
            final Map env = cfg.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            final boolean attach_children = cfg.getAttribute("org.eclipse.tm.tcf.debug.AttachChildren", true);
            final boolean use_terminal = cfg.getAttribute("org.eclipse.tm.tcf.debug.UseTerminal", true);
            new LaunchStep(){

                void start() {
                    String file;
                    if (env != null) {
                        TCFLaunch.this.process_env.putAll(env);
                    }
                    if ((file = remote_file) == null || file.length() == 0) {
                        file = TCFLaunchDelegate.getProgramPath(project, local_file);
                    }
                    if (file == null || file.length() == 0) {
                        TCFLaunch.this.channel.terminate((Throwable)new Exception("Program file does not exist"));
                        return;
                    }
                    IProcesses.DoneStart done = new IProcesses.DoneStart(){

                        public void doneStart(IToken token, final Exception error, IProcesses.ProcessContext process) {
                            TCFLaunch.this.process_start_command = null;
                            if (error != null) {
                                for (String id : new HashSet(TCFLaunch.this.stream_ids.keySet())) {
                                    TCFLaunch.this.disconnectStream(id);
                                }
                                Protocol.sync((Runnable)new Runnable(){

                                    public void run() {
                                        TCFLaunch.this.channel.terminate((Throwable)error);
                                    }
                                });
                            } else {
                                TCFLaunch.this.context_filter = new HashSet();
                                TCFLaunch.this.context_filter.add(process.getID());
                                TCFLaunch.this.process = process;
                                ps.addListener(TCFLaunch.this.prs_listener);
                                TCFLaunch.this.connectProcessStreams();
                                this.done();
                            }
                        }
                    };
                    String[] args_arr = TCFLaunch.this.toArgsArray(file, args);
                    IProcessesV1 ps_v2 = (IProcessesV1)TCFLaunch.this.channel.getRemoteService(IProcessesV1.class);
                    if (ps_v2 != null) {
                        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                        if (TCFLaunch.this.mode.equals("debug")) {
                            params.put("Attach", true);
                            if (attach_children) {
                                params.put("AttachChildren", true);
                            }
                        }
                        if (use_terminal) {
                            params.put("UseTerminal", true);
                        }
                        TCFLaunch.this.process_start_command = ps_v2.start(dir, file, args_arr, (Map)TCFLaunch.this.process_env, params, done);
                    } else {
                        boolean attach = TCFLaunch.this.mode.equals("debug");
                        TCFLaunch.this.process_start_command = ps.start(dir, file, args_arr, (Map)TCFLaunch.this.process_env, attach, done);
                    }
                }
            };
            if (this.mode.equals("debug")) {
                int no_pass;
                new LaunchStep(){

                    void start() {
                        ps.getSignalList(TCFLaunch.this.process.getID(), new IProcesses.DoneGetSignalList(){

                            public void doneGetSignalList(IToken token, Exception error, Collection<Map<String, Object>> list) {
                                if (error != null) {
                                    Activator.log("Can't get process signal list", error);
                                }
                                TCFLaunch.this.process_signals = list;
                                this.done();
                            }
                        });
                    }
                };
                String dont_stop = cfg.getAttribute("org.eclipse.tm.tcf.debug.SignalsDontStop", "");
                String dont_pass = cfg.getAttribute("org.eclipse.tm.tcf.debug.SignalsDontPath", "");
                final int no_stop = dont_stop.length() > 0 ? Integer.parseInt(dont_stop, 16) : 0;
                int n = no_pass = dont_pass.length() > 0 ? Integer.parseInt(dont_pass, 16) : 0;
                if (no_stop != 0 || no_pass != 0) {
                    new LaunchStep(){

                        void start() {
                            final HashSet<IToken> cmds = new HashSet<IToken>();
                            final IProcesses.DoneCommand done_set_mask = new IProcesses.DoneCommand(){

                                public void doneCommand(IToken token, Exception error) {
                                    cmds.remove(token);
                                    if (error != null) {
                                        TCFLaunch.this.channel.terminate((Throwable)error);
                                    } else if (cmds.size() == 0) {
                                        this.done();
                                    }
                                }
                            };
                            cmds.add(ps.setSignalMask(TCFLaunch.this.process.getID(), no_stop, no_pass, done_set_mask));
                            final IRunControl rc = (IRunControl)TCFLaunch.this.channel.getRemoteService(IRunControl.class);
                            if (rc != null) {
                                IRunControl.DoneGetChildren done_get_children = new IRunControl.DoneGetChildren(){

                                    public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                                        if (context_ids != null) {
                                            String[] stringArray = context_ids;
                                            int n = context_ids.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                String id = stringArray[n2];
                                                cmds.add(ps.setSignalMask(id, no_stop, no_pass, done_set_mask));
                                                cmds.add(rc.getChildren(id, (IRunControl.DoneGetChildren)this));
                                                ++n2;
                                            }
                                        }
                                        cmds.remove(token);
                                        if (error != null) {
                                            TCFLaunch.this.channel.terminate((Throwable)error);
                                        } else if (cmds.size() == 0) {
                                            this.done();
                                        }
                                    }
                                };
                                cmds.add(rc.getChildren(TCFLaunch.this.process.getID(), done_get_children));
                            }
                        }
                    };
                }
            }
        }
    }

    private void connectProcessStreams() {
        assert (this.process_start_command == null);
        IStreams streams = this.getService(IStreams.class);
        if (streams == null) {
            return;
        }
        String inp_id = (String)this.process.getProperties().get("StdInID");
        String out_id = (String)this.process.getProperties().get("StdOutID");
        String err_id = (String)this.process.getProperties().get("StdErrID");
        String[] stringArray = this.stream_ids.keySet().toArray(new String[this.stream_ids.size()]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(inp_id)) {
                this.process_input_stream_id = id;
            } else if (id.equals(out_id)) {
                this.connectStream(id, 0);
            } else if (id.equals(err_id)) {
                this.connectStream(id, 1);
            } else {
                this.disconnectStream(id);
            }
            ++n2;
        }
    }

    private void connectStream(final String id, final int no) {
        final String peocess_id = this.process.getID();
        final IStreams streams = this.getService(IStreams.class);
        IStreams.DoneRead done = new IStreams.DoneRead(){

            public void doneRead(IToken token, Exception error, int lost_size, byte[] data, boolean eos) {
                if (TCFLaunch.this.stream_ids.get(id) == null) {
                    return;
                }
                if (lost_size > 0) {
                    IOException x = new IOException("Process output data lost due buffer overflow");
                    for (LaunchListener l : listeners) {
                        l.onProcessStreamError(TCFLaunch.this, peocess_id, no, x, lost_size);
                    }
                }
                if (data != null && data.length > 0) {
                    for (LaunchListener l : listeners) {
                        l.onProcessOutput(TCFLaunch.this, peocess_id, no, data);
                    }
                }
                if (error != null) {
                    for (LaunchListener l : listeners) {
                        l.onProcessStreamError(TCFLaunch.this, peocess_id, no, error, 0);
                    }
                }
                if (eos || error != null) {
                    TCFLaunch.this.disconnectStream(id);
                } else {
                    streams.read(id, 4096, (IStreams.DoneRead)this);
                }
            }
        };
        streams.read(id, 4096, done);
        streams.read(id, 4096, done);
        streams.read(id, 4096, done);
        streams.read(id, 4096, done);
    }

    private void disconnectStream(String id) {
        this.stream_ids.remove(id);
        if (this.channel.getState() != 1) {
            return;
        }
        IStreams streams = this.getService(IStreams.class);
        streams.disconnect(id, new IStreams.DoneDisconnect(){

            public void doneDisconnect(IToken token, Exception error) {
                if (TCFLaunch.this.channel.getState() != 1) {
                    return;
                }
                if (error != null) {
                    TCFLaunch.this.channel.terminate((Throwable)error);
                }
            }
        });
    }

    protected void runShutdownSequence(Runnable done) {
        done.run();
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable x) {
        this.error = x;
        if (x != null) {
            if (this.channel != null && this.channel.getState() == 1) {
                this.channel.terminate(x);
            } else if (!this.connecting) {
                this.disconnected = true;
            }
        }
        this.fireChanged();
    }

    public TCFBreakpointsStatus getBreakpointsStatus() {
        return this.breakpoints_status;
    }

    public static void addListener(LaunchListener listener) {
        assert (Protocol.isDispatchThread());
        listeners.add(listener);
    }

    public static void removeListener(LaunchListener listener) {
        assert (Protocol.isDispatchThread());
        listeners.remove(listener);
    }

    public void launchConfigurationChanged(final ILaunchConfiguration cfg) {
        super.launchConfigurationChanged(cfg);
        if (!cfg.equals(this.getLaunchConfiguration())) {
            return;
        }
        new TCFTask<Boolean>(){

            public void run() {
                try {
                    if (TCFLaunch.this.update_memory_maps != null) {
                        TCFLaunch.this.update_memory_maps.run();
                    }
                    if (TCFLaunch.this.filepath_map != null) {
                        String s = cfg.getAttribute("org.eclipse.tm.tcf.debug.PathMap", "");
                        TCFLaunch.this.filepath_map = TCFLaunchDelegate.parsePathMapAttribute(s);
                        IPathMap path_map_service = TCFLaunch.this.getService(IPathMap.class);
                        path_map_service.set(TCFLaunch.this.filepath_map.toArray(new IPathMap.PathMapRule[TCFLaunch.this.filepath_map.size()]), new IPathMap.DoneSet(){

                            public void doneSet(IToken token, Exception error) {
                                if (error != null) {
                                    TCFLaunch.this.channel.terminate((Throwable)error);
                                }
                                this.done(false);
                            }
                        });
                    } else {
                        this.done(true);
                    }
                }
                catch (Throwable x) {
                    TCFLaunch.this.channel.terminate(x);
                    this.done(false);
                }
            }
        }.getE();
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public IProcesses.ProcessContext getProcessContext() {
        return this.process;
    }

    public void writeProcessInputStream(byte[] buf, int pos, final int len) throws Exception {
        assert (Protocol.isDispatchThread());
        final String id = this.process_input_stream_id;
        if (this.channel.getState() != 1) {
            throw new IOException("Connection closed");
        }
        if (this.process == null) {
            throw new IOException("No target process");
        }
        final String prs = this.process.getID();
        IStreams streams = this.getService(IStreams.class);
        if (streams == null) {
            throw new IOException("Streams service not available");
        }
        if (this.stream_ids.get(id) == null) {
            throw new IOException("Input stream not available");
        }
        streams.write(id, buf, pos, len, new IStreams.DoneWrite(){

            public void doneWrite(IToken token, Exception error) {
                if (error == null) {
                    return;
                }
                if (TCFLaunch.this.stream_ids.get(id) == null) {
                    return;
                }
                for (LaunchListener l : listeners) {
                    l.onProcessStreamError(TCFLaunch.this, prs, 0, error, len);
                }
                TCFLaunch.this.disconnectStream(id);
            }
        });
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public void onLastContextRemoved() {
        this.last_context_exited = true;
        this.closeChannel();
    }

    public void closeChannel() {
        assert (Protocol.isDispatchThread());
        if (this.channel == null) {
            return;
        }
        if (this.channel.getState() == 2) {
            return;
        }
        if (this.disconnecting) {
            return;
        }
        this.disconnecting = true;
        IStreams streams = this.getService(IStreams.class);
        final HashSet<IToken> cmds = new HashSet<IToken>();
        for (String id : this.stream_ids.keySet()) {
            cmds.add(streams.disconnect(id, new IStreams.DoneDisconnect(){

                public void doneDisconnect(IToken token, Exception error) {
                    cmds.remove(token);
                    if (TCFLaunch.this.channel.getState() == 2) {
                        return;
                    }
                    if (error != null) {
                        TCFLaunch.this.channel.terminate((Throwable)error);
                    } else if (cmds.isEmpty()) {
                        TCFLaunch.this.channel.close();
                    }
                }
            }));
        }
        this.stream_ids.clear();
        this.process_input_stream_id = null;
        if (cmds.isEmpty()) {
            this.channel.close();
        }
    }

    public IPeer getPeer() {
        assert (Protocol.isDispatchThread());
        return this.channel.getRemotePeer();
    }

    public String getPeerName() {
        return this.peer_name;
    }

    public <V extends IService> V getService(Class<V> cls) {
        assert (Protocol.isDispatchThread());
        return (V)this.channel.getRemoteService(cls);
    }

    public boolean canDisconnect() {
        return !this.disconnected;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void disconnect() throws DebugException {
        try {
            new TCFTask<Boolean>(){

                public void run() {
                    TCFLaunch.this.closeChannel();
                    this.done(true);
                }
            }.get();
        }
        catch (IllegalStateException illegalStateException) {
            this.disconnected = true;
        }
        catch (Exception x) {
            throw new TCFError(x);
        }
    }

    public boolean canTerminate() {
        return !this.disconnected;
    }

    public boolean isTerminated() {
        return this.disconnected;
    }

    public void terminate() throws DebugException {
        try {
            new TCFTask<Boolean>(){

                public void run() {
                    if (TCFLaunch.this.channel != null && TCFLaunch.this.channel.getState() == 1) {
                        if (TCFLaunch.this.process != null && !TCFLaunch.this.terminated) {
                            30 done = this;
                            TCFLaunch.this.process.terminate(new IProcesses.DoneCommand((Runnable)((Object)done)){
                                private final /* synthetic */ Runnable val$done;
                                {
                                    this.val$done = runnable;
                                }

                                public void doneCommand(IToken token, Exception e) {
                                    if (e != null) {
                                        this.error(e);
                                    } else {
                                        TCFLaunch.this.terminated = true;
                                        Protocol.invokeLater((Runnable)this.val$done);
                                    }
                                }
                            });
                            return;
                        }
                        TCFLaunch.this.closeChannel();
                    }
                    this.done(true);
                }
            }.get();
        }
        catch (Exception x) {
            throw new TCFError(x);
        }
    }

    public boolean isExited() {
        return this.last_context_exited;
    }

    public int getExitCode() {
        return this.process_exit_code;
    }

    public Collection<Map<String, Object>> getSignalList() {
        return this.process_signals;
    }

    public ArrayList<TCFLaunchDelegate.PathMapRule> getFilePathMap() {
        assert (Protocol.isDispatchThread());
        return this.filepath_map;
    }

    public void launchTCF(String mode, String id) {
        assert (Protocol.isDispatchThread());
        this.mode = mode;
        try {
            if (id == null || id.length() == 0) {
                throw new IOException("Invalid peer ID");
            }
            this.redirection_path.clear();
            while (true) {
                int i;
                if ((i = id.indexOf(47)) <= 0) break;
                this.redirection_path.add(id.substring(0, i));
                id = id.substring(i + 1);
            }
            this.redirection_path.add(id);
            String id0 = this.redirection_path.removeFirst();
            IPeer peer = (IPeer)Protocol.getLocator().getPeers().get(id0);
            if (peer == null) {
                throw new Exception("Cannot locate peer " + id0);
            }
            this.peer_name = peer.getName();
            this.channel = peer.openChannel();
            this.channel.addChannelListener(new IChannel.IChannelListener(){

                public void onChannelOpened() {
                    try {
                        TCFLaunch.this.peer_name = TCFLaunch.this.getPeer().getName();
                        TCFLaunch.this.onConnected();
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                    }
                }

                public void congestionLevel(int level) {
                }

                public void onChannelClosed(Throwable error) {
                    TCFLaunch.this.channel.removeChannelListener((IChannel.IChannelListener)this);
                    TCFLaunch.this.onDisconnected(error);
                }
            });
            assert (this.channel.getState() == 0);
            this.connecting = true;
        }
        catch (Throwable e) {
            this.onDisconnected(e);
        }
    }

    private void startAction(String id) {
        if (this.active_actions.get(id) != null) {
            return;
        }
        LinkedList<TCFAction> list = this.context_action_queue.get(id);
        if (list == null || list.size() == 0) {
            return;
        }
        final TCFAction action = list.removeFirst();
        if (list.size() == 0) {
            this.context_action_queue.remove(id);
        }
        this.active_actions.put(id, action);
        long time = System.currentTimeMillis();
        Protocol.invokeLater((long)(this.actions_timestamp + this.actions_interval - time), (Runnable)new Runnable(){

            public void run() {
                TCFLaunch.this.actions_timestamp = System.currentTimeMillis();
                for (ActionsListener l : TCFLaunch.this.action_listeners) {
                    l.onContextActionStart(action);
                }
                action.run();
            }
        });
    }

    public void setContextActionsInterval(long interval) {
        this.actions_interval = interval;
    }

    public void addContextAction(TCFAction action) {
        assert (Protocol.isDispatchThread());
        String id = action.getContextID();
        LinkedList<TCFAction> list = this.context_action_queue.get(id);
        if (list == null) {
            list = new LinkedList();
            this.context_action_queue.put(id, list);
        }
        list.add(action);
        this.startAction(id);
    }

    public void setContextActionResult(String id, String result) {
        assert (Protocol.isDispatchThread());
        for (ActionsListener l : this.action_listeners) {
            l.onContextActionResult(id, result);
        }
    }

    public void removeContextAction(TCFAction action) {
        assert (Protocol.isDispatchThread());
        String id = action.getContextID();
        assert (this.active_actions.get(id) == action);
        for (ActionsListener l : this.action_listeners) {
            l.onContextActionDone(action);
        }
        this.active_actions.remove(id);
        this.startAction(id);
    }

    public void removeContextActions(String id) {
        assert (Protocol.isDispatchThread());
        this.context_action_queue.remove(id);
    }

    public int getContextActionsCount(String id) {
        int n;
        assert (Protocol.isDispatchThread());
        LinkedList<TCFAction> list = this.context_action_queue.get(id);
        int n2 = n = list == null ? 0 : list.size();
        if (this.active_actions.get(id) != null) {
            ++n;
        }
        return n;
    }

    public void addActionsListener(ActionsListener l) {
        this.action_listeners.add(l);
    }

    public void removeActionsListener(ActionsListener l) {
        this.action_listeners.remove(l);
    }

    public Set<String> getContextFilter() {
        return this.context_filter;
    }

    public static interface ActionsListener {
        public void onContextActionStart(TCFAction var1);

        public void onContextActionResult(String var1, String var2);

        public void onContextActionDone(TCFAction var1);
    }

    public static interface LaunchListener {
        public void onCreated(TCFLaunch var1);

        public void onConnected(TCFLaunch var1);

        public void onDisconnected(TCFLaunch var1);

        public void onProcessOutput(TCFLaunch var1, String var2, int var3, byte[] var4);

        public void onProcessStreamError(TCFLaunch var1, String var2, int var3, Exception var4, int var5);
    }

    private abstract class LaunchStep
    implements Runnable {
        LaunchStep() {
            TCFLaunch.this.launch_steps.add(this);
        }

        abstract void start() throws Exception;

        void done() {
            if (TCFLaunch.this.channel.getState() != 1) {
                return;
            }
            try {
                ((LaunchStep)TCFLaunch.this.launch_steps.removeFirst()).start();
            }
            catch (Throwable x) {
                TCFLaunch.this.channel.terminate(x);
            }
        }

        public void run() {
            this.done();
        }
    }
}

