/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.rse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.services.files.RemoteFileException;
import org.eclipse.rse.ui.subsystems.StandardConnectorService;
import org.eclipse.tm.internal.tcf.rse.ITCFSessionProvider;
import org.eclipse.tm.internal.tcf.rse.Messages;
import org.eclipse.tm.internal.tcf.rse.TCFConnectorServiceManager;
import org.eclipse.tm.tcf.core.AbstractPeer;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IFileSystem;
import org.eclipse.tm.tcf.services.ILocator;
import org.eclipse.tm.tcf.services.IStreams;
import org.eclipse.tm.tcf.services.ISysMonitor;
import org.eclipse.tm.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFConnectorService
extends StandardConnectorService
implements ITCFSessionProvider {
    public static final String PROPERTY_SET_NAME = "TCF Connection Settings";
    public static final String PROPERTY_LOGIN_REQUIRED = "Login.Required";
    public static final String PROPERTY_PWD_REQUIRED = "Pwd.Required";
    public static final String PROPERTY_LOGIN_PROMPT = "Login.Prompt";
    public static final String PROPERTY_PASSWORD_PROMPT = "Password.Prompt";
    public static final String PROPERTY_COMMAND_PROMPT = "Command.Prompt";
    private IChannel channel;
    private Throwable channel_error;
    private final List<Runnable> wait_list = new ArrayList<Runnable>();
    private boolean poll_timer_started;
    private boolean bSubscribed = false;
    private IStreams.StreamsListener streamListener = new IStreams.StreamsListener(){

        public void created(String stream_type, String stream_id, String context_id) {
        }

        public void disposed(String stream_type, String stream_id) {
        }
    };

    public TCFConnectorService(IHost host, int port) {
        super(Messages.TCFConnectorService_Name, Messages.TCFConnectorService_Description, host, port);
        this.getTCFPropertySet();
    }

    public IPropertySet getTCFPropertySet() {
        IPropertySet tcfSet = this.getPropertySet(PROPERTY_SET_NAME);
        if (tcfSet == null) {
            tcfSet = this.createPropertySet(PROPERTY_SET_NAME, Messages.PropertySet_Description);
            tcfSet.addProperty(PROPERTY_LOGIN_REQUIRED, "false", PropertyType.getEnumPropertyType((String[])new String[]{"true", "false"}));
            tcfSet.addProperty(PROPERTY_PWD_REQUIRED, "false", PropertyType.getEnumPropertyType((String[])new String[]{"true", "false"}));
            tcfSet.addProperty(PROPERTY_LOGIN_PROMPT, "ogin: ", PropertyType.getStringPropertyType());
            tcfSet.addProperty(PROPERTY_PASSWORD_PROMPT, "assword: ", PropertyType.getStringPropertyType());
            tcfSet.addProperty(PROPERTY_COMMAND_PROMPT, "#", PropertyType.getStringPropertyType());
        }
        return tcfSet;
    }

    public final boolean requiresPassword() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalConnect(final IProgressMonitor monitor) throws Exception {
        assert (!Protocol.isDispatchThread());
        final Exception[] res = new Exception[1];
        this.fireCommunicationsEvent(1);
        monitor.beginTask("Connecting " + this.getHostName(), 1);
        Exception[] exceptionArray = res;
        synchronized (res) {
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    if (!TCFConnectorService.this.connectTCFChannel(res, monitor)) {
                        TCFConnectorService.this.add_to_wait_list(this);
                    }
                }
            });
            res.wait();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (res[0] != null) {
                throw res[0];
            }
            monitor.done();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalDisconnect(final IProgressMonitor monitor) throws Exception {
        assert (!Protocol.isDispatchThread());
        final Exception[] res = new Exception[1];
        this.fireCommunicationsEvent(3);
        monitor.beginTask("Disconnecting " + this.getHostName(), 1);
        try {
            try {
                this.unsubscribe();
                Exception[] exceptionArray = res;
                synchronized (res) {
                    Protocol.invokeLater((Runnable)new Runnable(){

                        public void run() {
                            if (!TCFConnectorService.this.disconnectTCFChannel(res, monitor)) {
                                TCFConnectorService.this.add_to_wait_list(this);
                            }
                        }
                    });
                    res.wait();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    if (res[0] != null) {
                        throw res[0];
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RemoteFileException("Error creating Terminal", e);
            }
        }
        finally {
            monitor.done();
        }
        {
            return;
        }
    }

    public boolean isConnected() {
        final boolean[] res = new boolean[1];
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                res[0] = TCFConnectorService.this.channel != null && TCFConnectorService.this.channel.getState() == 1;
            }
        });
        return res[0];
    }

    private void add_to_wait_list(Runnable cb) {
        this.wait_list.add(cb);
        if (this.poll_timer_started) {
            return;
        }
        Protocol.invokeLater((long)1000L, (Runnable)new Runnable(){

            public void run() {
                TCFConnectorService.this.poll_timer_started = false;
                TCFConnectorService.this.run_wait_list();
            }
        });
        this.poll_timer_started = true;
    }

    private void run_wait_list() {
        if (this.wait_list.isEmpty()) {
            return;
        }
        Runnable[] r = this.wait_list.toArray(new Runnable[this.wait_list.size()]);
        this.wait_list.clear();
        int i = 0;
        while (i < r.length) {
            r[i].run();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectTCFChannel(Exception[] res, IProgressMonitor monitor) {
        if (this.channel != null) {
            switch (this.channel.getState()) {
                case 1: 
                case 2: {
                    Exception[] exceptionArray = res;
                    synchronized (res) {
                        res[0] = this.channel_error instanceof Exception ? (Exception)this.channel_error : (this.channel_error != null ? new Exception(this.channel_error) : null);
                        res.notify();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return true;
                    }
                }
            }
        }
        if (monitor.isCanceled()) {
            Exception[] exceptionArray = res;
            synchronized (res) {
                res[0] = new Exception("Canceled");
                if (this.channel != null) {
                    this.channel.terminate((Throwable)res[0]);
                }
                res.notify();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return true;
            }
        }
        if (this.channel == null) {
            String host = this.getHostName().toLowerCase();
            int port = this.getConnectPort();
            if (port <= 0) {
                port = TCFConnectorServiceManager.TCF_PORT;
            }
            IPeer peer = null;
            String port_str = Integer.toString(port);
            ILocator locator = Protocol.getLocator();
            for (IPeer p : locator.getPeers().values()) {
                Map attrs = p.getAttributes();
                if (!"TCP".equals(attrs.get("TransportName")) || !host.equalsIgnoreCase((String)attrs.get("Host")) || !port_str.equals(attrs.get("Port"))) continue;
                peer = p;
                break;
            }
            if (peer == null) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("ID", "RSE:" + host + ":" + port_str);
                attrs.put("Name", this.getName());
                attrs.put("TransportName", "TCP");
                attrs.put("Host", host);
                attrs.put("Port", port_str);
                peer = new AbstractPeer(attrs);
            }
            this.channel = peer.openChannel();
            this.channel.addChannelListener(new IChannel.IChannelListener(){

                public void onChannelOpened() {
                    if (!$assertionsDisabled && TCFConnectorService.this.channel == null) {
                        throw new AssertionError();
                    }
                    TCFConnectorService.this.run_wait_list();
                }

                public void congestionLevel(int level) {
                }

                public void onChannelClosed(Throwable error) {
                    if (!$assertionsDisabled && TCFConnectorService.this.channel == null) {
                        throw new AssertionError();
                    }
                    TCFConnectorService.this.channel.removeChannelListener((IChannel.IChannelListener)this);
                    TCFConnectorService.this.channel_error = error;
                    if (TCFConnectorService.this.wait_list.isEmpty()) {
                        TCFConnectorService.this.fireCommunicationsEvent(5);
                    } else {
                        TCFConnectorService.this.run_wait_list();
                    }
                    TCFConnectorService.this.bSubscribed = false;
                    TCFConnectorService.this.channel = null;
                    TCFConnectorService.this.channel_error = null;
                }
            });
            assert (this.channel.getState() == 0);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disconnectTCFChannel(Exception[] res, IProgressMonitor monitor) {
        if (this.channel == null || this.channel.getState() == 2) {
            Exception[] exceptionArray = res;
            synchronized (res) {
                res[0] = null;
                res.notify();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
        }
        if (monitor.isCanceled()) {
            Exception[] exceptionArray = res;
            synchronized (res) {
                res[0] = new Exception("Canceled");
                res.notify();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return true;
            }
        }
        if (this.channel.getState() == 1) {
            this.channel.close();
        }
        return false;
    }

    public <V extends IService> V getService(Class<V> service_interface) {
        if (this.channel == null || this.channel.getState() != 1) {
            throw new Error("Not connected");
        }
        IService m = this.channel.getRemoteService(service_interface);
        if (m == null) {
            throw new Error("Remote peer does not support " + service_interface.getName() + " service");
        }
        return (V)m;
    }

    public ISysMonitor getSysMonitorService() {
        return this.getService(ISysMonitor.class);
    }

    public IFileSystem getFileSystemService() {
        return this.getService(IFileSystem.class);
    }

    @Override
    public IChannel getChannel() {
        return this.channel;
    }

    @Override
    public String getSessionHostName() {
        String hostName = "";
        IHost host = this.getHost();
        if (host != null) {
            hostName = host.getHostName();
        }
        return hostName;
    }

    @Override
    public String getSessionUserId() {
        return this.getUserId();
    }

    @Override
    public String getSessionPassword() {
        String password = "";
        SystemSignonInformation ssi = this.getSignonInformation();
        if (ssi != null) {
            password = ssi.getPassword();
        }
        return password;
    }

    @Override
    public boolean isSubscribed() {
        return this.bSubscribed;
    }

    public void unsubscribe() throws IOException {
        if (this.bSubscribed) {
            new TCFTask<Object>(){

                public void run() {
                    IStreams streams = TCFConnectorService.this.getService(IStreams.class);
                    streams.unsubscribe("Terminals", TCFConnectorService.this.streamListener, new IStreams.DoneUnsubscribe(){

                        public void doneUnsubscribe(IToken token, Exception error) {
                            this.done(this);
                        }
                    });
                }
            }.getIO();
            this.bSubscribed = false;
        }
    }

    @Override
    public void subscribe() throws RemoteFileException {
        try {
            new TCFTask<Object>(){

                public void run() {
                    if (TCFConnectorService.this.bSubscribed) {
                        this.done((Object)this);
                    } else {
                        TCFConnectorService.this.bSubscribed = true;
                        IStreams streams = TCFConnectorService.this.getService(IStreams.class);
                        streams.subscribe("Terminals", TCFConnectorService.this.streamListener, new IStreams.DoneSubscribe(){

                            public void doneSubscribe(IToken token, Exception error) {
                                if (error != null) {
                                    TCFConnectorService.this.bSubscribed = false;
                                    this.error(error);
                                } else {
                                    this.done(this);
                                }
                            }
                        });
                    }
                }
            }.getIO();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteFileException("Error When Subscribe Terminal streams!", e);
        }
    }
}

