/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManagedBuildManager
extends AbstractCExtension
implements IScannerInfoProvider {
    private static final QualifiedName buildInfoProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "managedBuildInfo");
    private static final String ROOT_ELEM_NAME = "ManagedProjectBuildInfo";
    private static final String FILE_NAME = ".cdtbuild";
    private static final ITarget[] emptyTargets = new ITarget[0];
    public static final String INTERFACE_IDENTITY = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "." + "ManagedBuildManager";
    public static final String EXTENSION_POINT_ID = "ManagedBuildInfo";
    private static boolean extensionTargetsLoaded = false;
    private static List extensionTargets;
    private static Map extensionTargetMap;
    private static Map buildModelListeners;

    public static ITarget[] getDefinedTargets(IProject project) {
        ManagedBuildManager.loadExtensions();
        List definedTargets = null;
        int size = extensionTargets != null ? extensionTargets.size() + (definedTargets != null ? definedTargets.size() : 0) : 0;
        ITarget[] targets = new ITarget[size];
        int n = 0;
        int i = 0;
        while (i < extensionTargets.size()) {
            targets[n++] = (ITarget)extensionTargets.get(i);
            ++i;
        }
        if (definedTargets != null) {
            i = 0;
            while (i < definedTargets.size()) {
                targets[n++] = (ITarget)definedTargets.get(i);
                ++i;
            }
        }
        return targets;
    }

    public static Map getExtensionTargetMap() {
        if (extensionTargetMap == null) {
            extensionTargetMap = new HashMap();
        }
        return extensionTargetMap;
    }

    public static ITarget[] getTargets(IResource resource) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(resource);
        if (buildInfo != null) {
            List targets = buildInfo.getTargets();
            return targets.toArray(new ITarget[targets.size()]);
        }
        return emptyTargets;
    }

    public static ITarget getTarget(IResource resource, String id) {
        IManagedBuildInfo buildInfo;
        ITarget target = null;
        if (resource != null && (buildInfo = ManagedBuildManager.getBuildInfo(resource)) != null) {
            target = buildInfo.getTarget(id);
        }
        if (target == null) {
            target = (ITarget)ManagedBuildManager.getExtensionTargetMap().get(id);
        }
        return target;
    }

    public static ITarget createTarget(IResource resource, ITarget parentTarget) throws BuildException {
        IResource owner = parentTarget.getOwner();
        if (owner != null && owner.equals((Object)resource)) {
            return parentTarget;
        }
        if (resource instanceof IProject) {
            if (owner != null) {
                throw new BuildException("addTarget: owner not null");
            }
        } else {
            if (owner == null) {
                throw new BuildException("addTarget: null owner");
            }
            if (!owner.equals((Object)resource.getProject())) {
                throw new BuildException("addTarget: owner not project");
            }
        }
        return new Target(resource, parentTarget);
    }

    public static void setDefaultConfiguration(IProject project, IConfiguration newDefault) {
        if (project == null || newDefault == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setDefaultConfiguration(newDefault);
        }
    }

    private static void setDirty(IConfiguration config, IOption option) {
        IResource resource = config.getOwner();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo(resource);
        info.setDirty(true);
        if (option.getValueType() != 4 && option.getValueType() != 5) {
            return;
        }
        List listeners = (List)ManagedBuildManager.getBuildModelListeners().get(resource);
        if (listeners == null) {
            return;
        }
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ((IScannerInfoChangeListener)iter.next()).changeNotification(resource, (IScannerInfo)ManagedBuildManager.getBuildInfo(resource, false));
        }
    }

    public static void setOption(IConfiguration config, IOption option, boolean value) {
        try {
            config.setOption(option, value);
            ManagedBuildManager.setDirty(config, option);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void setOption(IConfiguration config, IOption option, String value) {
        try {
            config.setOption(option, value);
            ManagedBuildManager.setDirty(config, option);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void setOption(IConfiguration config, IOption option, String[] value) {
        try {
            config.setOption(option, value);
            ManagedBuildManager.setDirty(config, option);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void saveBuildInfo(IProject project) {
        DocumentImpl doc = new DocumentImpl();
        Element rootElement = doc.createElement(ROOT_ELEM_NAME);
        doc.appendChild(rootElement);
        ManagedBuildInfo buildInfo = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo != null) {
            buildInfo.serialize((Document)doc, rootElement);
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setLineSeparator(System.getProperty("line.separator"));
        String xml = null;
        try {
            Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)s, "UTF8"), format);
            serializer.asDOMSerializer().serialize((Document)doc);
            xml = s.toString("UTF8");
            IFile rscFile = project.getFile(FILE_NAME);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
            if (rscFile.exists()) {
                rscFile.setContents((InputStream)inputStream, 1, null);
            } else {
                rscFile.create((InputStream)inputStream, 1, null);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void removeBuildInfo(IResource resource) {
        try {
            resource.setSessionProperty(buildInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    public static void resetConfiguration(IProject project, IConfiguration configuration) {
        ManagedBuildManager.loadExtensions();
        IConfiguration parentConfig = configuration.getParent();
        ITarget parentTarget = parentConfig.getTarget();
        IExtensionPoint extensionPoint = ManagedBuilderCorePlugin.getDefault().getDescriptor().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (element.getName().equals("target") && element.getAttribute("id").equals(parentTarget.getId())) {
                    IConfigurationElement[] targetElements = element.getChildren();
                    int k = 0;
                    while (k < targetElements.length) {
                        IConfigurationElement targetElement = targetElements[k];
                        if (targetElement.getName().equals("configuration") && targetElement.getAttribute("id").equals(parentConfig.getId())) {
                            ((Configuration)configuration).reset(targetElement);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void addExtensionTarget(Target target) {
        if (extensionTargets == null) {
            extensionTargets = new ArrayList();
        }
        extensionTargets.add(target);
        ManagedBuildManager.getExtensionTargetMap().put(target.getId(), target);
    }

    private static ManagedBuildInfo loadBuildInfo(IProject project) {
        ManagedBuildInfo buildInfo = null;
        IFile file = project.getFile(FILE_NAME);
        if (!file.exists()) {
            return null;
        }
        try {
            InputStream stream = file.getContents();
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(stream);
            Node rootElement = document.getFirstChild();
            if (rootElement.getNodeName().equals(ROOT_ELEM_NAME)) {
                buildInfo = new ManagedBuildInfo((IResource)project, (Element)rootElement);
                project.setSessionProperty(buildInfoProperty, (Object)buildInfo);
            }
        }
        catch (Exception exception) {
            buildInfo = null;
        }
        return buildInfo;
    }

    private static void loadExtensions() {
        if (extensionTargetsLoaded) {
            return;
        }
        extensionTargetsLoaded = true;
        IExtensionPoint extensionPoint = ManagedBuilderCorePlugin.getDefault().getDescriptor().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (element.getName().equals("target")) {
                    new Target(element);
                }
                ++j;
            }
            ++i;
        }
    }

    public static boolean manages(IResource resource) {
        IProject project = null;
        if (resource instanceof IProject) {
            project = (IProject)resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return false;
        }
        IFile file = project.getFile(FILE_NAME);
        if (file.exists()) {
            try {
                InputStream stream = file.getContents();
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(stream);
                Node rootElement = document.getFirstChild();
                if (rootElement.getNodeName().equals(ROOT_ELEM_NAME)) {
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static ManagedBuildInfo findBuildInfo(IResource resource, boolean create) {
        ManagedBuildManager.loadExtensions();
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = (ManagedBuildInfo)resource.getSessionProperty(buildInfoProperty);
        }
        catch (CoreException coreException) {
            return buildInfo;
        }
        if (buildInfo == null && resource instanceof IProject) {
            buildInfo = ManagedBuildManager.loadBuildInfo((IProject)resource);
        }
        if (buildInfo == null && create) {
            try {
                buildInfo = new ManagedBuildInfo(resource);
                resource.setSessionProperty(buildInfoProperty, (Object)buildInfo);
            }
            catch (CoreException coreException) {
                buildInfo = null;
            }
        }
        return buildInfo;
    }

    public static IManagedBuildInfo getBuildInfo(IResource resource, boolean create) {
        return ManagedBuildManager.findBuildInfo(resource, create);
    }

    public static IManagedBuildInfo getBuildInfo(IResource resource) {
        return ManagedBuildManager.findBuildInfo(resource, false);
    }

    private static Map getBuildModelListeners() {
        if (buildModelListeners == null) {
            buildModelListeners = new HashMap();
        }
        return buildModelListeners;
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        return (IScannerInfo)ManagedBuildManager.getBuildInfo(resource, false);
    }

    public synchronized void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        ArrayList<IScannerInfoChangeListener> list = (ArrayList<IScannerInfoChangeListener>)map.get(project);
        if (list == null) {
            list = new ArrayList<IScannerInfoChangeListener>();
        }
        if (!list.contains(listener)) {
            list.add(listener);
            map.put(project, list);
        }
    }

    public synchronized void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        List list = (List)map.get(project);
        if (list != null && !list.isEmpty()) {
            list.remove(listener);
            map.put(project, list);
        }
    }
}

