/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Configuration
extends BuildObject
implements IConfiguration {
    private ITarget target;
    private IConfiguration parent;
    private List toolReferences;

    public Configuration(Target target, String id) {
        this.id = id;
        this.target = target;
        target.addConfiguration(this);
    }

    public Configuration(Target target, IConfiguration parent, String id) {
        this.id = id;
        this.name = parent.getName();
        this.target = target;
        this.parent = parent;
        IProject cfr_ignored_0 = (IProject)target.getOwner();
        List parentToolRefs = ((Configuration)parent).getLocalToolReferences();
        ListIterator iter = parentToolRefs.listIterator();
        while (iter.hasNext()) {
            ToolReference toolRef = (ToolReference)iter.next();
            ToolReference newRef = new ToolReference(this, toolRef.getTool());
            List optRefs = toolRef.getLocalOptionRefs();
            ListIterator optIter = optRefs.listIterator();
            while (optIter.hasNext()) {
                OptionReference optRef = (OptionReference)optIter.next();
                IOption opt = optRef.getOption();
                try {
                    switch (opt.getValueType()) {
                        case 0: {
                            new OptionReference(newRef, opt).setValue(optRef.getBooleanValue());
                            break;
                        }
                        case 2: {
                            new OptionReference(newRef, opt).setValue(optRef.getStringValue());
                            break;
                        }
                        case 1: {
                            new OptionReference(newRef, opt).setValue(optRef.getSelectedEnum());
                            break;
                        }
                        case 3: {
                            new OptionReference(newRef, opt).setValue(optRef.getStringListValue());
                            break;
                        }
                        case 4: {
                            new OptionReference(newRef, opt).setValue(optRef.getIncludePaths());
                            break;
                        }
                        case 5: {
                            new OptionReference(newRef, opt).setValue(optRef.getDefinedSymbols());
                            break;
                        }
                        case 6: {
                            new OptionReference(newRef, opt).setValue(optRef.getLibraries());
                            break;
                        }
                        case 7: {
                            new OptionReference(newRef, opt).setValue(optRef.getUserObjects());
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        target.addConfiguration(this);
    }

    public Configuration(Target target, IConfigurationElement element) {
        this.target = target;
        this.setId(element.getAttribute("id"));
        target.addConfiguration(this);
        this.setName(element.getAttribute("name"));
        IConfigurationElement[] configElements = element.getChildren();
        int l = 0;
        while (l < configElements.length) {
            IConfigurationElement configElement = configElements[l];
            if (configElement.getName().equals("toolReference")) {
                new ToolReference(this, configElement);
            }
            ++l;
        }
    }

    public Configuration(Target target, Element element) {
        this.target = target;
        this.setId(element.getAttribute("id"));
        target.addConfiguration(this);
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        if (element.hasAttribute("parent")) {
            ITarget targetParent = target.getParent();
            this.parent = targetParent != null ? targetParent.getConfiguration(element.getAttribute("parent")) : null;
        }
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (configElement.getNodeName().equals("toolReference")) {
                new ToolReference(this, (Element)configElement);
            }
            ++i;
        }
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        ListIterator iter = this.getLocalToolReferences().listIterator();
        while (iter.hasNext()) {
            ToolReference toolRef = (ToolReference)iter.next();
            Element toolRefElement = doc.createElement("toolReference");
            element.appendChild(toolRefElement);
            toolRef.serialize(doc, toolRefElement);
        }
    }

    protected List getLocalToolReferences() {
        if (this.toolReferences == null) {
            this.toolReferences = new ArrayList();
        }
        return this.toolReferences;
    }

    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    public ITool[] getTools() {
        ITool[] tools = this.parent != null ? this.parent.getTools() : this.target.getTools();
        IProject project = (IProject)this.target.getOwner();
        if (project != null) {
            ArrayList<ITool> validTools = new ArrayList<ITool>();
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                switch (tool.getNatureFilter()) {
                    case 0: {
                        try {
                            if (!project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            validTools.add(tool);
                        }
                        catch (CoreException coreException) {}
                        break;
                    }
                    case 1: {
                        try {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            validTools.add(tool);
                        }
                        catch (CoreException coreException) {}
                        break;
                    }
                    case 2: {
                        validTools.add(tool);
                    }
                }
                ++i;
            }
            tools = validTools.toArray(new ITool[validTools.size()]);
        }
        int i = 0;
        while (i < tools.length) {
            ToolReference ref;
            ITool tool = tools[i];
            if (tool != null && (ref = this.getToolReference(tools[i])) != null) {
                tools[i] = ref;
            }
            ++i;
        }
        return tools;
    }

    public void reset(IConfigurationElement element) {
        this.getLocalToolReferences().clear();
        IConfigurationElement[] configElements = element.getChildren();
        int l = 0;
        while (l < configElements.length) {
            IConfigurationElement configElement = configElements[l];
            if (configElement.getName().equals("toolReference")) {
                new ToolReference(this, configElement);
            }
            ++l;
        }
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    protected List getOptionReferences(ITool tool) {
        ArrayList<OptionReference> references = new ArrayList<OptionReference>();
        ToolReference toolRef = this.getToolReference(tool);
        if (toolRef != null) {
            references.addAll(toolRef.getLocalOptionRefs());
        }
        if (this.parent != null) {
            List temp = ((Configuration)this.parent).getOptionReferences(tool);
            ListIterator iter = temp.listIterator();
            while (iter.hasNext()) {
                OptionReference ref = (OptionReference)iter.next();
                if (references.contains(ref)) continue;
                references.add(ref);
            }
        }
        return references;
    }

    public ITarget getTarget() {
        return this.target == null && this.parent != null ? this.parent.getTarget() : this.target;
    }

    public IResource getOwner() {
        return this.getTarget().getOwner();
    }

    private ToolReference getToolReference(ITool tool) {
        ToolReference ref = null;
        ListIterator iter = this.getLocalToolReferences().listIterator();
        while (iter.hasNext()) {
            ToolReference temp = (ToolReference)iter.next();
            if (!temp.references(tool)) continue;
            ref = temp;
            break;
        }
        return ref;
    }

    public void addToolReference(ToolReference toolRef) {
        this.getLocalToolReferences().add(toolRef);
    }

    public OptionReference createOptionReference(IOption option) {
        if (option instanceof OptionReference) {
            OptionReference optionRef = (OptionReference)option;
            ToolReference toolRef = optionRef.getToolReference();
            if (toolRef.getConfiguration().equals(this)) {
                return optionRef;
            }
            toolRef = new ToolReference(this, toolRef);
            return toolRef.createOptionReference(option);
        }
        ToolReference toolRef = this.getToolReference(option.getTool());
        if (toolRef == null) {
            toolRef = new ToolReference(this, option.getTool());
        }
        return toolRef.createOptionReference(option);
    }

    public void setOption(IOption option, boolean value) throws BuildException {
        if (option.getBooleanValue() != value) {
            this.createOptionReference(option).setValue(value);
        }
    }

    public void setOption(IOption option, String value) throws BuildException {
        String oldValue = option.getValueType() == 1 ? option.getSelectedEnum() : option.getStringValue();
        if (!oldValue.equals(value)) {
            this.createOptionReference(option).setValue(value);
        }
    }

    public void setOption(IOption option, String[] value) throws BuildException {
        Object[] oldValue;
        switch (option.getValueType()) {
            case 3: {
                oldValue = option.getStringListValue();
                break;
            }
            case 4: {
                oldValue = option.getIncludePaths();
                break;
            }
            case 5: {
                oldValue = option.getDefinedSymbols();
                break;
            }
            case 6: {
                oldValue = option.getLibraries();
                break;
            }
            case 7: {
                oldValue = option.getUserObjects();
                break;
            }
            default: {
                oldValue = new String[]{};
            }
        }
        if (!Arrays.equals(value, oldValue)) {
            this.createOptionReference(option).setValue(value);
        }
    }
}

