/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManagedBuildInfo
implements IManagedBuildInfo,
IScannerInfo {
    private boolean isDirty;
    private IResource owner;
    private Map targetMap = new HashMap();
    private List targets = new ArrayList();
    private Map defaultConfigurations = new HashMap();
    private ITarget defaultTarget;

    public ManagedBuildInfo(IResource owner) {
        this.owner = owner;
    }

    public ManagedBuildInfo(IResource owner, Element element) {
        this(owner);
        String defaultTargetId = null;
        ArrayList<String> configIds = new ArrayList<String>();
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals("target")) {
                new Target(this, (Element)child);
            } else if (child.getNodeName().equals("defaultConfig")) {
                configIds.add(((Element)child).getAttribute("id"));
            } else if (child.getNodeName().equals("defaultTarget")) {
                defaultTargetId = ((Element)child).getAttribute("id");
            }
            child = child.getNextSibling();
        }
        this.defaultTarget = (ITarget)this.targetMap.get(defaultTargetId);
        ListIterator stringIter = configIds.listIterator();
        block1: while (stringIter.hasNext()) {
            String confId = (String)stringIter.next();
            ListIterator targIter = this.targets.listIterator();
            while (targIter.hasNext()) {
                Target targ = (Target)targIter.next();
                IConfiguration conf = targ.getConfiguration(confId);
                if (conf == null) continue;
                this.defaultConfigurations.put(targ.getId(), conf);
                continue block1;
            }
        }
    }

    public void addTarget(ITarget target) {
        this.targetMap.put(target.getId(), target);
        this.targets.add(target);
    }

    public boolean buildsFileType(String srcExt) {
        IProject project = (IProject)this.owner;
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            try {
                switch (tool.getNatureFilter()) {
                    case 0: {
                        if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                            return tool.buildsFileType(srcExt);
                        }
                        break;
                    }
                    case 1: {
                        if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                        return tool.buildsFileType(srcExt);
                    }
                    case 2: {
                        return tool.buildsFileType(srcExt);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++index;
        }
        return false;
    }

    public String getBuildArtifactName() {
        String name = this.getDefaultTarget().getArtifactName();
        return name == null ? new String() : name;
    }

    public String getCleanCommand() {
        String command = new String();
        ITarget target = this.getDefaultTarget();
        command = target.getCleanCommand();
        return command;
    }

    public String getConfigurationName() {
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        return config == null ? new String() : config.getName();
    }

    public String[] getConfigurationNames() {
        ArrayList<String> configNames = new ArrayList<String>();
        IConfiguration[] configs = this.getDefaultTarget().getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IConfiguration configuration = configs[i];
            configNames.add(configuration.getName());
            ++i;
        }
        configNames.trimToSize();
        return configNames.toArray(new String[configNames.size()]);
    }

    public IConfiguration getDefaultConfiguration(ITarget target) {
        IConfiguration[] configs;
        IConfiguration config = (IConfiguration)this.defaultConfigurations.get(target.getId());
        if (config == null && (configs = this.getDefaultTarget().getConfigurations()).length > 0) {
            config = configs[0];
        }
        return config;
    }

    public ITarget getDefaultTarget() {
        if (this.defaultTarget == null) {
            this.defaultTarget = (ITarget)this.targets.get(0);
        }
        return this.defaultTarget;
    }

    public Map getDefinedSymbols() {
        IProject project = (IProject)this.owner;
        HashMap<String, String> symbols = new HashMap<String, String>();
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int i = 0;
        while (i < tools.length) {
            block15: {
                ITool tool = tools[i];
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (!project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block15;
                            }
                            break;
                        }
                        case 1: {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break block15;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block15;
                }
                IOption[] opts = tool.getOptions();
                int j = 0;
                while (j < opts.length) {
                    IOption option = opts[j];
                    if (option.getValueType() == 5) {
                        try {
                            ArrayList<String> symbolList = new ArrayList<String>();
                            symbolList.addAll(Arrays.asList(option.getBuiltIns()));
                            symbolList.addAll(Arrays.asList(option.getDefinedSymbols()));
                            ListIterator iter = ((AbstractList)symbolList).listIterator();
                            while (iter.hasNext()) {
                                String symbol = (String)iter.next();
                                if (symbol.length() == 0) continue;
                                String key = new String();
                                String value = new String();
                                int index = symbol.indexOf("=");
                                if (index != -1) {
                                    key = symbol.substring(0, index).trim();
                                    value = symbol.substring(index + 1).trim();
                                } else {
                                    key = symbol.trim();
                                }
                                symbols.put(key, value);
                            }
                        }
                        catch (BuildException buildException) {}
                    }
                    ++j;
                }
            }
            ++i;
        }
        return symbols;
    }

    public String getFlagsForSource(String extension) {
        IProject project = (IProject)this.owner;
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.buildsFileType(extension)) {
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                return tool.getToolFlags();
                            }
                            break;
                        }
                        case 1: {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            return tool.getToolFlags();
                        }
                        case 2: {
                            return tool.getToolFlags();
                        }
                    }
                }
                catch (CoreException coreException) {
                }
                catch (BuildException buildException) {}
            }
            ++index;
        }
        return null;
    }

    public String getFlagsForTarget(String extension) {
        IProject project = (IProject)this.owner;
        String ext = extension == null ? new String() : extension;
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                return tool.getToolFlags();
                            }
                            break;
                        }
                        case 1: {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            return tool.getToolFlags();
                        }
                        case 2: {
                            return tool.getToolFlags();
                        }
                    }
                }
                catch (CoreException coreException) {
                }
                catch (BuildException buildException) {}
            }
            ++index;
        }
        return null;
    }

    public String[] getIncludePaths() {
        IProject project = (IProject)this.owner;
        ArrayList<String> paths = new ArrayList<String>();
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        IPath root = this.owner.getLocation().addTrailingSeparator().append(config.getName());
        ITool[] tools = config.getTools();
        int i = 0;
        while (i < tools.length) {
            block15: {
                ITool tool = tools[i];
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (!project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block15;
                            }
                            break;
                        }
                        case 1: {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break block15;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block15;
                }
                IOption[] opts = tool.getOptions();
                int j = 0;
                while (j < opts.length) {
                    IOption option = opts[j];
                    if (option.getValueType() == 4) {
                        try {
                            paths.addAll(Arrays.asList(option.getBuiltIns()));
                            String[] userPaths = option.getIncludePaths();
                            int index = 0;
                            while (index < userPaths.length) {
                                Path userPath = new Path(userPaths[index]);
                                if (userPath.isAbsolute()) {
                                    paths.add(userPath.toOSString());
                                } else {
                                    IPath absPath = root.addTrailingSeparator().append((IPath)userPath);
                                    paths.add(absPath.makeAbsolute().toOSString());
                                }
                                ++index;
                            }
                        }
                        catch (BuildException buildException) {}
                    }
                    ++j;
                }
            }
            ++i;
        }
        paths.trimToSize();
        return paths.toArray(new String[paths.size()]);
    }

    public String[] getLibsForTarget(String extension) {
        IProject project = (IProject)this.owner;
        ArrayList<String> libs = new ArrayList<String>();
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            block14: {
                ITool tool = tools[index];
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (!project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block14;
                            }
                            break;
                        }
                        case 1: {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break block14;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block14;
                }
                if (tool.producesFileType(extension)) {
                    IOption[] opts = tool.getOptions();
                    int i = 0;
                    while (i < opts.length) {
                        IOption option = opts[i];
                        if (option.getValueType() == 6) {
                            try {
                                String command = option.getCommand();
                                String[] allLibs = option.getLibraries();
                                int j = 0;
                                while (j < allLibs.length) {
                                    String string = allLibs[j];
                                    libs.add(String.valueOf(command) + string);
                                    ++j;
                                }
                            }
                            catch (BuildException buildException) {}
                        }
                        ++i;
                    }
                }
            }
            ++index;
        }
        libs.trimToSize();
        return libs.toArray(new String[libs.size()]);
    }

    public String getMakeArguments() {
        String arguments = new String();
        ITarget target = this.getDefaultTarget();
        String command = target.getMakeCommand();
        int indexOfArgs = command.indexOf(45);
        if (indexOfArgs != -1) {
            try {
                String argsAndTargs = command.substring(indexOfArgs);
                int indexOfTargs = argsAndTargs.indexOf(32);
                arguments = indexOfTargs != -1 ? argsAndTargs.substring(0, indexOfTargs) : argsAndTargs;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return arguments.trim();
    }

    public String getMakeCommand() {
        String command = new String();
        ITarget target = this.getDefaultTarget();
        command = target.getMakeCommand();
        int indexOfArgs = command.indexOf(45);
        if (indexOfArgs != -1) {
            return command.substring(0, indexOfArgs).trim();
        }
        return command.trim();
    }

    public String getOutputExtension(String resourceExtension) {
        IProject project = (IProject)this.owner;
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            try {
                switch (tool.getNatureFilter()) {
                    case 0: {
                        if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                            return tool.getOutputExtension(resourceExtension);
                        }
                        break;
                    }
                    case 1: {
                        if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                        return tool.getOutputExtension(resourceExtension);
                    }
                    case 2: {
                        return tool.getOutputExtension(resourceExtension);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++index;
        }
        return null;
    }

    public String getOutputFlag(String outputExt) {
        IProject project = (IProject)this.owner;
        String ext = outputExt == null ? new String() : outputExt;
        String flags = new String();
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            block9: {
                ITool tool = tools[index];
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (!project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block9;
                            }
                            break;
                        }
                        case 1: {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break block9;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block9;
                }
                if (tool.producesFileType(ext)) {
                    flags = tool.getOutputFlag();
                }
            }
            ++index;
        }
        return flags;
    }

    public String getOutputPrefix(String outputExtension) {
        IProject project = (IProject)this.owner;
        String ext = outputExtension == null ? new String() : outputExtension;
        String flags = new String();
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            block9: {
                ITool tool = tools[index];
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (!project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block9;
                            }
                            break;
                        }
                        case 1: {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break block9;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block9;
                }
                if (tool.producesFileType(ext)) {
                    flags = tool.getOutputPrefix();
                }
            }
            ++index;
        }
        return flags;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public ITarget getTarget(String id) {
        return (ITarget)this.targetMap.get(id);
    }

    public List getTargets() {
        return this.targets;
    }

    public String getToolForSource(String extension) {
        IProject project = (IProject)this.owner;
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.buildsFileType(extension)) {
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                return tool.getToolCommand();
                            }
                            break;
                        }
                        case 1: {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            return tool.getToolCommand();
                        }
                        case 2: {
                            return tool.getToolCommand();
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
            ++index;
        }
        return null;
    }

    public String getToolForTarget(String extension) {
        IProject project = (IProject)this.owner;
        String ext = extension == null ? new String() : extension;
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                return tool.getToolCommand();
                            }
                            break;
                        }
                        case 1: {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            return tool.getToolCommand();
                        }
                        case 2: {
                            return tool.getToolCommand();
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
            ++index;
        }
        return null;
    }

    public String[] getUserObjectsForTarget(String extension) {
        IProject project = (IProject)this.owner;
        ArrayList<String> objs = new ArrayList<String>();
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            block13: {
                ITool tool = tools[index];
                try {
                    switch (tool.getNatureFilter()) {
                        case 0: {
                            if (!project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                break block13;
                            }
                            break;
                        }
                        case 1: {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break block13;
                        }
                    }
                }
                catch (CoreException coreException) {
                    break block13;
                }
                if (tool.producesFileType(extension)) {
                    IOption[] opts = tool.getOptions();
                    int i = 0;
                    while (i < opts.length) {
                        IOption option = opts[i];
                        if (option.getValueType() == 7) {
                            try {
                                objs.addAll(Arrays.asList(option.getUserObjects()));
                            }
                            catch (BuildException buildException) {}
                        }
                        ++i;
                    }
                }
            }
            ++index;
        }
        objs.trimToSize();
        return objs.toArray(new String[objs.size()]);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isHeaderFile(String ext) {
        IProject project = (IProject)this.owner;
        IConfiguration config = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] tools = config.getTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            try {
                switch (tool.getNatureFilter()) {
                    case 0: {
                        if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                            return tool.isHeaderFile(ext);
                        }
                        break;
                    }
                    case 1: {
                        if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                        return tool.isHeaderFile(ext);
                    }
                    case 2: {
                        return tool.isHeaderFile(ext);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++index;
        }
        return false;
    }

    public void serialize(Document doc, Element element) {
        int i = 0;
        while (i < this.targets.size()) {
            Element targetElement = doc.createElement("target");
            element.appendChild(targetElement);
            ((Target)this.targets.get(i)).serialize(doc, targetElement);
            IConfiguration config = this.getDefaultConfiguration((ITarget)this.targets.get(i));
            if (config != null) {
                Element configEl = doc.createElement("defaultConfig");
                element.appendChild(configEl);
                configEl.setAttribute("id", config.getId());
            }
            ++i;
        }
        if (this.getDefaultTarget() != null) {
            Element targEl = doc.createElement("defaultTarget");
            element.appendChild(targEl);
            targEl.setAttribute("id", this.getDefaultTarget().getId());
        }
    }

    public void setDefaultConfiguration(IConfiguration configuration) {
        ITarget target = configuration.getTarget();
        this.setDefaultTarget(target);
        this.defaultConfigurations.put(target.getId(), configuration);
    }

    public void setDefaultTarget(ITarget target) {
        if (this.defaultTarget != null && this.defaultTarget.getId().equals(target.getId())) {
            return;
        }
        this.defaultTarget = target;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }
}

