/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OptionReference
implements IOption {
    private List builtIns;
    private String command;
    private IOption option;
    private ToolReference owner;
    private Object value;

    public OptionReference(ToolReference owner, IOption option) {
        this.owner = owner;
        this.option = option;
        owner.addOptionReference(this);
    }

    public OptionReference(ToolReference owner, IConfigurationElement element) {
        this.owner = owner;
        this.option = owner.getTool().getOption(element.getAttribute("id"));
        owner.addOptionReference(this);
        switch (this.option.getValueType()) {
            case 0: {
                this.value = new Boolean(element.getAttribute("defaultValue"));
                break;
            }
            case 2: {
                this.value = element.getAttribute("defaultValue");
                break;
            }
            case 1: {
                String temp = element.getAttribute("defaultValue");
                if (temp == null) {
                    try {
                        temp = this.option.getSelectedEnum();
                    }
                    catch (BuildException buildException) {
                        temp = new String();
                    }
                }
                this.value = temp;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ArrayList<String> valueList = new ArrayList<String>();
                this.builtIns = new ArrayList();
                IConfigurationElement[] valueElements = element.getChildren("listOptionValue");
                int i = 0;
                while (i < valueElements.length) {
                    IConfigurationElement valueElement = valueElements[i];
                    Boolean isBuiltIn = new Boolean(valueElement.getAttribute("builtIn"));
                    if (isBuiltIn.booleanValue()) {
                        this.builtIns.add(valueElement.getAttribute("value"));
                    } else {
                        valueList.add(valueElement.getAttribute("value"));
                    }
                    ++i;
                }
                this.value = valueList;
            }
        }
    }

    public OptionReference(ToolReference owner, Element element) {
        this.owner = owner;
        this.option = owner.getTool().getOption(element.getAttribute("id"));
        if (this.option == null) {
            return;
        }
        owner.addOptionReference(this);
        switch (this.option.getValueType()) {
            case 0: {
                this.value = new Boolean(element.getAttribute("defaultValue"));
                break;
            }
            case 1: 
            case 2: {
                this.value = element.getAttribute("defaultValue");
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ArrayList<String> valueList = new ArrayList<String>();
                this.builtIns = new ArrayList();
                NodeList nodes = element.getElementsByTagName("listOptionValue");
                int i = 0;
                while (i < nodes.getLength()) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() == 1) {
                        Boolean isBuiltIn = new Boolean(((Element)node).getAttribute("builtIn"));
                        if (isBuiltIn.booleanValue()) {
                            this.builtIns.add(((Element)node).getAttribute("value"));
                        } else {
                            valueList.add(((Element)node).getAttribute("value"));
                        }
                    }
                    ++i;
                }
                this.value = valueList;
            }
        }
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.option.getId());
        switch (this.option.getValueType()) {
            case 0: {
                element.setAttribute("defaultValue", ((Boolean)this.value).toString());
                break;
            }
            case 1: 
            case 2: {
                element.setAttribute("defaultValue", (String)this.value);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Element valueElement;
                ArrayList stringList = (ArrayList)this.value;
                ListIterator iter = ((AbstractList)stringList).listIterator();
                while (iter.hasNext()) {
                    valueElement = doc.createElement("listOptionValue");
                    valueElement.setAttribute("value", (String)iter.next());
                    valueElement.setAttribute("builtIn", "false");
                    element.appendChild(valueElement);
                }
                if (this.builtIns == null) break;
                iter = this.builtIns.listIterator();
                while (iter.hasNext()) {
                    valueElement = doc.createElement("listOptionValue");
                    valueElement.setAttribute("value", (String)iter.next());
                    valueElement.setAttribute("builtIn", "true");
                    element.appendChild(valueElement);
                }
                break;
            }
        }
    }

    public String[] getApplicableValues() {
        return this.option.getApplicableValues();
    }

    public IOptionCategory getCategory() {
        return this.option.getCategory();
    }

    public String getCommand() {
        return this.option.getCommand();
    }

    public String[] getDefinedSymbols() throws BuildException {
        if (this.value == null) {
            return this.option.getDefinedSymbols();
        }
        if (this.getValueType() == 5) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException("bad value type");
    }

    public String getEnumCommand(String name) {
        return this.option.getEnumCommand(name);
    }

    public String getId() {
        return this.option.getId();
    }

    public String[] getIncludePaths() throws BuildException {
        if (this.value == null) {
            return this.option.getIncludePaths();
        }
        if (this.getValueType() == 4) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException("bad value type");
    }

    public String[] getLibraries() throws BuildException {
        if (this.value == null) {
            return this.option.getLibraries();
        }
        if (this.getValueType() == 6) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException("bad value type");
    }

    public String getName() {
        return this.option.getName();
    }

    public boolean getBooleanValue() throws BuildException {
        if (this.value == null) {
            return this.option.getBooleanValue();
        }
        if (this.getValueType() == 0) {
            Boolean bool = (Boolean)this.value;
            return bool;
        }
        throw new BuildException("bad value type");
    }

    public String[] getBuiltIns() {
        return this.builtIns == null ? this.option.getBuiltIns() : this.builtIns.toArray(new String[this.builtIns.size()]);
    }

    public IOption getOption() {
        return this.option;
    }

    public String getSelectedEnum() throws BuildException {
        if (this.value == null) {
            return this.option.getSelectedEnum();
        }
        if (this.getValueType() == 1) {
            return (String)this.value;
        }
        throw new BuildException("bad value type");
    }

    public String[] getStringListValue() throws BuildException {
        if (this.value == null) {
            return this.option.getStringListValue();
        }
        if (this.getValueType() == 3) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException("bad value type");
    }

    public String getStringValue() throws BuildException {
        if (this.value == null) {
            return this.option.getStringValue();
        }
        if (this.getValueType() == 2) {
            return (String)this.value;
        }
        throw new BuildException("bad value type");
    }

    public ITool getTool() {
        return this.owner;
    }

    public ToolReference getToolReference() {
        return this.owner;
    }

    public String[] getUserObjects() throws BuildException {
        if (this.value == null) {
            return this.option.getDefinedSymbols();
        }
        if (this.getValueType() == 7) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException("bad value type");
    }

    public int getValueType() {
        return this.option.getValueType();
    }

    public boolean references(IOption target) {
        if (this.equals(target)) {
            return true;
        }
        if (this.option instanceof OptionReference) {
            return ((OptionReference)this.option).references(target);
        }
        return this.option.equals(target);
    }

    public void setValue(boolean value) throws BuildException {
        if (this.getValueType() != 0) {
            throw new BuildException("bad value type");
        }
        this.value = new Boolean(value);
    }

    public void setValue(String value) throws BuildException {
        if (this.getValueType() != 2 && this.getValueType() != 1) {
            throw new BuildException("bad value type");
        }
        this.value = value;
    }

    public void setValue(String[] value) throws BuildException {
        if (this.getValueType() != 3 && this.getValueType() != 4 && this.getValueType() != 5 && this.getValueType() != 6 && this.getValueType() != 7) {
            throw new BuildException("bad value type");
        }
        this.value = new ArrayList<String>(Arrays.asList(value));
    }
}

