/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.core.runtime.IConfigurationElement;

public class Tool
extends BuildObject
implements ITool,
IOptionCategory {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final IOptionCategory[] EMPTY_CATEGORIES = new IOptionCategory[0];
    private static final IOption[] EMPTY_OPTIONS = new IOption[0];
    private Map categoryMap;
    private List childOptionCategories;
    private String command;
    private List inputExtensions;
    private List interfaceExtensions;
    private int natureFilter;
    private Map optionMap;
    private List options;
    private String outputExtension;
    private String outputFlag;
    private String outputPrefix;
    private ITarget target;

    public Tool(Target target) {
        this.target = target;
    }

    public Tool(Target target, IConfigurationElement element) {
        this(target);
        this.setId(element.getAttribute("id"));
        target.addTool(this);
        this.setName(element.getAttribute("name"));
        String nature = element.getAttribute("natureFilter");
        this.natureFilter = nature == null || "both".equals(nature) ? 2 : ("cnature".equals(nature) ? 0 : ("ccnature".equals(nature) ? 1 : 2));
        String inputs = element.getAttribute("sources") == null ? new String() : element.getAttribute("sources");
        StringTokenizer tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
        while (tokenizer.hasMoreElements()) {
            this.getInputExtensions().add(tokenizer.nextElement());
        }
        String headers = element.getAttribute("headerExtensions");
        if (headers == null) {
            headers = new String();
        }
        tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
        while (tokenizer.hasMoreElements()) {
            this.getInterfaceExtensions().add(tokenizer.nextElement());
        }
        this.outputExtension = element.getAttribute("outputs") == null ? new String() : element.getAttribute("outputs");
        this.command = element.getAttribute("command") == null ? new String() : element.getAttribute("command");
        this.outputFlag = element.getAttribute("outputFlag") == null ? new String() : element.getAttribute("outputFlag");
        this.outputPrefix = element.getAttribute("outputPrefix") == null ? new String() : element.getAttribute("outputPrefix");
        this.categoryMap = new HashMap();
        this.addOptionCategory(this);
        IConfigurationElement[] toolElements = element.getChildren();
        int l = 0;
        while (l < toolElements.length) {
            IConfigurationElement toolElement = toolElements[l];
            if (toolElement.getName().equals("option")) {
                new Option(this, toolElement);
            } else if (toolElement.getName().equals("optionCategory")) {
                new OptionCategory(this, toolElement);
            }
            ++l;
        }
    }

    public IOptionCategory getOptionCategory(String id) {
        return (IOptionCategory)this.categoryMap.get(id);
    }

    void addOptionCategory(IOptionCategory category) {
        this.categoryMap.put(category.getId(), category);
    }

    public boolean buildsFileType(String extension) {
        if (extension == null) {
            return false;
        }
        return this.getInputExtensions().contains(extension);
    }

    void addChildCategory(IOptionCategory category) {
        if (this.childOptionCategories == null) {
            this.childOptionCategories = new ArrayList();
        }
        this.childOptionCategories.add(category);
    }

    public IOption[] getOptions() {
        if (this.options != null) {
            return this.options.toArray(new IOption[this.options.size()]);
        }
        return EMPTY_OPTIONS;
    }

    public void addOption(Option option) {
        if (this.options == null) {
            this.options = new ArrayList();
            this.optionMap = new HashMap();
        }
        this.options.add(option);
        this.optionMap.put(option.getId(), option);
    }

    public IOptionCategory getTopOptionCategory() {
        return this;
    }

    public IOptionCategory[] getChildCategories() {
        if (this.childOptionCategories != null) {
            return this.childOptionCategories.toArray(new IOptionCategory[this.childOptionCategories.size()]);
        }
        return EMPTY_CATEGORIES;
    }

    private List getInputExtensions() {
        if (this.inputExtensions == null) {
            this.inputExtensions = new ArrayList();
        }
        return this.inputExtensions;
    }

    private List getInterfaceExtensions() {
        if (this.interfaceExtensions == null) {
            this.interfaceExtensions = new ArrayList();
        }
        return this.interfaceExtensions;
    }

    public IOptionCategory createChildCategory() {
        OptionCategory category = new OptionCategory(this);
        if (this.childOptionCategories == null) {
            this.childOptionCategories = new ArrayList();
        }
        this.childOptionCategories.add(category);
        return category;
    }

    public String getOutputFlag() {
        return this.outputFlag == null ? new String() : this.outputFlag.trim();
    }

    public String getOutputPrefix() {
        return this.outputPrefix == null ? new String() : this.outputPrefix.trim();
    }

    public IOptionCategory getOwner() {
        return null;
    }

    public ITarget getTarget() {
        return this.target;
    }

    public ITool getTool() {
        return this;
    }

    public String getToolCommand() {
        return this.command.trim();
    }

    public String getToolFlags() throws BuildException {
        StringBuffer buf = new StringBuffer();
        IOption[] opts = this.getOptions();
        int index = 0;
        while (index < opts.length) {
            IOption option = opts[index];
            switch (option.getValueType()) {
                case 0: {
                    if (!option.getBooleanValue()) break;
                    buf.append(String.valueOf(option.getCommand()) + " ");
                    break;
                }
                case 1: {
                    String string = option.getEnumCommand(option.getSelectedEnum());
                    if (string.length() <= 0) break;
                    buf.append(String.valueOf(string) + " ");
                    break;
                }
                case 2: {
                    String val = option.getStringValue();
                    if (val.length() <= 0) break;
                    buf.append(String.valueOf(val) + " ");
                    break;
                }
                case 3: {
                    String listCmd = option.getCommand();
                    String[] list = option.getStringListValue();
                    int j = 0;
                    while (j < list.length) {
                        String temp = list[j];
                        buf.append(String.valueOf(listCmd) + temp + " ");
                        ++j;
                    }
                    break;
                }
                case 4: {
                    String incCmd = option.getCommand();
                    String[] paths = option.getIncludePaths();
                    int j = 0;
                    while (j < paths.length) {
                        String temp = paths[j];
                        buf.append(String.valueOf(incCmd) + temp + " ");
                        ++j;
                    }
                    break;
                }
                case 5: {
                    String defCmd = option.getCommand();
                    String[] symbols = option.getDefinedSymbols();
                    int j = 0;
                    while (j < symbols.length) {
                        String temp = symbols[j];
                        buf.append(String.valueOf(defCmd) + temp + " ");
                        ++j;
                    }
                    break;
                }
            }
            ++index;
        }
        return buf.toString().trim();
    }

    public IOption[] getOptions(IConfiguration configuration) {
        ITool tool = this;
        if (configuration != null) {
            ITool[] tools = configuration.getTools();
            int i = 0;
            while (i < tools.length) {
                if (tools[i] instanceof ToolReference) {
                    if (((ToolReference)tools[i]).references(tool)) {
                        tool = tools[i];
                        break;
                    }
                } else if (tools[i].equals(tool)) break;
                ++i;
            }
        }
        IOption[] allOptions = tool.getOptions();
        ArrayList<IOption> myOptions = new ArrayList<IOption>();
        int i = 0;
        while (i < allOptions.length) {
            IOption option = allOptions[i];
            if (option.getCategory().equals(this)) {
                myOptions.add(option);
            }
            ++i;
        }
        myOptions.trimToSize();
        return myOptions.toArray(new IOption[myOptions.size()]);
    }

    public int getNatureFilter() {
        return this.natureFilter;
    }

    public IOption getOption(String id) {
        return (IOption)this.optionMap.get(id);
    }

    public String getOutputExtension(String inputExtension) {
        ListIterator iter = this.getInputExtensions().listIterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).equals(inputExtension)) continue;
            return this.outputExtension;
        }
        return null;
    }

    public boolean isHeaderFile(String ext) {
        if (ext == null) {
            return false;
        }
        return this.getInterfaceExtensions().contains(ext);
    }

    public boolean producesFileType(String outputExtension) {
        return this.outputExtension.equals(outputExtension);
    }
}

