/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ManagedBuilderUIImages {
    private static ImageRegistry imageRegistry = new ImageRegistry();
    private static URL fgIconBaseURL;
    private static final String NAME_PREFIX;
    private static final int NAME_PREFIX_LENGTH;
    private static final String T = "full/";
    public static final String T_BUILD = "full/build16/";
    public static final String IMG_BUILD_CONFIG;
    public static final ImageDescriptor DESC_BUILD_CONFIG;
    public static final String IMG_BUILD_COMPILER;
    public static final ImageDescriptor DESC_BUILD_COMPILER;
    public static final String IMG_BUILD_LINKER;
    public static final ImageDescriptor DESC_BUILD_LINKER;
    public static final String IMG_BUILD_LIBRARIAN;
    public static final ImageDescriptor DESC_BUILD_LIBRARIAN;
    public static final String IMG_BUILD_COMMAND;
    public static final ImageDescriptor DESC_BUILD_COMMAND;
    public static final String IMG_BUILD_PREPROCESSOR;
    public static final ImageDescriptor DESC_BUILD_PREPROCESSOR;
    public static final String IMG_BUILD_TOOL;
    public static final ImageDescriptor DESC_BUILD_TOOL;
    public static final String IMG_BUILD_CAT;
    public static final ImageDescriptor DESC_BUILD_CAT;

    static {
        try {
            fgIconBaseURL = new URL(ManagedBuilderUIPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
        }
        catch (MalformedURLException e) {
            CUIPlugin.getDefault().log((Throwable)e);
        }
        NAME_PREFIX = String.valueOf(ManagedBuilderUIPlugin.getUniqueIdentifier()) + '.';
        NAME_PREFIX_LENGTH = NAME_PREFIX.length();
        IMG_BUILD_CONFIG = String.valueOf(NAME_PREFIX) + "build_configs.gif";
        DESC_BUILD_CONFIG = ManagedBuilderUIImages.createManaged(T_BUILD, IMG_BUILD_CONFIG);
        IMG_BUILD_COMPILER = String.valueOf(NAME_PREFIX) + "config-compiler.gif";
        DESC_BUILD_COMPILER = ManagedBuilderUIImages.createManaged(T_BUILD, IMG_BUILD_COMPILER);
        IMG_BUILD_LINKER = String.valueOf(NAME_PREFIX) + "config-linker.gif";
        DESC_BUILD_LINKER = ManagedBuilderUIImages.createManaged(T_BUILD, IMG_BUILD_LINKER);
        IMG_BUILD_LIBRARIAN = String.valueOf(NAME_PREFIX) + "config-librarian.gif";
        DESC_BUILD_LIBRARIAN = ManagedBuilderUIImages.createManaged(T_BUILD, IMG_BUILD_LIBRARIAN);
        IMG_BUILD_COMMAND = String.valueOf(NAME_PREFIX) + "config-command.gif";
        DESC_BUILD_COMMAND = ManagedBuilderUIImages.createManaged(T_BUILD, IMG_BUILD_COMMAND);
        IMG_BUILD_PREPROCESSOR = String.valueOf(NAME_PREFIX) + "config-preprocessor.gif";
        DESC_BUILD_PREPROCESSOR = ManagedBuilderUIImages.createManaged(T_BUILD, IMG_BUILD_PREPROCESSOR);
        IMG_BUILD_TOOL = String.valueOf(NAME_PREFIX) + "config-tool.gif";
        DESC_BUILD_TOOL = ManagedBuilderUIImages.createManaged(T_BUILD, IMG_BUILD_TOOL);
        IMG_BUILD_CAT = String.valueOf(NAME_PREFIX) + "config-category.gif";
        DESC_BUILD_CAT = ManagedBuilderUIImages.createManaged(T_BUILD, IMG_BUILD_CAT);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        return ManagedBuilderUIImages.createManaged(imageRegistry, prefix, name);
    }

    private static ImageDescriptor createManaged(ImageRegistry registry, String prefix, String name) {
        ImageDescriptor result = ImageDescriptor.createFromURL((URL)ManagedBuilderUIImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
        registry.put(name, result);
        return result;
    }

    public static Image get(String key) {
        return imageRegistry.get(key);
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)ManagedBuilderUIImages.makeIconFileURL(prefix, name));
    }

    private static URL makeIconFileURL(String prefix, String name) {
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append(name);
        try {
            return new URL(fgIconBaseURL, buffer.toString());
        }
        catch (MalformedURLException e) {
            CUIPlugin.getDefault().log((Throwable)e);
            return null;
        }
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        relPath = relPath.substring(NAME_PREFIX_LENGTH);
        action.setDisabledImageDescriptor(ManagedBuilderUIImages.create("full/d" + type, relPath));
        action.setHoverImageDescriptor(ManagedBuilderUIImages.create("full/c" + type, relPath));
        action.setImageDescriptor(ManagedBuilderUIImages.create("full/e" + type, relPath));
    }

    static ImageRegistry getImageRegistry() {
        return imageRegistry;
    }
}

