/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BrowseEntryDialog
extends Dialog {
    private static final String PREFIX = "BuildPropertyCommon";
    private static final String LABEL = "BuildPropertyCommon.label";
    private static final String BROWSE = "BuildPropertyCommon.label.browse";
    private String title = "";
    private String message = "";
    private String value = "";
    private Label errorMessageLabel;
    private Button btnBrowse = null;
    private Button btnOK = null;
    private Text text = null;

    public BrowseEntryDialog(Shell shell, String dialogTitle, String dialogMessage, String initialValue) {
        super(shell);
        if (dialogTitle != null) {
            this.title = dialogTitle;
        }
        if (dialogMessage != null) {
            this.message = dialogMessage;
        }
        if (initialValue != null) {
            this.value = initialValue;
        }
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText().trim() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)4);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData gd = new GridData(1796);
            gd.widthHint = this.convertHorizontalDLUsToPixels(300);
            gd.horizontalSpan = 4;
            label.setLayoutData((Object)gd);
            label.setFont(parent.getFont());
        }
        this.text = new Text(composite, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BrowseEntryDialog.this.updateButtonState();
            }
        });
        this.btnBrowse = ControlFactory.createPushButton((Composite)composite, (String)CUIPlugin.getResourceString((String)BROWSE));
        this.setButtonLayoutData(this.btnBrowse);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseEntryDialog.this.handleBrowsePressed();
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnOK = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
        }
        this.updateButtonState();
    }

    protected String getValue() {
        return this.value;
    }

    protected void handleBrowsePressed() {
        String directory;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String widgetText = this.text.getText().trim();
        if (widgetText.length() > 0) {
            dialog.setFilterPath(widgetText);
        }
        if ((directory = dialog.open()) != null) {
            this.text.setText(directory.trim());
            this.updateButtonState();
        }
    }

    protected void updateButtonState() {
        if (this.btnOK != null) {
            this.btnOK.setEnabled(this.text.getText().trim().length() > 0);
        }
    }
}

