/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;

public class BuildToolsSettingsStore
implements IPreferenceStore {
    public static final String DEFAULT_SEPERATOR = ";";
    private ListenerList listenerList = new ListenerList();
    private Map optionMap;
    private boolean dirtyFlag = false;
    private IConfiguration owner;

    public BuildToolsSettingsStore(IConfiguration config) {
        this.owner = config;
        this.populateOptionMap();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add((Object)listener);
    }

    public boolean contains(String name) {
        return this.getOptionMap().containsKey(name);
    }

    public static String createList(String[] items) {
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            if (i < items.length - 1) {
                path.append(DEFAULT_SEPERATOR);
            }
            ++i;
        }
        return path.toString();
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] listeners = this.listenerList.getListeners();
        if (!(listeners.length <= 0 || oldValue != null && oldValue.equals(newValue))) {
            PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)listeners[i];
                l.propertyChange(pe);
                ++i;
            }
        }
    }

    public boolean getBoolean(String name) {
        Object b = this.getOptionMap().get(name);
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        return false;
    }

    public boolean getDefaultBoolean(String name) {
        return false;
    }

    public double getDefaultDouble(String name) {
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        return 0;
    }

    public long getDefaultLong(String name) {
        return 0L;
    }

    public String getDefaultString(String name) {
        return new String();
    }

    public double getDouble(String name) {
        return this.getDefaultDouble(name);
    }

    public float getFloat(String name) {
        return this.getDefaultFloat(name);
    }

    public int getInt(String name) {
        return this.getDefaultInt(name);
    }

    public long getLong(String name) {
        return this.getDefaultLong(name);
    }

    private Map getOptionMap() {
        if (this.optionMap == null) {
            this.optionMap = new HashMap();
        }
        return this.optionMap;
    }

    private void getOptionsForCategory(IOptionCategory cat) {
        IOptionCategory[] children = cat.getChildCategories();
        int i = 0;
        while (i < children.length) {
            this.getOptionsForCategory(children[i]);
            ++i;
        }
        IOption[] options = cat.getOptions(this.owner);
        int j = 0;
        while (j < options.length) {
            IOption opt = options[j];
            String name = opt.getId();
            switch (opt.getValueType()) {
                case 0: {
                    Object value;
                    try {
                        value = new Boolean(opt.getBooleanValue());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getOptionMap().put(name, value);
                    break;
                }
                case 1: {
                    Object value = BuildToolsSettingsStore.createList(opt.getApplicableValues());
                    this.getOptionMap().put(name, value);
                    break;
                }
                case 2: {
                    Object value;
                    try {
                        value = opt.getStringValue();
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getOptionMap().put(name, value);
                    break;
                }
                case 3: {
                    Object value;
                    try {
                        value = BuildToolsSettingsStore.createList(opt.getStringListValue());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getOptionMap().put(name, value);
                    break;
                }
                case 4: {
                    Object value;
                    try {
                        value = BuildToolsSettingsStore.createList(opt.getIncludePaths());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getOptionMap().put(name, value);
                    break;
                }
                case 5: {
                    Object value;
                    try {
                        value = BuildToolsSettingsStore.createList(opt.getDefinedSymbols());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getOptionMap().put(name, value);
                    break;
                }
                case 6: {
                    Object value;
                    try {
                        value = BuildToolsSettingsStore.createList(opt.getLibraries());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getOptionMap().put(name, value);
                    break;
                }
                case 7: {
                    Object value;
                    try {
                        value = BuildToolsSettingsStore.createList(opt.getUserObjects());
                    }
                    catch (BuildException buildException) {
                        break;
                    }
                    this.getOptionMap().put(name, value);
                    break;
                }
            }
            ++j;
        }
    }

    public String getString(String name) {
        Object s = this.getOptionMap().get(name);
        if (s instanceof String) {
            return (String)s;
        }
        return this.getDefaultString(name);
    }

    public boolean isDefault(String name) {
        return false;
    }

    public boolean needsSaving() {
        return this.dirtyFlag;
    }

    public static String[] parseString(String stringList) {
        StringTokenizer tokenizer = new StringTokenizer(stringList, DEFAULT_SEPERATOR);
        ArrayList<Object> list = new ArrayList<Object>();
        while (tokenizer.hasMoreElements()) {
            list.add(tokenizer.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    private void populateOptionMap() {
        ITool[] tools = this.owner.getTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            IOptionCategory cat = tool.getTopOptionCategory();
            this.getOptionsForCategory(cat);
            ++index;
        }
    }

    public void putValue(String name, String value) {
        Object oldValue = this.getOptionMap().get(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.getOptionMap().put(name, value);
            this.setDirty(true);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
    }

    public void setDefault(String name, double value) {
    }

    public void setDefault(String name, float value) {
    }

    public void setDefault(String name, int value) {
    }

    public void setDefault(String name, long value) {
    }

    public void setDefault(String name, String defaultObject) {
    }

    public void setDefault(String name, boolean value) {
    }

    protected void setDirty(boolean isDirty) {
        this.dirtyFlag = isDirty;
    }

    public void setToDefault(String name) {
    }

    public void setValue(String name, double value) {
    }

    public void setValue(String name, float value) {
    }

    public void setValue(String name, int value) {
    }

    public void setValue(String name, long value) {
    }

    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.getOptionMap().put(name, value);
            this.setDirty(true);
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != value) {
            this.getOptionMap().put(name, new Boolean(value));
            this.setDirty(true);
            this.firePropertyChangeEvent(name, new Boolean(oldValue), new Boolean(value));
        }
    }
}

