/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.NewConfigurationDialog;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ManageConfigDialog
extends Dialog {
    private static final String CMN_PREFIX = "BuildPropertyCommon";
    private static final String CMN_LABEL = "BuildPropertyCommon.label";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String PREFIX = "ManageConfig";
    private static final String LABEL = "ManageConfig.label";
    private static final String RESTORE = "ManageConfig.label.restore";
    private static final String GROUP = "ManageConfig.label.makecmdgroup";
    private static final String DEF_BTN = "ManageConfig.label.makecmddef";
    private static final String OUTPUT_GROUP = "ManageConfig.label.output.group";
    private static final String OUTPUT_LABEL = "ManageConfig.label.output.label";
    private static final String CONFIGS = "ManageConfig.label.configs";
    private static final String CURRENT_CONFIGS = "ManageConfig.label.configs.current";
    private static final String DELETED_CONFIGS = "ManageConfig.label.configs.deleted";
    private static final String CONF_DLG = "ManageConfig.label.new.config.dialog";
    private String buildArtifact;
    private SortedMap deletedConfigs;
    private SortedMap existingConfigs;
    private String makeCommand;
    private ITarget managedTarget;
    private SortedMap newConfigs;
    private String title = "";
    private boolean useDefaultMake;
    protected Text buildArtifactEntry;
    protected List currentConfigList;
    protected List deletedConfigList;
    protected Button makeCommandDefault;
    protected Text makeCommandEntry;
    protected Button newBtn;
    protected Button okBtn;
    protected Button removeBtn;
    protected Button restoreBtn;

    protected ManageConfigDialog(Shell parentShell, String title, ITarget target) {
        super(parentShell);
        this.title = title;
        this.managedTarget = target;
        this.makeCommand = this.managedTarget.getMakeCommand();
        this.buildArtifact = this.managedTarget.getArtifactName();
        this.getExistingConfigs().clear();
        IConfiguration[] configs = this.managedTarget.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IConfiguration configuration = configs[i];
            this.getExistingConfigs().put(configuration.getName(), configuration.getId());
            ++i;
        }
        this.getDeletedConfigs().clear();
        this.getNewConfigs().clear();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.useDefaultMake = this.makeCommandDefault.getSelection();
            this.makeCommand = this.makeCommandEntry.getText().trim();
            this.buildArtifact = this.buildArtifactEntry.getText().trim();
        } else {
            this.useDefaultMake = true;
            this.buildArtifact = this.managedTarget.getArtifactName();
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okBtn = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = ControlFactory.createComposite((Composite)parent, (int)1);
        Group outputGroup = ControlFactory.createGroup((Composite)comp, (String)ManagedBuilderUIPlugin.getResourceString(OUTPUT_GROUP), (int)1);
        outputGroup.setLayoutData((Object)new GridData(1808));
        Label outputLabel = ControlFactory.createLabel((Composite)outputGroup, (String)ManagedBuilderUIPlugin.getResourceString(OUTPUT_LABEL));
        outputLabel.setLayoutData((Object)new GridData());
        this.buildArtifactEntry = ControlFactory.createTextField((Composite)outputGroup);
        this.buildArtifactEntry.setText(this.buildArtifact);
        this.buildArtifactEntry.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.buildArtifactEntry = null;
            }
        });
        Group makeCommandGroup = ControlFactory.createGroup((Composite)comp, (String)ManagedBuilderUIPlugin.getResourceString(GROUP), (int)1);
        GridData gd = new GridData(1808);
        makeCommandGroup.setLayoutData((Object)gd);
        this.makeCommandDefault = ControlFactory.createCheckBox((Composite)makeCommandGroup, (String)ManagedBuilderUIPlugin.getResourceString(DEF_BTN));
        this.setButtonLayoutData(this.makeCommandDefault);
        this.makeCommandDefault.setSelection(!this.managedTarget.hasOverridenMakeCommand());
        this.makeCommandDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleUseDefaultPressed();
            }
        });
        this.makeCommandDefault.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.makeCommandDefault = null;
            }
        });
        this.makeCommandEntry = ControlFactory.createTextField((Composite)makeCommandGroup);
        this.makeCommandEntry.setEditable(!this.makeCommandDefault.getSelection());
        this.makeCommandEntry.setText(this.makeCommand);
        this.makeCommandEntry.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.makeCommandEntry = null;
            }
        });
        Group configListGroup = ControlFactory.createGroup((Composite)comp, (String)ManagedBuilderUIPlugin.getResourceString(CONFIGS), (int)3);
        gd = new GridData(1808);
        configListGroup.setLayoutData((Object)gd);
        Label currentConfigLabel = ControlFactory.createLabel((Composite)configListGroup, (String)ManagedBuilderUIPlugin.getResourceString(CURRENT_CONFIGS));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        currentConfigLabel.setLayoutData((Object)gd);
        Label deletedConfigLabel = ControlFactory.createLabel((Composite)configListGroup, (String)ManagedBuilderUIPlugin.getResourceString(DELETED_CONFIGS));
        deletedConfigLabel.setLayoutData((Object)new GridData());
        Composite currentComp = ControlFactory.createComposite((Composite)configListGroup, (int)1);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        currentComp.setLayoutData((Object)gd);
        this.currentConfigList = new List(currentComp, 2820);
        gd = new GridData(1808);
        gd.widthHint = 100;
        this.currentConfigList.setLayoutData((Object)gd);
        this.currentConfigList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.currentConfigList = null;
            }
        });
        Composite buttonBar = ControlFactory.createComposite((Composite)configListGroup, (int)1);
        buttonBar.setLayoutData((Object)new GridData());
        this.newBtn = ControlFactory.createPushButton((Composite)buttonBar, (String)CUIPlugin.getResourceString((String)NEW));
        this.setButtonLayoutData(this.newBtn);
        this.newBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleNewPressed();
            }
        });
        this.newBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ManageConfigDialog.this.newBtn = null;
            }
        });
        this.removeBtn = ControlFactory.createPushButton((Composite)buttonBar, (String)CUIPlugin.getResourceString((String)REMOVE));
        this.setButtonLayoutData(this.removeBtn);
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleRemovePressed();
            }
        });
        this.removeBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ManageConfigDialog.this.removeBtn = null;
            }
        });
        this.restoreBtn = ControlFactory.createPushButton((Composite)buttonBar, (String)ManagedBuilderUIPlugin.getResourceString(RESTORE));
        this.setButtonLayoutData(this.restoreBtn);
        this.restoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleRestorePressed();
            }
        });
        this.restoreBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ManageConfigDialog.this.restoreBtn = null;
            }
        });
        Composite deletedComp = ControlFactory.createComposite((Composite)configListGroup, (int)1);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        deletedComp.setLayoutData((Object)gd);
        this.deletedConfigList = new List(deletedComp, 2820);
        gd = new GridData(1808);
        gd.widthHint = 100;
        this.deletedConfigList.setLayoutData((Object)gd);
        this.deletedConfigList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.deletedConfigList = null;
            }
        });
        this.currentConfigList.setItems(this.getConfigurationNames());
        this.currentConfigList.select(0);
        this.newBtn.setFocus();
        return comp;
    }

    protected void handleUseDefaultPressed() {
        this.makeCommandEntry.setEditable(!this.makeCommandDefault.getSelection());
    }

    public String getBuildArtifactName() {
        return this.buildArtifact;
    }

    private String[] getConfigurationNames() {
        return this.getExistingConfigs().keySet().toArray(new String[this.getExistingConfigs().size()]);
    }

    protected SortedMap getDeletedConfigs() {
        if (this.deletedConfigs == null) {
            this.deletedConfigs = new TreeMap();
        }
        return this.deletedConfigs;
    }

    public ArrayList getDeletedConfigIds() {
        return new ArrayList(this.getDeletedConfigs().values());
    }

    protected SortedMap getExistingConfigs() {
        if (this.existingConfigs == null) {
            this.existingConfigs = new TreeMap();
        }
        return this.existingConfigs;
    }

    public String getMakeCommand() {
        return this.makeCommand;
    }

    public SortedMap getNewConfigs() {
        if (this.newConfigs == null) {
            this.newConfigs = new TreeMap();
        }
        return this.newConfigs;
    }

    private IProject getProject() {
        return this.managedTarget.getOwner().getProject();
    }

    protected void handleNewPressed() {
        NewConfigurationDialog dialog;
        ITarget parentTarget = null;
        ITarget[] targets = ManagedBuildManager.getDefinedTargets((IProject)this.getProject());
        int i = 0;
        while (i < targets.length) {
            ITarget target = targets[i];
            if (target.getId().equals(this.managedTarget.getParent().getId())) {
                parentTarget = target;
                break;
            }
            ++i;
        }
        IConfiguration[] allDefinedConfigs = null;
        if (parentTarget != null) {
            allDefinedConfigs = parentTarget.getConfigurations();
        }
        if (allDefinedConfigs != null && allDefinedConfigs.length != 0 && (dialog = new NewConfigurationDialog(this.getShell(), allDefinedConfigs, this.managedTarget, ManagedBuilderUIPlugin.getResourceString(CONF_DLG))).open() == 0) {
            String newConfigName = dialog.getNewName();
            this.getNewConfigs().put(newConfigName, dialog.getParentConfiguration());
            this.currentConfigList.add(newConfigName);
            this.currentConfigList.setSelection(this.currentConfigList.getItemCount() - 1);
        }
        this.updateButtons();
    }

    protected void handleRemovePressed() {
        int selectionIndex = this.currentConfigList.getSelectionIndex();
        if (selectionIndex != -1) {
            String selectedConfigName = this.currentConfigList.getItem(selectionIndex);
            String selectedConfigId = null;
            if (this.getNewConfigs().containsKey(selectedConfigName)) {
                selectedConfigId = (String)this.getNewConfigs().get(selectedConfigName);
                this.getNewConfigs().remove(selectedConfigName);
            }
            selectedConfigId = (String)this.getExistingConfigs().get(selectedConfigName);
            this.getDeletedConfigs().put(selectedConfigName, selectedConfigId);
            this.currentConfigList.remove(selectionIndex);
            this.currentConfigList.setSelection(selectionIndex - 1);
            this.deletedConfigList.add(selectedConfigName);
            this.deletedConfigList.setSelection(this.deletedConfigList.getItemCount() - 1);
            this.updateButtons();
        }
    }

    protected void handleRestorePressed() {
        int selectionIndex = this.deletedConfigList.getSelectionIndex();
        if (selectionIndex != -1) {
            String selectedConfigName = this.deletedConfigList.getItem(selectionIndex);
            String selectedConfigId = (String)this.getDeletedConfigs().get(selectedConfigName);
            if (!this.getExistingConfigs().containsKey(selectedConfigName)) {
                this.getNewConfigs().put(selectedConfigName, selectedConfigId);
            }
            this.getDeletedConfigs().remove(selectedConfigName);
            this.deletedConfigList.remove(selectionIndex);
            this.deletedConfigList.setSelection(selectionIndex - 1);
            this.currentConfigList.add(selectedConfigName);
            this.currentConfigList.setSelection(this.currentConfigList.getItemCount());
            this.updateButtons();
        }
    }

    private void updateButtons() {
        this.removeBtn.setEnabled(this.currentConfigList.getItemCount() > 1);
        this.restoreBtn.setEnabled(this.deletedConfigList.getItemCount() > 0);
    }

    public boolean useDefaultMakeCommand() {
        return this.useDefaultMake;
    }
}

