/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.wizards.ConfigurationContentProvider;
import org.eclipse.cdt.managedbuilder.ui.wizards.ConfigurationLabelProvider;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.help.WorkbenchHelp;

public class CProjectPlatformPage
extends WizardPage {
    private ArrayList selectedConfigurations;
    protected ITarget selectedTarget;
    protected String[] targetNames;
    protected ArrayList targets;
    protected Combo platformSelection;
    protected CheckboxTableViewer tableViewer;
    private static final String PREFIX = "PlatformBlock";
    private static final String LABEL = "PlatformBlock.label";
    private static final String TIP = "PlatformBlock.tip";
    private static final String PLATFORM_TIP = "PlatformBlock.tip.platform";
    private static final String PLATFORM_LABEL = "PlatformBlock.label.platform";
    private static final String CONFIG_LABEL = "PlatformBlock.label.configs";

    public CProjectPlatformPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.populateTargets();
        this.selectedTarget = null;
        this.selectedConfigurations = new ArrayList(0);
    }

    public boolean canFlipToNextPage() {
        return this.validatePage();
    }

    public void createControl(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)6);
        Label platformLabel = ControlFactory.createLabel((Composite)composite, (String)ManagedBuilderUIPlugin.getResourceString(PLATFORM_LABEL));
        platformLabel.setLayoutData((Object)new GridData());
        this.platformSelection = ControlFactory.createSelectCombo((Composite)composite, (String[])this.targetNames, null);
        this.platformSelection.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CProjectPlatformPage.this.handleTargetSelection();
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 5;
        this.platformSelection.setLayoutData((Object)gd);
        Label configLabel = ControlFactory.createLabel((Composite)composite, (String)ManagedBuilderUIPlugin.getResourceString(CONFIG_LABEL));
        configLabel.setLayoutData((Object)new GridData(768));
        Table table = new Table(composite, 2854);
        gd = new GridData(1808);
        gd.horizontalSpan = 6;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableLayout tableLayout = new TableLayout();
        table.setHeaderVisible(false);
        table.setLayout((Layout)tableLayout);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CProjectPlatformPage.this.handleConfigurationSelectionChange();
            }
        });
        this.handleTargetSelection();
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.man_proj_platform_help");
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    public IConfiguration[] getSelectedConfigurations() {
        return this.selectedConfigurations.toArray(new IConfiguration[this.selectedConfigurations.size()]);
    }

    public ITarget getSelectedTarget() {
        return this.selectedTarget;
    }

    private void handleConfigurationSelectionChange() {
        this.selectedConfigurations.clear();
        this.selectedConfigurations.addAll(Arrays.asList(this.tableViewer.getCheckedElements()));
    }

    protected void handleTargetSelection() {
        int index;
        if (this.platformSelection != null && (index = this.platformSelection.getSelectionIndex()) != -1) {
            this.selectedTarget = (ITarget)this.targets.get(index);
        }
        this.populateConfigurations();
        this.setPageComplete(this.validatePage());
    }

    private void populateConfigurations() {
        this.tableViewer.setInput((Object)this.selectedTarget);
        this.tableViewer.setAllChecked(true);
        this.handleConfigurationSelectionChange();
    }

    private void populateTargetNames() {
        this.targetNames = new String[this.targets.size()];
        ListIterator iter = ((AbstractList)this.targets).listIterator();
        int index = 0;
        while (iter.hasNext()) {
            this.targetNames[index++] = ((ITarget)iter.next()).getName();
        }
    }

    private void populateTargets() {
        ITarget[] allTargets = ManagedBuildManager.getDefinedTargets(null);
        this.targets = new ArrayList();
        String os = BootLoader.getOS();
        int index = 0;
        while (index < allTargets.length) {
            List<String> targetOSList;
            ITarget target = allTargets[index];
            if (!target.isAbstract() && !target.isTestTarget() && (targetOSList = Arrays.asList(target.getTargetOSList())).contains(os)) {
                this.targets.add(target);
            }
            ++index;
        }
        this.targets.trimToSize();
        this.populateTargetNames();
    }

    private boolean validatePage() {
        return true;
    }
}

