/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.Random;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.wizards.CProjectPlatformPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectOptionPage;
import org.eclipse.cdt.ui.wizards.NewCProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class NewManagedProjectWizard
extends NewCProjectWizard {
    protected static final String PREFIX = "MngMakeProjectWizard";
    protected static final String OP_ERROR = "MngMakeProjectWizard.op_error";
    protected static final String WZ_TITLE = "MngMakeProjectWizard.title";
    protected static final String WZ_DESC = "MngMakeProjectWizard.description";
    protected static final String CONF_TITLE = "MngMakeProjectWizard.config.title";
    protected static final String CONF_DESC = "MngMakeProjectWizard.config.desc";
    protected static final String OPTIONS_TITLE = "MngMakeProjectWizard.options.title";
    protected static final String OPTIONS_DESC = "MngMakeProjectWizard.options.desc";
    protected static final String MSG_ADD_NATURE = "MngMakeProjectWizard.message.add_nature";
    protected static final String MSG_ADD_BUILDER = "MngMakeProjectWizard.message.add_builder";
    protected static final String MSG_SAVE = "MngMakeProjectWizard.message.save";
    protected static final String SETTINGS_TITLE = "MngMakeWizardSettings.title";
    protected static final String SETTINGS_DESC = "MngMakeWizardSettings.description";
    protected CProjectPlatformPage targetConfigurationPage;
    protected NewManagedProjectOptionPage optionPage;

    public NewManagedProjectWizard() {
        this(ManagedBuilderUIPlugin.getResourceString(WZ_TITLE), ManagedBuilderUIPlugin.getResourceString(WZ_DESC));
    }

    public NewManagedProjectWizard(String title, String description) {
        super(title, description);
    }

    public void addPages() {
        super.addPages();
        this.targetConfigurationPage = new CProjectPlatformPage(PREFIX);
        this.targetConfigurationPage.setTitle(ManagedBuilderUIPlugin.getResourceString(CONF_TITLE));
        this.targetConfigurationPage.setDescription(ManagedBuilderUIPlugin.getResourceString(CONF_DESC));
        this.addPage((IWizardPage)this.targetConfigurationPage);
        this.optionPage = new NewManagedProjectOptionPage(PREFIX);
        this.optionPage.setTitle(ManagedBuilderUIPlugin.getResourceString(OPTIONS_TITLE));
        this.optionPage.setDescription(ManagedBuilderUIPlugin.getResourceString(OPTIONS_DESC));
        this.addPage((IWizardPage)this.optionPage);
    }

    protected void doRun(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        super.doRun((IProgressMonitor)new SubProgressMonitor(monitor, 5));
        try {
            monitor.subTask(ManagedBuilderUIPlugin.getResourceString(MSG_ADD_NATURE));
            ManagedCProjectNature.addManagedNature((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException coreException) {}
        try {
            monitor.subTask(ManagedBuilderUIPlugin.getResourceString(MSG_ADD_BUILDER));
            ManagedCProjectNature.addManagedBuilder((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException coreException) {}
        if (this.newProject != null) {
            this.optionPage.performApply((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        ITarget newTarget = null;
        try {
            ITarget parent = this.targetConfigurationPage.getSelectedTarget();
            newTarget = ManagedBuildManager.createTarget((IResource)this.newProject, (ITarget)parent);
            if (newTarget != null) {
                String artifactName = this.newProject.getName();
                artifactName = String.valueOf(artifactName) + (parent.getDefaultExtension().length() == 0 ? "" : "." + parent.getDefaultExtension());
                newTarget.setBuildArtifact(artifactName);
                IConfiguration[] selectedConfigs = this.targetConfigurationPage.getSelectedConfigurations();
                Random r = new Random();
                r.setSeed(System.currentTimeMillis());
                int i = 0;
                while (i < selectedConfigs.length) {
                    IConfiguration config = selectedConfigs[i];
                    int id = r.nextInt();
                    if (id < 0) {
                        id *= -1;
                    }
                    newTarget.createConfiguration(config, String.valueOf(config.getId()) + "." + id);
                    ++i;
                }
                IConfiguration[] newConfigs = newTarget.getConfigurations();
                if (newConfigs.length > 0) {
                    ManagedBuildManager.setDefaultConfiguration((IProject)this.newProject, (IConfiguration)newConfigs[0]);
                }
            }
        }
        catch (BuildException buildException) {}
        try {
            ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(this.newProject);
            desc.remove("org.eclipse.cdt.core.ScannerInfoProvider");
            desc.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
            desc.remove("org.eclipse.cdt.core.BinaryParser");
            desc.create("org.eclipse.cdt.core.BinaryParser", newTarget.getBinaryParserId());
        }
        catch (CoreException coreException) {}
        monitor.subTask(ManagedBuilderUIPlugin.getResourceString(MSG_SAVE));
        ManagedBuildManager.saveBuildInfo((IProject)this.newProject);
        monitor.done();
    }

    protected void doRunPrologue(IProgressMonitor monitor) {
    }

    protected void doRunEpilogue(IProgressMonitor monitor) {
    }

    public String getProjectID() {
        return "org.eclipse.cdt.make.core.make";
    }
}

