/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.PatternRule;

public class MakefileSimpleMacroRule
extends PatternRule {
    private int nOfBrackets;

    public MakefileSimpleMacroRule(IToken token) {
        super("$(", ")", token, '\u0000', true);
    }

    protected IToken doEvaluate(ICharacterScanner scanner) {
        this.nOfBrackets = 1;
        return super.doEvaluate(scanner);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = scanner.read()) != -1) {
            if ('(' == (char)c) {
                ++this.nOfBrackets;
            }
            if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (!this.sequenceDetected(scanner, this.fEndSequence, true) || --this.nOfBrackets != 0) continue;
                return true;
            }
            if (!this.fBreaksOnEOL) continue;
            int i = 0;
            while (i < delimiters.length) {
                if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], false)) {
                    return true;
                }
                ++i;
            }
        }
        scanner.unread();
        return true;
    }
}

