/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.part.StructuredViewerPart;
import org.eclipse.cdt.make.ui.MakeContentProvider;
import org.eclipse.cdt.make.ui.MakeLabelProvider;
import org.eclipse.cdt.make.ui.dialogs.MakeTargetDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TargetListViewerPart
extends StructuredViewerPart {
    private TableViewer tableViewer;
    private IMakeTarget fSelectedTarget;
    private final int ADD_TARGET = 0;
    private final int REMOVE_TARGET = 1;
    private final int EDIT_TARGET = 2;
    private IContainer fContainer;

    public TargetListViewerPart(IContainer container) {
        super(new String[]{"Add Target...", "Remove Target", "Edit Target..."});
        this.fContainer = container;
    }

    protected StructuredViewer createStructuredViewer(Composite parent, int style) {
        this.tableViewer = new TableViewer(parent, 2052);
        Table table = (Table)this.tableViewer.getControl();
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setText("Targets");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        tc = new TableColumn(table, 0, 1);
        tc.setText("Location");
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TargetListViewerPart.this.selectionChanged((IStructuredSelection)e.getSelection());
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new MakeContentProvider(true));
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IMakeTarget;
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MakeLabelProvider(this.fContainer.getProjectRelativePath()));
        this.tableViewer.setInput((Object)this.fContainer);
        return this.tableViewer;
    }

    protected void buttonSelected(Button button, int index) {
        try {
            switch (index) {
                case 0: {
                    MakeTargetDialog dialog = new MakeTargetDialog(this.getControl().getShell(), this.fContainer);
                    dialog.open();
                    break;
                }
                case 1: {
                    IMakeTargetManager manager = MakeCorePlugin.getDefault().getTargetManager();
                    manager.removeTarget((IMakeTarget)((IStructuredSelection)this.getViewer().getSelection()).getFirstElement());
                    break;
                }
                case 2: {
                    MakeTargetDialog dialog = new MakeTargetDialog(this.getControl().getShell(), (IMakeTarget)((IStructuredSelection)this.getViewer().getSelection()).getFirstElement());
                    dialog.open();
                }
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.errorDialog(this.getControl().getShell(), "Error", "Error", e);
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.fSelectedTarget = (IMakeTarget)selection.getFirstElement();
        if (this.getViewer() != null) {
            this.updateEnabledState();
        }
    }

    public void setSelectedTarget(IMakeTarget target) {
        this.fSelectedTarget = target;
        if (this.tableViewer != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.fSelectedTarget), false);
        }
    }

    public IMakeTarget getSelectedTarget() {
        return this.fSelectedTarget;
    }

    protected void updateEnabledState() {
        super.updateEnabledState();
        this.setButtonEnabled(1, this.fSelectedTarget != null && this.isEnabled());
        this.setButtonEnabled(2, this.fSelectedTarget != null && this.isEnabled());
    }

    public void createControl(Composite parent, int style, int span) {
        super.createControl(parent, style, span);
        this.updateEnabledState();
        if (this.getViewer() != null && this.fSelectedTarget != null) {
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)this.fSelectedTarget));
        }
    }
}

