/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.cdt.utils.ui.controls.RadioButtonsArea;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class SettingsBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "SettingsBlock";
    private static final String MAKE_LABEL = "SettingsBlock.label";
    private static final String MAKE_MESSAGE = "SettingsBlock.message";
    private static final String MAKE_SETTING_GROUP = "SettingsBlock.makeSetting.group_label";
    private static final String MAKE_SETTING_KEEP_GOING = "SettingsBlock.makeSetting.keepOnGoing";
    private static final String MAKE_SETTING_STOP_ERROR = "SettingsBlock.makeSetting.stopOnError";
    private static final String MAKE_CMD_GROUP = "SettingsBlock.makeCmd.group_label";
    private static final String MAKE_CMD_USE_DEFAULT = "SettingsBlock.makeCmd.use_default";
    private static final String MAKE_CMD_LABEL = "SettingsBlock.makeCmd.label";
    private static final String MAKE_WORKBENCH_BUILD_GROUP = "SettingsBlock.makeWorkbench.group_label";
    private static final String MAKE_WORKBENCH_BUILD_TYPE = "SettingsBlock.makeWorkbench.type";
    private static final String MAKE_WORKBENCH_BUILD_TARGET = "SettingsBlock.makeWorkbench.target";
    private static final String MAKE_WORKBENCH_BUILD_AUTO = "SettingsBlock.makeWorkbench.auto";
    private static final String MAKE_WORKBENCH_BUILD_INCR = "SettingsBlock.makeWorkbench.incremental";
    private static final String MAKE_WORKBENCH_BUILD_FULL = "SettingsBlock.makeWorkbench.full";
    private static final String MAKE_BUILD_DIR_GROUP = "SettingsBlock.makeDir.group_label";
    private static final String MAKE_BUILD_DIR_LABEL = "SettingsBlock.makeDir.label";
    private static final String MAKE_BUILD_DIR_BROWSE = "SettingsBlock.makeDir.browse";
    private static final String KEEP_ARG = "keep";
    private static final String STOP_ARG = "stop";
    RadioButtonsArea stopRadioButtons;
    Button defButton;
    Text buildCommand;
    Text buildLocation;
    Text targetFull;
    Text targetIncr;
    Text targetAuto;
    Button fullButton;
    Button incrButton;
    Button autoButton;
    private IMakeBuilderInfo fBuildInfo;
    private Preferences fPrefs;
    private String fBuilderID;

    public SettingsBlock(Preferences prefs, String builderID) {
        super(MakeUIPlugin.getResourceString(MAKE_LABEL));
        this.setDescription(MakeUIPlugin.getResourceString(MAKE_MESSAGE));
        this.fPrefs = prefs;
        this.fBuilderID = builderID;
    }

    protected void createSettingControls(Composite parent) {
        String[][] radios = new String[][]{{MakeUIPlugin.getResourceString(MAKE_SETTING_STOP_ERROR), STOP_ARG}, {MakeUIPlugin.getResourceString(MAKE_SETTING_KEEP_GOING), KEEP_ARG}};
        this.stopRadioButtons = new RadioButtonsArea(parent, MakeUIPlugin.getResourceString(MAKE_SETTING_GROUP), 1, radios);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.stopRadioButtons.setLayout((Layout)layout);
        if (this.fBuildInfo.isStopOnError()) {
            this.stopRadioButtons.setSelectValue(STOP_ARG);
        } else {
            this.stopRadioButtons.setSelectValue(KEEP_ARG);
        }
    }

    protected void createBuildCmdControls(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_CMD_GROUP), (int)1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.defButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_USE_DEFAULT));
        this.defButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SettingsBlock.this.defButton.getSelection()) {
                    SettingsBlock.this.buildCommand.setEnabled(false);
                    SettingsBlock.this.stopRadioButtons.setEnabled(true);
                    SettingsBlock.this.getContainer().updateContainer();
                } else {
                    SettingsBlock.this.buildCommand.setEnabled(true);
                    SettingsBlock.this.stopRadioButtons.setEnabled(false);
                    SettingsBlock.this.getContainer().updateContainer();
                }
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.defButton.setLayoutData((Object)gd);
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.buildCommand = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.buildCommand.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.buildCommand.getLayoutData()).grabExcessHorizontalSpace = true;
        this.buildCommand.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                SettingsBlock.this.getContainer().updateContainer();
            }
        });
        if (this.fBuildInfo.getBuildCommand() != null) {
            String args;
            StringBuffer cmd = new StringBuffer(this.fBuildInfo.getBuildCommand().toOSString());
            if (!this.fBuildInfo.isDefaultBuildCmd() && (args = this.fBuildInfo.getBuildArguments()) != null && !args.equals("")) {
                cmd.append(" ");
                cmd.append(args);
            }
            this.buildCommand.setText(cmd.toString());
        }
        if (this.fBuildInfo.isDefaultBuildCmd()) {
            this.buildCommand.setEnabled(false);
        } else {
            this.stopRadioButtons.setEnabled(false);
        }
        this.defButton.setSelection(this.fBuildInfo.isDefaultBuildCmd());
    }

    protected void createWorkBenchBuildControls(Composite parent) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsBlock.this.targetAuto.setEnabled(SettingsBlock.this.autoButton.getSelection());
                SettingsBlock.this.targetFull.setEnabled(SettingsBlock.this.fullButton.getSelection());
                SettingsBlock.this.targetIncr.setEnabled(SettingsBlock.this.incrButton.getSelection());
                SettingsBlock.this.getContainer().updateContainer();
            }
        };
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_GROUP), (int)1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_TYPE));
        label = new Label((Composite)group, 0);
        label.setText(MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_TARGET));
        this.autoButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_AUTO));
        this.autoButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.autoButton.setSelection(this.fBuildInfo.isAutoBuildEnable());
        this.targetAuto = ControlFactory.createTextField((Composite)group, (int)2052);
        this.targetAuto.setText(this.fBuildInfo.getAutoBuildTarget());
        ((GridData)this.targetAuto.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetAuto.getLayoutData()).grabExcessHorizontalSpace = true;
        this.incrButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_INCR));
        this.incrButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.incrButton.setSelection(this.fBuildInfo.isIncrementalBuildEnabled());
        this.targetIncr = ControlFactory.createTextField((Composite)group, (int)2052);
        this.targetIncr.setText(this.fBuildInfo.getIncrementalBuildTarget());
        ((GridData)this.targetIncr.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetIncr.getLayoutData()).grabExcessHorizontalSpace = true;
        this.fullButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_FULL));
        this.fullButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.fullButton.setSelection(this.fBuildInfo.isFullBuildEnabled());
        this.targetFull = ControlFactory.createTextField((Composite)group, (int)2052);
        this.targetFull.setText(this.fBuildInfo.getFullBuildTarget());
        ((GridData)this.targetFull.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetFull.getLayoutData()).grabExcessHorizontalSpace = true;
        selectionAdapter.widgetSelected(null);
    }

    protected void createBuilderWorkingDirControls(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_BUILD_DIR_GROUP), (int)1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_BUILD_DIR_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.buildLocation = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.buildLocation.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.buildLocation.getLayoutData()).grabExcessHorizontalSpace = true;
        this.buildLocation.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                SettingsBlock.this.getContainer().updateContainer();
            }
        });
        Button browse = new Button((Composite)group, 0);
        browse.setText(MakeUIPlugin.getResourceString(MAKE_BUILD_DIR_BROWSE));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(SettingsBlock.this.getShell(), (IContainer)SettingsBlock.this.getContainer().getProject(), true, "Selection Locations to build from.");
                if (dialog.open() == 0 && (selection = dialog.getResult()).length > 0) {
                    SettingsBlock.this.buildLocation.setText(((IPath)selection[0]).toOSString());
                }
            }
        });
        this.buildLocation.setText(this.fBuildInfo.getBuildLocation().toOSString());
    }

    public void createControl(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)1);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMakeHelpContextIds.MAKE_BUILDER_SETTINGS);
        if (this.fBuildInfo == null) {
            ControlFactory.createEmptySpace((Composite)composite);
            ControlFactory.createLabel((Composite)composite, (String)"Missing builder information on project.");
            return;
        }
        this.createSettingControls(composite);
        this.createBuildCmdControls(composite);
        this.createWorkBenchBuildControls(composite);
        if (this.getContainer().getProject() != null) {
            this.createBuilderWorkingDirControls(composite);
        }
    }

    public boolean isValid() {
        String cmd;
        return this.defButton == null || this.defButton.getSelection() || (cmd = this.getBuildLine()) != null && cmd.length() != 0;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IWorkspace workspace = MakeUIPlugin.getWorkspace();
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Applying Settings...", 1);
                IMakeBuilderInfo info = SettingsBlock.this.getContainer().getProject() != null ? MakeCorePlugin.createBuildInfo((IProject)SettingsBlock.this.getContainer().getProject(), (String)SettingsBlock.this.fBuilderID) : MakeCorePlugin.createBuildInfo((Preferences)SettingsBlock.this.fPrefs, (String)SettingsBlock.this.fBuilderID, (boolean)false);
                info.setStopOnError(SettingsBlock.this.isStopOnError());
                info.setUseDefaultBuildCmd(SettingsBlock.this.useDefaultBuildCmd());
                if (!SettingsBlock.this.useDefaultBuildCmd()) {
                    String bldLine = SettingsBlock.this.getBuildLine();
                    int start = 0;
                    int end = -1;
                    if (!bldLine.startsWith("\"")) {
                        end = bldLine.indexOf(32);
                    } else {
                        start = 1;
                        end = bldLine.indexOf(34, 1);
                    }
                    Path path = end == -1 ? new Path(bldLine) : new Path(bldLine.substring(start, end));
                    info.setBuildCommand((IPath)path);
                    String args = "";
                    if (end != -1) {
                        args = bldLine.substring(end + 1);
                    }
                    info.setBuildArguments(args);
                }
                info.setAutoBuildEnable(SettingsBlock.this.autoButton.getSelection());
                info.setAutoBuildTarget(SettingsBlock.this.targetAuto.getText().trim());
                info.setIncrementalBuildEnable(SettingsBlock.this.incrButton.getSelection());
                info.setIncrementalBuildTarget(SettingsBlock.this.targetIncr.getText().trim());
                info.setFullBuildEnable(SettingsBlock.this.fullButton.getSelection());
                info.setFullBuildTarget(SettingsBlock.this.targetFull.getText().trim());
                if (SettingsBlock.this.buildLocation != null) {
                    info.setBuildLocation((IPath)new Path(SettingsBlock.this.buildLocation.getText().trim()));
                }
            }
        };
        workspace.run(operation, monitor);
    }

    public void performDefaults() {
        IMakeBuilderInfo info = this.getContainer().getProject() != null ? MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)false) : MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)true);
        if (info.isStopOnError()) {
            this.stopRadioButtons.setSelectValue(STOP_ARG);
        } else {
            this.stopRadioButtons.setSelectValue(KEEP_ARG);
        }
        if (info.getBuildCommand() != null) {
            String args;
            StringBuffer cmd = new StringBuffer(info.getBuildCommand().toOSString());
            if (!info.isDefaultBuildCmd() && (args = info.getBuildArguments()) != null && !args.equals("")) {
                cmd.append(" ");
                cmd.append(args);
            }
            this.buildCommand.setText(cmd.toString());
        }
        if (info.isDefaultBuildCmd()) {
            this.buildCommand.setEnabled(false);
        } else {
            this.stopRadioButtons.setEnabled(false);
        }
        this.defButton.setSelection(info.isDefaultBuildCmd());
        this.autoButton.setSelection(info.isAutoBuildEnable());
        this.targetAuto.setText(info.getAutoBuildTarget());
        this.incrButton.setSelection(info.isIncrementalBuildEnabled());
        this.targetIncr.setText(info.getIncrementalBuildTarget());
        this.fullButton.setSelection(info.isFullBuildEnabled());
        this.targetFull.setText(info.getFullBuildTarget());
    }

    private boolean isStopOnError() {
        return this.stopRadioButtons.getSelectedValue().equals(STOP_ARG);
    }

    private boolean useDefaultBuildCmd() {
        return this.defButton.getSelection();
    }

    private String getBuildLine() {
        String cmd;
        if (this.buildCommand != null && (cmd = this.buildCommand.getText()) != null) {
            return cmd.trim();
        }
        return null;
    }

    public void setContainer(ICOptionContainer container) {
        super.setContainer(container);
        if (this.getContainer().getProject() != null) {
            try {
                this.fBuildInfo = MakeCorePlugin.createBuildInfo((IProject)this.getContainer().getProject(), (String)this.fBuilderID);
            }
            catch (CoreException coreException) {}
        } else {
            this.fBuildInfo = MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)false);
        }
    }

    public String getErrorMessage() {
        String cmd;
        if (!(this.useDefaultBuildCmd() || (cmd = this.getBuildLine()) != null && cmd.length() != 0)) {
            return "Must enter a build command";
        }
        return null;
    }
}

