/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class DeleteTargetAction
extends SelectionListenerAction {
    Shell shell;
    IResource resource;

    public DeleteTargetAction(Shell shell) {
        super("Delete Build Target");
        this.shell = shell;
        this.setToolTipText("Delete Build Target");
        MakeUIImages.setImageDescriptors((IAction)this, "tool16", MakeUIImages.IMG_TOOLS_MAKE_TARGET_DELETE);
    }

    boolean confirmDelete() {
        String msg;
        String title;
        List targets = this.getTargetsToDelete();
        if (targets.size() == 1) {
            title = "Confirm Target Deletion";
            IMakeTarget target = (IMakeTarget)targets.get(0);
            msg = MessageFormat.format("Are you sure you want to delete  ''{0}''?", target.getName());
        } else {
            title = "Confirm Multiple Target Deletion";
            msg = MessageFormat.format("Are you sure you want to delete these {0} targets?", new Integer(targets.size()));
        }
        return MessageDialog.openQuestion((Shell)this.shell, (String)title, (String)msg);
    }

    public void run() {
        if (this.canDelete() && !this.confirmDelete()) {
            return;
        }
        List targets = this.getTargetsToDelete();
        IMakeTargetManager manager = MakeCorePlugin.getDefault().getTargetManager();
        Iterator iter = targets.iterator();
        try {
            while (iter.hasNext()) {
                manager.removeTarget((IMakeTarget)iter.next());
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.errorDialog(this.shell, "Target Remove Error", "Error deleting build target", e);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.canDelete();
    }

    private List getTargetsToDelete() {
        return this.getStructuredSelection().toList();
    }

    private boolean canDelete() {
        List elements = this.getStructuredSelection().toList();
        if (elements.size() > 0) {
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof IMakeTarget) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

