/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.parser.Enum;
import org.eclipse.cdt.core.parser.ParserMode;

public class ScannerException
extends Exception {
    private final String info;
    private final String fileName;
    private final int offset;
    private static final int OFFSET_NOT_PROVIDED = -1;
    private final ErrorCode code;
    static Map errorMessages = new HashMap();

    static {
        errorMessages.put(ErrorCode.POUND_ERROR, "#error ");
        errorMessages.put(ErrorCode.INCLUSION_NOT_FOUND, "Inclusion not found: ");
        errorMessages.put(ErrorCode.DEFINITION_NOT_FOUND, "Definition not found: ");
        errorMessages.put(ErrorCode.MALFORMED_MACRO_DEFN, "Macro definition malformed: ");
        errorMessages.put(ErrorCode.ATTEMPTED_REDEFINITION, "");
        errorMessages.put(ErrorCode.INVALID_ESCAPE_CHARACTER_SEQUENCE, "");
        errorMessages.put(ErrorCode.EXPRESSION_EVALUATION_ERROR, "");
        errorMessages.put(ErrorCode.MACRO_USAGE_ERROR, "");
        errorMessages.put(ErrorCode.CIRCULAR_INCLUSION, "");
        errorMessages.put(ErrorCode.UNBALANCED_CONDITIONALS, "Conditionals unbalanced ");
        errorMessages.put(ErrorCode.UNBOUNDED_STRING, "Unbounded string ");
        errorMessages.put(ErrorCode.BAD_FLOATING_POINT, "Invalid floating point format ");
        errorMessages.put(ErrorCode.BAD_HEXIDECIMAL_FORMAT, "Invalid hexidecimal format ");
        errorMessages.put(ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, "Invalid preprocessor directive format ");
        errorMessages.put(ErrorCode.UNEXPECTED_EOF, "Unexpected End Of File ");
        errorMessages.put(ErrorCode.MACRO_PASTING_ERROR, "Invalid use of macro pasting ");
    }

    public ScannerException(ErrorCode code) {
        this(code, "", "UNKNOWN", -1);
    }

    public ScannerException(ErrorCode code, String info) {
        this(code, info, "UNKNOWN", -1);
    }

    public ScannerException(ErrorCode code, String fileName, int offset) {
        this(code, "", fileName, offset);
    }

    public ScannerException(ErrorCode code, String info, String fileName, int offset) {
        this.code = code;
        this.info = info;
        this.fileName = fileName;
        this.offset = offset;
    }

    public ErrorCode getErrorCode() {
        return this.code;
    }

    public String getMessage() {
        StringBuffer buff = new StringBuffer();
        String errorMessage = (String)errorMessages.get(this.getErrorCode());
        if (errorMessage == null) {
            return "";
        }
        buff.append(errorMessage);
        if (this.getErrorCode().hasInfo()) {
            buff.append(this.info);
        }
        if (this.getErrorCode().hasOffsetInfo()) {
            buff.append("from file: ");
            buff.append(this.fileName);
            buff.append(" offset @ ");
            buff.append(this.offset);
        }
        return buff.toString();
    }

    public boolean isSeriousError(ParserMode mode) {
        return this.getErrorCode().isSeriousError(mode);
    }

    public static class ErrorCode
    extends Enum {
        public static final ErrorCode POUND_ERROR = new ErrorCode(0);
        public static final ErrorCode INCLUSION_NOT_FOUND = new ErrorCode(1);
        public static final ErrorCode DEFINITION_NOT_FOUND = new ErrorCode(2);
        public static final ErrorCode UNBALANCED_CONDITIONALS = new ErrorCode(3);
        public static final ErrorCode MALFORMED_MACRO_DEFN = new ErrorCode(4);
        public static final ErrorCode UNBOUNDED_STRING = new ErrorCode(5);
        public static final ErrorCode BAD_FLOATING_POINT = new ErrorCode(6);
        public static final ErrorCode BAD_HEXIDECIMAL_FORMAT = new ErrorCode(7);
        public static final ErrorCode INVALID_PREPROCESSOR_DIRECTIVE = new ErrorCode(8);
        public static final ErrorCode ATTEMPTED_REDEFINITION = new ErrorCode(9);
        public static final ErrorCode INVALID_ESCAPE_CHARACTER_SEQUENCE = new ErrorCode(11);
        public static final ErrorCode EXPRESSION_EVALUATION_ERROR = new ErrorCode(12);
        public static final ErrorCode UNEXPECTED_EOF = new ErrorCode(13);
        public static final ErrorCode MACRO_USAGE_ERROR = new ErrorCode(14);
        public static final ErrorCode MACRO_PASTING_ERROR = new ErrorCode(15);
        public static final ErrorCode CIRCULAR_INCLUSION = new ErrorCode(16);

        protected ErrorCode(int enumValue) {
            super(enumValue);
        }

        public boolean hasInfo() {
            return this != UNBALANCED_CONDITIONALS && this != UNBOUNDED_STRING && this != BAD_FLOATING_POINT && this != BAD_HEXIDECIMAL_FORMAT && this != INVALID_PREPROCESSOR_DIRECTIVE && this != UNEXPECTED_EOF && this != MACRO_PASTING_ERROR;
        }

        public boolean hasOffsetInfo() {
            return this != INCLUSION_NOT_FOUND && this != POUND_ERROR;
        }

        public boolean isSeriousError(ParserMode mode) {
            return mode == ParserMode.COMPLETE_PARSE && (this == POUND_ERROR || this == DEFINITION_NOT_FOUND || this == UNBALANCED_CONDITIONALS || this == MALFORMED_MACRO_DEFN || this == UNEXPECTED_EOF || this == MACRO_USAGE_ERROR || this == MACRO_PASTING_ERROR || this == EXPRESSION_EVALUATION_ERROR || this == INVALID_PREPROCESSOR_DIRECTIVE || this == ATTEMPTED_REDEFINITION);
        }
    }
}

