/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.resources.MakeUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CBuilder
extends ACBuilder {
    private static final String BUILD_ERROR = "CBuilder.build_error";

    public IPath getWorkingDirectory() {
        IProject currProject = this.getProject();
        Path workingDirectory = new Path(MakeUtil.getSessionBuildDir((IResource)currProject));
        if (workingDirectory.isEmpty()) {
            workingDirectory = currProject.getLocation();
        }
        return workingDirectory;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        boolean isClean;
        boolean bPerformBuild = true;
        if (kind == 9) {
            MyResourceDeltaVisitor vis = new MyResourceDeltaVisitor();
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)vis);
                bPerformBuild = vis.shouldBuild();
            } else {
                bPerformBuild = false;
            }
        }
        if (bPerformBuild && (isClean = this.invokeMake(kind == 6, monitor))) {
            this.forgetLastBuiltState();
        }
        this.checkCancel(monitor);
        return this.getProject().getReferencedProjects();
    }

    private boolean invokeMake(boolean fullBuild, IProgressMonitor monitor) {
        boolean isClean;
        block14: {
            isClean = false;
            IProject currProject = this.getProject();
            SubProgressMonitor subMonitor = null;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Invoking the C Builder: " + currProject.getName(), -1);
            try {
                CProjectNature nature = (CProjectNature)currProject.getNature("org.eclipse.cdt.core.cnature");
                IPath makepath = nature.getBuildCommand();
                if (makepath.isEmpty()) break block14;
                IConsole console = CCorePlugin.getDefault().getConsole();
                console.start(currProject);
                ConsoleOutputStream cos = console.getOutputStream();
                this.removeAllMarkers(currProject);
                IPath workingDirectory = this.getWorkingDirectory();
                String[] userArgs = this.parseArguments(fullBuild, nature.getIncrBuildArguments());
                if (userArgs.length != 0 && userArgs[userArgs.length - 1].equals("clean")) {
                    isClean = true;
                }
                subMonitor = new SubProgressMonitor(monitor, -1);
                subMonitor.subTask("Invoking Command: " + makepath.toString());
                String errMsg = null;
                CommandLauncher launcher = new CommandLauncher();
                launcher.showCommand(true);
                Properties props = launcher.getEnvironment();
                ((Hashtable)props).put("CWD", workingDirectory.toOSString());
                ((Hashtable)props).put("PWD", workingDirectory.toOSString());
                String[] env = null;
                ArrayList<String> envList = new ArrayList<String>();
                Enumeration<?> names = props.propertyNames();
                if (names != null) {
                    while (names.hasMoreElements()) {
                        String key = (String)names.nextElement();
                        envList.add(String.valueOf(key) + "=" + props.getProperty(key));
                    }
                    env = envList.toArray(new String[envList.size()]);
                }
                ErrorParserManager epm = new ErrorParserManager(this);
                epm.setOutputStream(cos);
                OutputStream stdout = epm.getOutputStream();
                OutputStream stderr = epm.getOutputStream();
                Process p = launcher.execute(makepath, userArgs, env, workingDirectory);
                if (p != null) {
                    try {
                        p.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    if (launcher.waitAndRead(stdout, stderr, (IProgressMonitor)subMonitor) != 0) {
                        errMsg = launcher.getErrorMessage();
                    }
                    subMonitor.setTaskName("Refresh From Local");
                    try {
                        currProject.refreshLocal(2, null);
                    }
                    catch (CoreException coreException) {}
                    subMonitor = new SubProgressMonitor(monitor, -1);
                    subMonitor.subTask("Parsing");
                } else {
                    errMsg = launcher.getErrorMessage();
                }
                if (errMsg != null) {
                    String errorDesc = CCorePlugin.getFormattedString(BUILD_ERROR, makepath.toString());
                    StringBuffer buf = new StringBuffer(errorDesc);
                    buf.append(System.getProperty("line.separator", "\n"));
                    buf.append("(").append(errMsg).append(")");
                    cos.write(buf.toString().getBytes());
                    cos.flush();
                }
                stdout.close();
                stderr.close();
                epm.reportProblems();
                subMonitor.done();
            }
            catch (Exception e) {
                CCorePlugin.log(e);
            }
        }
        monitor.done();
        return isClean;
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private String[] parseArguments(boolean fullBuild, String override_args) {
        ArrayList<String> list = new ArrayList<String>();
        IProject currProject = this.getProject();
        try {
            CProjectNature nature = (CProjectNature)currProject.getNature("org.eclipse.cdt.core.cnature");
            if (nature.isDefaultBuildCmd()) {
                if (!nature.isStopOnError()) {
                    list.add("-k");
                }
            } else {
                String[] ovrd_args = this.makeArray(nature.getFullBuildArguments());
                list.addAll(Arrays.asList(ovrd_args));
            }
        }
        catch (CoreException coreException) {}
        String sessionTarget = MakeUtil.getSessionTarget((IResource)currProject);
        String[] targets = this.makeArray(sessionTarget);
        int i = 0;
        while (i < targets.length) {
            list.add(targets[i]);
            ++i;
        }
        if (fullBuild && targets.length == 0) {
            list.add("clean");
            list.add("all");
        }
        return list.toArray(new String[list.size()]);
    }

    String[] makeArray(String string) {
        string.trim();
        char[] array = string.toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean inComment = false;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (array[i] == '\"' || array[i] == '\'') {
                if (i > 0 && array[i - 1] == '\\') {
                    inComment = false;
                } else {
                    boolean bl = inComment = !inComment;
                }
            }
            if (c == ' ' && !inComment) {
                aList.add(buffer.toString());
                buffer = new StringBuffer();
            } else {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            aList.add(buffer.toString());
        }
        return aList.toArray(new String[aList.size()]);
    }

    private void removeAllMarkers(IProject currProject) throws CoreException {
        IWorkspace workspace = currProject.getWorkspace();
        IMarker[] markers = currProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers != null) {
            workspace.deleteMarkers(markers);
        }
    }

    public class MyResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        boolean bContinue;

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource != null && resource.getProject() == CBuilder.this.getProject()) {
                this.bContinue = true;
                return false;
            }
            return true;
        }

        public boolean shouldBuild() {
            return this.bContinue;
        }
    }
}

