/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class CDTLogWriter {
    protected File logFile = null;
    protected Writer log = null;
    protected boolean newSession = true;
    protected static final String SESSION = "*** SESSION";
    protected static final String ENTRY = "ENTRY";
    protected static final String SUBENTRY = "SUBENTRY";
    protected static final String MESSAGE = "MESSAGE";
    protected static final String STACK = "STACK";
    protected static final String LINE_SEPARATOR;
    protected static final String TAB_STRING = "\t";
    protected static final long MAXLOG_SIZE = 10000000L;

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
    }

    public CDTLogWriter(File log) {
        this.logFile = log;
        if (log.length() > 10000000L) {
            log.delete();
            this.logFile = CCorePlugin.getDefault().getStateLocation().append(".log").toFile();
        }
        this.openLogFile();
    }

    protected void closeLogFile() throws IOException {
        try {
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.log = null;
            throw throwable;
        }
        Object var1_3 = null;
        this.log = null;
    }

    protected void openLogFile() {
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), "UTF-8"));
            if (this.newSession) {
                this.writeHeader();
                this.newSession = false;
            }
        }
        catch (IOException iOException) {}
    }

    protected void writeHeader() throws IOException {
        this.write(SESSION);
        this.writeSpace();
        String date = this.getDate();
        this.write(date);
        this.writeSpace();
        int i = SESSION.length() + date.length();
        while (i < 78) {
            this.write("-");
            ++i;
        }
        this.writeln();
    }

    protected String getDate() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SS");
            return formatter.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    protected Writer logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    protected void writeln(String s) throws IOException {
        this.write(s);
        this.writeln();
    }

    public synchronized void shutdown() {
        try {
            if (this.logFile != null) {
                this.closeLogFile();
                this.logFile = null;
            } else if (this.log != null) {
                Writer old = this.log;
                this.log = null;
                old.flush();
                old.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void write(Throwable throwable) throws IOException {
        if (throwable == null) {
            return;
        }
        this.write(STACK);
        this.writeSpace();
        boolean isCoreException = throwable instanceof CoreException;
        if (isCoreException) {
            this.writeln("1");
        } else {
            this.writeln("0");
        }
        throwable.printStackTrace(new PrintWriter(this.log));
        if (isCoreException) {
            CoreException e = (CoreException)throwable;
            this.write(e.getStatus(), 0);
        }
    }

    public synchronized void log(IStatus status) {
        try {
            this.write(status, 0);
        }
        catch (IOException iOException) {}
    }

    protected void write(IStatus status, int depth) throws IOException {
        if (depth == 0) {
            this.write(ENTRY);
        } else {
            this.write(SUBENTRY);
            this.writeSpace();
            this.write(Integer.toString(depth));
        }
        this.writeSpace();
        this.write(status.getPlugin());
        this.writeSpace();
        this.write(Integer.toString(status.getSeverity()));
        this.writeSpace();
        this.write(Integer.toString(status.getCode()));
        this.writeSpace();
        this.write(this.getDate());
        this.writeln();
        this.write(MESSAGE);
        this.writeSpace();
        this.writeln(status.getMessage());
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.write(children[i], depth + 1);
                ++i;
            }
        }
    }

    protected void writeln() throws IOException {
        this.write(LINE_SEPARATOR);
    }

    protected void write(String message) throws IOException {
        if (message != null) {
            this.log.write(message);
        }
    }

    protected void writeSpace() throws IOException {
        this.write(" ");
    }

    public synchronized void flushLog() {
        try {
            this.log.flush();
        }
        catch (IOException iOException) {}
    }
}

