/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.internal.core.model.parser.Symbol;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.coff.PEArchive;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public class PEBinaryFile
extends PlatformObject
implements IBinaryParser.IBinaryFile,
IBinaryParser.IBinaryObject,
IBinaryParser.IBinaryExecutable,
IBinaryParser.IBinaryShared {
    IPath path;
    long timestamp;
    PE.Attribute attribute;
    String objectName;
    ArrayList symbols;

    public PEBinaryFile(IPath p) throws IOException {
        this(p, null);
    }

    public PEBinaryFile(IPath p, String o) throws IOException {
        this.path = p;
        this.objectName = o;
        this.loadInformation();
        this.hasChanged();
    }

    public InputStream getContents() {
        InputStream stream = null;
        if (this.path != null && this.objectName != null) {
            PEArchive ar = null;
            try {
                try {
                    ar = new PEArchive(this.path.toOSString());
                    PEArchive.ARHeader[] headers = ar.getHeaders();
                    int i = 0;
                    while (i < headers.length) {
                        PEArchive.ARHeader hdr = headers[i];
                        if (this.objectName.equals(hdr.getObjectName())) {
                            stream = new ByteArrayInputStream(hdr.getObjectData());
                            break;
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (ar != null) {
                    ar.dispose();
                }
                throw throwable;
            }
            Object var6_8 = null;
            if (ar != null) {
                ar.dispose();
            }
        } else if (this.path != null) {
            try {
                stream = new FileInputStream(this.path.toFile());
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = new ByteArrayInputStream(new byte[0]);
        }
        return stream;
    }

    public IPath getPath() {
        return this.path;
    }

    public int getType() {
        int type = 0;
        PE.Attribute attr = this.getAttribute();
        if (attr != null) {
            switch (this.attribute.getType()) {
                case 1: {
                    type = 2;
                    break;
                }
                case 2: {
                    type = 4;
                    break;
                }
                case 3: {
                    type = 1;
                    break;
                }
                case 4: {
                    type = 16;
                }
            }
        }
        return type;
    }

    public long getBSS() {
        return 0L;
    }

    public String getCPU() {
        PE.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.getCPU();
        }
        return "";
    }

    public long getData() {
        return 0L;
    }

    public String getName() {
        if (this.objectName != null) {
            return this.objectName;
        }
        if (this.path != null) {
            return this.path.lastSegment().toString();
        }
        return "";
    }

    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            if (this.symbols == null) {
                this.symbols = new ArrayList(5);
            }
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
        }
        return this.symbols.toArray(new IBinaryParser.ISymbol[0]);
    }

    public long getText() {
        return 0L;
    }

    public boolean hasDebug() {
        PE.Attribute attr = this.getAttribute();
        if (attr != null) {
            return attr.hasDebug();
        }
        return false;
    }

    public boolean isLittleEndian() {
        PE.Attribute attr = this.getAttribute();
        if (attr != null) {
            return attr.isLittleEndian();
        }
        return false;
    }

    public String[] getNeededSharedLibs() {
        return new String[0];
    }

    public String getSoName() {
        return "";
    }

    protected PE getPE() throws IOException {
        if (this.path != null && this.objectName != null) {
            PE pe = null;
            PEArchive ar = null;
            try {
                ar = new PEArchive(this.path.toOSString());
                PEArchive.ARHeader[] headers = ar.getHeaders();
                int i = 0;
                while (i < headers.length) {
                    PEArchive.ARHeader hdr = headers[i];
                    if (this.objectName.equals(hdr.getObjectName())) {
                        pe = hdr.getPE();
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (ar != null) {
                    ar.dispose();
                }
                throw throwable;
            }
            Object var6_8 = null;
            if (ar != null) {
                ar.dispose();
            }
            if (pe != null) {
                return pe;
            }
        } else if (this.path != null) {
            return new PE(this.path.toOSString());
        }
        throw new IOException("No file assiocated with Binary");
    }

    protected PE.Attribute getAttribute() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
        }
        return this.attribute;
    }

    protected void loadInformation() throws IOException {
        PE pe = this.getPE();
        this.loadInformation(pe);
        pe.dispose();
    }

    private void loadInformation(PE pe) throws IOException {
        this.loadAttribute(pe);
        if (this.symbols != null) {
            this.symbols.clear();
            this.loadSymbols(pe);
            this.symbols.trimToSize();
        }
    }

    private void loadAttribute(PE pe) throws IOException {
        this.attribute = pe.getAttribute();
    }

    private void loadSymbols(PE pe) throws IOException {
        Coff.Symbol[] peSyms = pe.getSymbols();
        byte[] table = pe.getStringTable();
        int i = 0;
        while (i < peSyms.length) {
            String name;
            if ((peSyms[i].isFunction() || peSyms[i].isPointer() || peSyms[i].isArray()) && (name = peSyms[i].getName(table)) != null && name.trim().length() != 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
                Symbol sym = new Symbol();
                sym.filename = null;
                sym.name = name;
                sym.addr = peSyms[i].n_value;
                sym.startLine = 0;
                sym.endLine = 0;
                sym.type = peSyms[i].isFunction() ? 1 : 2;
                this.symbols.add(sym);
            }
            ++i;
        }
    }

    boolean hasChanged() {
        File file = this.path.toFile();
        if (file != null && file.exists()) {
            long modification = file.lastModified();
            boolean changed = modification != this.timestamp;
            this.timestamp = modification;
            return changed;
        }
        return false;
    }
}

