/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.internal.core.parser.NullSourceElementRequestor;

public class QuickParseCallback
extends NullSourceElementRequestor
implements IQuickParseCallback {
    protected IASTCompilationUnit compilationUnit = null;
    protected List inclusions = new ArrayList();
    protected List macros = new ArrayList();

    public Iterator getInclusions() {
        return this.inclusions.iterator();
    }

    public Iterator getMacros() {
        return this.macros.iterator();
    }

    public void exitMethodBody(IASTMethod method) {
        method.setHasFunctionBody(true);
    }

    public void exitFunctionBody(IASTFunction function) {
        function.setHasFunctionBody(true);
    }

    public void exitCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public void exitInclusion(IASTInclusion inclusion) {
        this.inclusions.add(inclusion);
    }

    public void acceptMacro(IASTMacro macro) {
        this.macros.add(macro);
    }

    public IASTCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public Iterator iterateOffsetableElements() {
        return new OffsetableIterator();
    }

    public class OffsetableIterator
    implements Iterator {
        private Iterator declarationIter;
        private final Iterator inclusionIter;
        private final Iterator macroIter;
        private IASTOffsetableElement currentMacro = null;
        private IASTOffsetableElement currentInclusion = null;
        private IASTOffsetableElement currentDeclaration = null;

        public OffsetableIterator() {
            try {
                this.declarationIter = QuickParseCallback.this.compilationUnit.getDeclarations();
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
            this.inclusionIter = QuickParseCallback.this.inclusions.iterator();
            this.macroIter = QuickParseCallback.this.macros.iterator();
            this.updateInclusionIterator();
            this.updateDeclarationIterator();
            this.updateMacroIterator();
        }

        private Object updateDeclarationIterator() {
            IASTOffsetableElement offsetable = this.currentDeclaration;
            this.currentDeclaration = this.declarationIter.hasNext() ? (IASTOffsetableElement)this.declarationIter.next() : null;
            return offsetable;
        }

        private Object updateMacroIterator() {
            IASTOffsetableElement offsetable = this.currentMacro;
            this.currentMacro = this.macroIter.hasNext() ? (IASTOffsetableElement)this.macroIter.next() : null;
            return offsetable;
        }

        private Object updateInclusionIterator() {
            IASTOffsetableElement offsetable = this.currentInclusion;
            this.currentInclusion = this.inclusionIter.hasNext() ? (IASTOffsetableElement)this.inclusionIter.next() : null;
            return offsetable;
        }

        public boolean hasNext() {
            return this.currentMacro != null || this.currentInclusion != null || this.currentDeclaration != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.currentMacro == null && this.currentInclusion == null) {
                return this.updateDeclarationIterator();
            }
            if (this.currentDeclaration == null && this.currentInclusion == null) {
                return this.updateMacroIterator();
            }
            if (this.currentMacro == null && this.currentDeclaration == null) {
                return this.updateInclusionIterator();
            }
            if (this.currentMacro == null) {
                if (this.currentDeclaration.getStartingOffset() < this.currentInclusion.getStartingOffset()) {
                    return this.updateDeclarationIterator();
                }
                return this.updateInclusionIterator();
            }
            if (this.currentInclusion == null) {
                if (this.currentDeclaration.getStartingOffset() < this.currentMacro.getStartingOffset()) {
                    return this.updateDeclarationIterator();
                }
                return this.updateMacroIterator();
            }
            if (this.currentDeclaration == null) {
                if (this.currentInclusion.getStartingOffset() < this.currentMacro.getStartingOffset()) {
                    return this.updateInclusionIterator();
                }
                return this.updateMacroIterator();
            }
            if (this.currentInclusion.getStartingOffset() < this.currentMacro.getStartingOffset() && this.currentInclusion.getStartingOffset() < this.currentDeclaration.getStartingOffset()) {
                return this.updateInclusionIterator();
            }
            if (this.currentMacro.getStartingOffset() < this.currentInclusion.getStartingOffset() && this.currentMacro.getStartingOffset() < this.currentDeclaration.getStartingOffset()) {
                return this.updateMacroIterator();
            }
            return this.updateDeclarationIterator();
        }

        public void remove() {
            throw new UnsupportedOperationException("OffsetableIterator is a const iterator");
        }
    }
}

