/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;

public class ASTElaboratedTypeSpecifier
implements IASTElaboratedTypeSpecifier {
    private NamedOffsets offsets = new NamedOffsets();
    private final String typeName;
    private final ASTClassKind classKind;
    private final ASTQualifiedNamedElement qualifiedName;

    public ASTElaboratedTypeSpecifier(IASTScope scope, ASTClassKind elaboratedClassKind, String typeName, int startingOffset, int nameOffset, int nameEndOffset, int endOffset) {
        this.classKind = elaboratedClassKind;
        this.typeName = typeName;
        this.setStartingOffset(startingOffset);
        this.setNameOffset(nameOffset);
        this.setNameEndOffset(nameEndOffset);
        this.setEndingOffset(endOffset);
        this.qualifiedName = new ASTQualifiedNamedElement(scope, typeName);
    }

    public String getName() {
        return this.typeName;
    }

    public ASTClassKind getClassKind() {
        return this.classKind;
    }

    public void setStartingOffset(int o) {
        this.offsets.setStartingOffset(o);
    }

    public void setEndingOffset(int o) {
        this.offsets.setEndingOffset(o);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public boolean isResolved() throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptElaboratedForewardDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffset(int o) {
        this.offsets.setNameEndOffset(o);
    }
}

