/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AddFileToIndex
extends IndexRequest {
    IFile resource;

    public AddFileToIndex(IFile resource, IPath indexPath, IndexManager manager) {
        super(indexPath, manager);
        this.resource = resource;
    }

    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        IIndex index = this.manager.getIndex(this.indexPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterWrite();
                if (!this.indexDocument(index)) {
                    Object var5_4 = null;
                    monitor.exitWrite();
                    return false;
                }
            }
            catch (IOException e) {
                Util.log(null, "Index I/O Exception: " + e.getMessage() + " on File: " + this.resource.getName(), ICLogConstants.CDT);
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to index " + this.resource + " because of the following exception:");
                    e.printStackTrace();
                }
                Object var5_5 = null;
                monitor.exitWrite();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.exitWrite();
            throw throwable;
        }
        Object var5_7 = null;
        monitor.exitWrite();
        return true;
    }

    protected abstract boolean indexDocument(IIndex var1) throws IOException;

    public String toString() {
        return "indexing " + this.resource.getFullPath();
    }
}

