/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.CharArrayReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.parser.ScannerInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public class MatchLocator
implements ISourceElementRequestor,
ICSearchConstants {
    public static boolean VERBOSE = false;
    private boolean shouldExcludeLocalDeclarations = false;
    private ISourceElementCallbackDelegate lastDeclaration;
    private ICSearchPattern searchPattern;
    private ICSearchResultCollector resultCollector;
    private IProgressMonitor progressMonitor;
    private IPath currentPath = null;
    private ICSearchScope searchScope;
    private IWorkspaceRoot workspaceRoot;
    private IResource currentResource = null;
    private LinkedList resourceStack = new LinkedList();
    private IASTScope currentScope = null;
    private LinkedList scopeStack = new LinkedList();

    public MatchLocator(ICSearchPattern pattern, ICSearchResultCollector collector, ICSearchScope scope, IProgressMonitor monitor) {
        this.searchPattern = pattern;
        this.resultCollector = collector;
        this.searchScope = scope;
        this.progressMonitor = monitor;
    }

    public void acceptProblem(IProblem problem) {
    }

    public void acceptUsingDirective(IASTUsingDirective usageDirective) {
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration usageDeclaration) {
    }

    public void acceptASMDefinition(IASTASMDefinition asmDefinition) {
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration abstractDeclaration) {
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void enterCodeBlock(IASTCodeScope scope) {
    }

    public void exitCodeBlock(IASTCodeScope scope) {
    }

    public void enterLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.pushScope(linkageSpec);
    }

    public void exitLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.popScope();
    }

    public void acceptParameterReference(IASTParameterReference reference) {
        this.check(ICSearchConstants.REFERENCES, reference);
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration typedef) {
        this.lastDeclaration = typedef;
        this.check(ICSearchConstants.DECLARATIONS, typedef);
    }

    public void acceptTypedefReference(IASTTypedefReference reference) {
        this.check(ICSearchConstants.REFERENCES, reference);
    }

    public void acceptEnumeratorReference(IASTEnumeratorReference reference) {
        this.check(ICSearchConstants.REFERENCES, reference);
    }

    public void acceptMacro(IASTMacro macro) {
        this.check(ICSearchConstants.DECLARATIONS, macro);
    }

    public void acceptVariable(IASTVariable variable) {
        this.lastDeclaration = variable;
        this.check(ICSearchConstants.DECLARATIONS, variable);
        if (variable.getInitializerClause() != null || !variable.isExtern() && !(this.currentScope instanceof IASTLinkageSpecification)) {
            this.check(ICSearchConstants.DEFINITIONS, variable);
        }
    }

    public void acceptField(IASTField field) {
        this.lastDeclaration = field;
        if (this.currentScope instanceof IASTClassSpecifier) {
            this.check(ICSearchConstants.DECLARATIONS, field);
            if (!field.isStatic()) {
                this.check(ICSearchConstants.DEFINITIONS, field);
            }
        } else {
            this.check(ICSearchConstants.DEFINITIONS, field);
        }
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier enumeration) {
        this.lastDeclaration = enumeration;
        this.check(ICSearchConstants.DECLARATIONS, enumeration);
        Iterator iter = enumeration.getEnumerators();
        while (iter.hasNext()) {
            IASTEnumerator enumerator = (IASTEnumerator)iter.next();
            this.lastDeclaration = enumerator;
            this.check(ICSearchConstants.DECLARATIONS, enumerator);
            this.check(ICSearchConstants.DEFINITIONS, enumerator);
        }
    }

    public void acceptFunctionDeclaration(IASTFunction function) {
        this.lastDeclaration = function;
        this.check(ICSearchConstants.DECLARATIONS, function);
    }

    public void acceptMethodDeclaration(IASTMethod method) {
        this.lastDeclaration = method;
        this.check(ICSearchConstants.DECLARATIONS, method);
    }

    public void acceptClassReference(IASTClassReference reference) {
        this.check(ICSearchConstants.REFERENCES, reference);
    }

    public void acceptNamespaceReference(IASTNamespaceReference reference) {
        this.check(ICSearchConstants.REFERENCES, reference);
    }

    public void acceptVariableReference(IASTVariableReference reference) {
        this.check(ICSearchConstants.REFERENCES, reference);
    }

    public void acceptFieldReference(IASTFieldReference reference) {
        this.check(ICSearchConstants.REFERENCES, reference);
    }

    public void acceptEnumerationReference(IASTEnumerationReference reference) {
        this.check(ICSearchConstants.REFERENCES, reference);
    }

    public void acceptFunctionReference(IASTFunctionReference reference) {
        this.check(ICSearchConstants.REFERENCES, reference);
    }

    public void acceptMethodReference(IASTMethodReference reference) {
        this.check(ICSearchConstants.REFERENCES, reference);
    }

    public void enterFunctionBody(IASTFunction function) {
        this.lastDeclaration = function;
        if (!function.previouslyDeclared()) {
            this.check(ICSearchConstants.DECLARATIONS, function);
        }
        this.check(ICSearchConstants.DEFINITIONS, function);
        this.pushScope(function);
    }

    public void enterMethodBody(IASTMethod method) {
        this.lastDeclaration = method;
        if (!method.previouslyDeclared()) {
            this.check(ICSearchConstants.DECLARATIONS, method);
        }
        this.check(ICSearchConstants.DEFINITIONS, method);
        this.pushScope(method);
    }

    public void enterCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.pushScope(compilationUnit);
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.lastDeclaration = namespaceDefinition;
        this.check(ICSearchConstants.DECLARATIONS, namespaceDefinition);
        this.check(ICSearchConstants.DEFINITIONS, namespaceDefinition);
        this.pushScope(namespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier classSpecification) {
        this.lastDeclaration = classSpecification;
        this.check(ICSearchConstants.DECLARATIONS, classSpecification);
        this.pushScope(classSpecification);
    }

    public void exitFunctionBody(IASTFunction function) {
        this.popScope();
    }

    public void exitMethodBody(IASTMethod method) {
        this.popScope();
    }

    public void exitClassSpecifier(IASTClassSpecifier classSpecification) {
        this.popScope();
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.popScope();
    }

    public void exitCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.popScope();
    }

    public void enterInclusion(IASTInclusion inclusion) {
        String includePath = inclusion.getFullFileName();
        Path path = new Path(includePath);
        IFile resource = null;
        if (this.workspaceRoot != null) {
            resource = this.workspaceRoot.getFileForLocation((IPath)path);
        }
        this.resourceStack.addFirst(this.currentResource != null ? this.currentResource : this.currentPath);
        this.currentResource = resource;
        this.currentPath = resource == null ? path : null;
    }

    public void exitInclusion(IASTInclusion inclusion) {
        Object obj = this.resourceStack.removeFirst();
        if (obj instanceof IResource) {
            this.currentResource = (IResource)obj;
            this.currentPath = null;
        } else {
            this.currentPath = (IPath)obj;
            this.currentResource = null;
        }
    }

    public void locateMatches(String[] paths, IWorkspace workspace, IWorkingCopy[] workingCopies) {
        int i;
        int wcLength;
        this.workspaceRoot = workspace != null ? workspace.getRoot() : null;
        HashMap<String, IWorkingCopy> wcPaths = new HashMap<String, IWorkingCopy>();
        int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
        if (wcLength > 0) {
            String[] newPaths = new String[wcLength];
            i = 0;
            while (i < wcLength) {
                IWorkingCopy workingCopy = workingCopies[i];
                String path = workingCopy.getOriginalElement().getPath().toString();
                wcPaths.put(path, workingCopy);
                newPaths[i] = path;
                ++i;
            }
            int len = paths.length;
            String[] tempArray = new String[len + wcLength];
            System.arraycopy(paths, 0, tempArray, 0, len);
            System.arraycopy(newPaths, 0, tempArray, len, wcLength);
            paths = tempArray;
        }
        Arrays.sort(paths);
        int length = paths.length;
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask("", length);
        }
        i = 0;
        while (i < length) {
            block18: {
                if (this.progressMonitor != null) {
                    if (this.progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    this.progressMonitor.worked(1);
                }
                String pathString = paths[i];
                if ((i <= 0 || !pathString.equals(paths[i - 1])) && this.searchScope.encloses(pathString)) {
                    IScannerInfo buildScanInfo;
                    IProject project;
                    IPath realPath;
                    Reader reader;
                    block17: {
                        reader = null;
                        realPath = null;
                        project = null;
                        if (this.workspaceRoot != null) {
                            IWorkingCopy workingCopy = (IWorkingCopy)wcPaths.get(pathString);
                            if (workingCopy != null) {
                                reader = new CharArrayReader(workingCopy.getContents());
                                this.currentResource = workingCopy.getResource();
                                realPath = this.currentResource.getLocation();
                                project = this.currentResource.getProject();
                            } else {
                                this.currentResource = this.workspaceRoot.findMember(pathString, true);
                                try {
                                    if (this.currentResource == null || !(this.currentResource instanceof IFile)) break block17;
                                    IFile file = (IFile)this.currentResource;
                                    reader = new InputStreamReader(file.getContents());
                                    realPath = this.currentResource.getLocation();
                                    project = file.getProject();
                                }
                                catch (CoreException coreException) {
                                    break block18;
                                }
                            }
                        }
                    }
                    if (this.currentResource == null) {
                        Path path = new Path(pathString);
                        try {
                            this.currentPath = path;
                            reader = new FileReader(path.toFile());
                            realPath = this.currentPath;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            break block18;
                        }
                    }
                    ScannerInfo scanInfo = new ScannerInfo();
                    IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
                    if (provider != null && (buildScanInfo = provider.getScannerInformation((IResource)project)) != null) {
                        scanInfo = new ScannerInfo(buildScanInfo.getDefinedSymbols(), buildScanInfo.getIncludePaths());
                    }
                    ParserLanguage language = null;
                    language = project != null ? (CoreModel.getDefault().hasCCNature(project) ? ParserLanguage.CPP : ParserLanguage.C) : ParserLanguage.CPP;
                    IScanner scanner = ParserFactory.createScanner(reader, realPath.toOSString(), scanInfo, ParserMode.COMPLETE_PARSE, language, this);
                    IParser parser = ParserFactory.createParser(scanner, this, ParserMode.COMPLETE_PARSE, language);
                    if (VERBOSE) {
                        MatchLocator.verbose("*** New Search for path: " + pathString);
                    }
                    parser.parse();
                }
            }
            ++i;
        }
    }

    protected void report(ISourceElementCallbackDelegate node, int accuracyLevel) {
        try {
            if (this.currentResource != null && !this.searchScope.encloses(this.currentResource.getFullPath().toOSString())) {
                return;
            }
            int offset = 0;
            int end = 0;
            if (node instanceof IASTReference) {
                IASTReference reference = (IASTReference)node;
                offset = reference.getOffset();
                end = offset + reference.getName().length();
                if (VERBOSE) {
                    MatchLocator.verbose("Report Match: " + reference.getName());
                }
            } else if (node instanceof IASTOffsetableNamedElement) {
                IASTOffsetableNamedElement offsetableElement = (IASTOffsetableNamedElement)((Object)node);
                offset = offsetableElement.getNameOffset() != 0 ? offsetableElement.getNameOffset() : offsetableElement.getStartingOffset();
                end = offsetableElement.getNameEndOffset();
                if (end == 0) {
                    end = offset + offsetableElement.getName().length();
                }
                if (VERBOSE) {
                    MatchLocator.verbose("Report Match: " + offsetableElement.getName());
                }
            }
            IMatch match = null;
            ISourceElementCallbackDelegate object = null;
            if (node instanceof IASTReference) {
                object = this.currentScope instanceof IASTFunction || this.currentScope instanceof IASTMethod ? (ISourceElementCallbackDelegate)((Object)this.currentScope) : this.lastDeclaration;
            } else if (this.currentScope instanceof IASTFunction || this.currentScope instanceof IASTMethod) {
                if (this.shouldExcludeLocalDeclarations) {
                    return;
                }
                object = (ISourceElementCallbackDelegate)((Object)this.currentScope);
            } else {
                object = node;
            }
            if (this.currentResource != null) {
                match = this.resultCollector.createMatch(this.currentResource, offset, end, object);
            } else if (this.currentPath != null) {
                match = this.resultCollector.createMatch(this.currentPath, offset, end, object);
            }
            if (match != null) {
                this.resultCollector.acceptMatch(match);
            }
        }
        catch (CoreException coreException) {}
    }

    private void check(ICSearchConstants.LimitTo limit, ISourceElementCallbackDelegate node) {
        if (!this.searchPattern.canAccept(limit)) {
            return;
        }
        int level = 0;
        level = node instanceof IASTReference ? this.searchPattern.matchLevel(((IASTReference)node).getReferencedElement(), limit) : this.searchPattern.matchLevel(node, limit);
        if (level != 0) {
            this.report(node, level);
        }
    }

    private void pushScope(IASTScope scope) {
        this.scopeStack.addFirst(this.currentScope);
        this.currentScope = scope;
    }

    private IASTScope popScope() {
        IASTScope oldScope = this.currentScope;
        this.currentScope = this.scopeStack.size() > 0 ? (IASTScope)this.scopeStack.removeFirst() : null;
        return oldScope;
    }

    public void setShouldExcludeLocalDeclarations(boolean exclude) {
        this.shouldExcludeLocalDeclarations = exclude;
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier elaboratedType) {
        this.check(ICSearchConstants.DECLARATIONS, elaboratedType);
    }

    public static void verbose(String log) {
        System.out.println("(" + Thread.currentThread() + ") " + log);
    }
}

