/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.utils.pty.PTY;

class PTYInputStream
extends InputStream {
    PTY.MasterFD master;

    static {
        System.loadLibrary("pty");
    }

    public PTYInputStream(PTY.MasterFD fd) {
        this.master = fd;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (1 != this.read(b, 0, 1)) {
            return -1;
        }
        return b[0];
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        byte[] tmpBuf = new byte[len];
        len = this.read0(this.master.getFD(), tmpBuf, len);
        if (len <= 0) {
            return -1;
        }
        System.arraycopy(tmpBuf, 0, buf, off, len);
        return len;
    }

    public void close() throws IOException {
        if (this.master.getFD() == -1) {
            return;
        }
        int status = this.close0(this.master.getFD());
        if (status == -1) {
            throw new IOException("close error");
        }
        this.master.setFD(-1);
    }

    private native int read0(int var1, byte[] var2, int var3) throws IOException;

    private native int close0(int var1) throws IOException;
}

