/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeScannerInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MakeScannerProvider
extends AbstractCExtension
implements IScannerInfoProvider {
    public static final String INTERFACE_IDENTITY = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".MakeScannerProvider";
    private static final QualifiedName scannerInfoProperty = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "makeBuildInfo");
    private static final String CDESCRIPTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeScannerInfo";
    public static final String INCLUDE_PATH = "includePath";
    public static final String PATH = "path";
    public static final String DEFINED_SYMBOL = "definedSymbol";
    public static final String SYMBOL = "symbol";
    private static Map listeners;
    private static MakeScannerProvider defaultProvider;

    public static MakeScannerProvider getDefault() {
        if (defaultProvider == null) {
            defaultProvider = new MakeScannerProvider();
        }
        return defaultProvider;
    }

    public MakeScannerInfo getMakeScannerInfo(IProject project, boolean cacheInfo) throws CoreException {
        MakeScannerInfo scannerInfo = null;
        scannerInfo = (MakeScannerInfo)project.getSessionProperty(scannerInfoProperty);
        if (scannerInfo == null) {
            scannerInfo = this.loadScannerInfo(project);
        }
        if (scannerInfo != null && cacheInfo) {
            project.setSessionProperty(scannerInfoProperty, (Object)scannerInfo);
        }
        return scannerInfo;
    }

    private static synchronized Map getListeners() {
        if (listeners == null) {
            listeners = new HashMap();
        }
        return listeners;
    }

    private static void notifyInfoListeners(IProject project, IScannerInfo info) {
        List listeners = (List)MakeScannerProvider.getListeners().get(project);
        if (listeners == null) {
            return;
        }
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ((IScannerInfoChangeListener)iter.next()).changeNotification((IResource)project, info);
        }
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        MakeScannerInfo info = null;
        try {
            info = this.getMakeScannerInfo(resource.getProject(), true);
        }
        catch (CoreException coreException) {}
        return info;
    }

    private MakeScannerInfo loadScannerInfo(IProject project) throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(project);
        Node child = descriptor.getProjectData(CDESCRIPTOR_ID).getFirstChild();
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> symbols = new ArrayList<String>();
        while (child != null) {
            if (child.getNodeName().equals(INCLUDE_PATH)) {
                includes.add(((Element)child).getAttribute(PATH));
            } else if (child.getNodeName().equals(DEFINED_SYMBOL)) {
                symbols.add(((Element)child).getAttribute(SYMBOL));
            }
            child = child.getNextSibling();
        }
        MakeScannerInfo info = new MakeScannerInfo(project);
        info.setIncludePaths(includes.toArray(new String[includes.size()]));
        info.setPreprocessorSymbols(symbols.toArray(new String[symbols.size()]));
        return info;
    }

    public static void removeScannerInfo(IResource resource) {
        try {
            resource.getProject().setSessionProperty(scannerInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    static void updateScannerInfo(MakeScannerInfo scannerInfo) throws CoreException {
        IProject project = scannerInfo.getProject();
        if (project.getSessionProperty(scannerInfoProperty) != null) {
            project.setSessionProperty(scannerInfoProperty, (Object)scannerInfo);
        }
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(project);
        Element rootElement = descriptor.getProjectData(CDESCRIPTOR_ID);
        Node child = rootElement.getFirstChild();
        while (child != null) {
            rootElement.removeChild(child);
            child = rootElement.getFirstChild();
        }
        if (scannerInfo != null) {
            Document doc = rootElement.getOwnerDocument();
            ListIterator<String> iter = Arrays.asList(scannerInfo.getIncludePaths()).listIterator();
            while (iter.hasNext()) {
                Element pathElement = doc.createElement(INCLUDE_PATH);
                pathElement.setAttribute(PATH, iter.next());
                rootElement.appendChild(pathElement);
            }
            iter = Arrays.asList(scannerInfo.getPreprocessorSymbols()).listIterator();
            while (iter.hasNext()) {
                Element symbolElement = doc.createElement(DEFINED_SYMBOL);
                symbolElement.setAttribute(SYMBOL, iter.next());
                rootElement.appendChild(symbolElement);
            }
            descriptor.saveProjectData();
        }
        MakeScannerProvider.notifyInfoListeners(project, scannerInfo);
    }

    public synchronized void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = MakeScannerProvider.getListeners();
        ArrayList<IScannerInfoChangeListener> list = (ArrayList<IScannerInfoChangeListener>)map.get(project);
        if (list == null) {
            list = new ArrayList<IScannerInfoChangeListener>();
        }
        if (!list.contains(listener)) {
            list.add(listener);
            map.put(project, list);
        }
    }

    public synchronized void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = MakeScannerProvider.getListeners();
        List list = (List)map.get(project);
        if (list != null && !list.isEmpty()) {
            list.remove(listener);
            map.put(project, list);
        }
    }
}

