/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class BuildInfoFactory {
    private static final String PREFIX = MakeCorePlugin.getUniqueIdentifier();
    static final String BUILD_COMMAND = String.valueOf(PREFIX) + ".buildCommand";
    static final String BUILD_LOCATION = String.valueOf(PREFIX) + ".buildLocation";
    static final String STOP_ON_ERROR = String.valueOf(PREFIX) + ".stopOnError";
    static final String USE_DEFAULT_BUILD_CMD = String.valueOf(PREFIX) + ".useDefaultBuildCmd";
    static final String BUILD_TARGET_AUTO = String.valueOf(PREFIX) + ".autoBuildTarget";
    static final String BUILD_TARGET_INCREMENTAL = String.valueOf(PREFIX) + ".incrementalBuildTarget";
    static final String BUILD_TARGET_FULL = String.valueOf(PREFIX) + ".fullBuildTarget";
    static final String BUILD_FULL_ENABLED = String.valueOf(PREFIX) + ".enableFullBuild";
    static final String BUILD_INCREMENTAL_ENABLED = String.valueOf(PREFIX) + ".enabledIncrementalBuild";
    static final String BUILD_AUTO_ENABLED = String.valueOf(PREFIX) + ".enableAutoBuild";
    static final String BUILD_ARGUMENTS = String.valueOf(PREFIX) + ".buildArguments";

    public static IMakeBuilderInfo create(Preferences prefs, String builderID, boolean useDefaults) {
        return new Preference(prefs, builderID, useDefaults);
    }

    public static IMakeBuilderInfo create(IProject project, String builderID) throws CoreException {
        return new BuildProperty(project, builderID);
    }

    public static IMakeBuilderInfo create(Map args, String builderID) {
        return new BuildArguments(args, builderID);
    }

    private static abstract class Store
    implements IMakeBuilderInfo {
        Store() {
        }

        public void setUseDefaultBuildCmd(boolean on) throws CoreException {
            this.putValue(USE_DEFAULT_BUILD_CMD, new Boolean(on).toString());
        }

        public boolean isDefaultBuildCmd() {
            if (this.getString(USE_DEFAULT_BUILD_CMD) == null) {
                return true;
            }
            return this.getBoolean(USE_DEFAULT_BUILD_CMD);
        }

        public void setBuildCommand(IPath location) throws CoreException {
            this.putValue(BUILD_COMMAND, location.toString());
        }

        public IPath getBuildCommand() {
            if (this.isDefaultBuildCmd()) {
                String command = this.getBuildParameter("defaultCommand");
                if (command == null) {
                    return new Path("make");
                }
                return new Path(command);
            }
            return new Path(this.getString(BUILD_COMMAND));
        }

        protected String getBuildParameter(String name) {
            IExtension extension = Platform.getPluginRegistry().getExtension("org.eclipse.core.resources", "builders", this.getBuilderID());
            if (extension == null) {
                return null;
            }
            IConfigurationElement[] configs = extension.getConfigurationElements();
            if (configs.length == 0) {
                return null;
            }
            IConfigurationElement[] runElement = configs[0].getChildren("run");
            IConfigurationElement[] paramElement = runElement[0].getChildren("parameter");
            int i = 0;
            while (i < paramElement.length) {
                if (paramElement[i].getAttribute("name").equals(name)) {
                    return paramElement[i].getAttribute("value");
                }
                ++i;
            }
            return null;
        }

        protected abstract String getBuilderID();

        public void setBuildLocation(IPath location) throws CoreException {
            this.putValue(BUILD_LOCATION, location.toString());
        }

        public IPath getBuildLocation() {
            String location = this.getString(BUILD_LOCATION);
            return new Path(location == null ? "" : location);
        }

        public void setStopOnError(boolean enabled) throws CoreException {
            this.putValue(STOP_ON_ERROR, new Boolean(enabled).toString());
        }

        public boolean isStopOnError() {
            return this.getBoolean(STOP_ON_ERROR);
        }

        public void setAutoBuildTarget(String target) throws CoreException {
            this.putValue(BUILD_TARGET_AUTO, target);
        }

        public String getAutoBuildTarget() {
            return this.getString(BUILD_TARGET_AUTO);
        }

        public void setIncrementalBuildTarget(String target) throws CoreException {
            this.putValue(BUILD_TARGET_INCREMENTAL, target);
        }

        public String getIncrementalBuildTarget() {
            return this.getString(BUILD_TARGET_INCREMENTAL);
        }

        public void setFullBuildTarget(String target) throws CoreException {
            this.putValue(BUILD_TARGET_FULL, target);
        }

        public String getFullBuildTarget() {
            return this.getString(BUILD_TARGET_FULL);
        }

        public boolean getBoolean(String property) {
            return Boolean.valueOf(this.getString(property));
        }

        public abstract void putValue(String var1, String var2) throws CoreException;

        public abstract String getString(String var1);

        public void setAutoBuildEnable(boolean enabled) throws CoreException {
            this.putValue(BUILD_AUTO_ENABLED, new Boolean(enabled).toString());
        }

        public boolean isAutoBuildEnable() {
            return this.getBoolean(BUILD_AUTO_ENABLED);
        }

        public void setIncrementalBuildEnable(boolean enabled) throws CoreException {
            this.putValue(BUILD_INCREMENTAL_ENABLED, new Boolean(enabled).toString());
        }

        public boolean isIncrementalBuildEnabled() {
            return this.getBoolean(BUILD_INCREMENTAL_ENABLED);
        }

        public void setFullBuildEnable(boolean enabled) throws CoreException {
            this.putValue(BUILD_FULL_ENABLED, new Boolean(enabled).toString());
        }

        public boolean isFullBuildEnabled() {
            return this.getBoolean(BUILD_FULL_ENABLED);
        }

        public String getBuildArguments() {
            return this.getString(BUILD_ARGUMENTS);
        }

        public void setBuildArguments(String args) throws CoreException {
            this.putValue(BUILD_ARGUMENTS, args);
        }

        public String[] getErrorParsers() {
            String parsers = this.getString("org.eclipse.cdt.core.errorOutputParser");
            if (parsers != null && parsers.length() > 0) {
                StringTokenizer tok = new StringTokenizer(parsers, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                return list.toArray(new String[list.size()]);
            }
            return new String[0];
        }

        public void setErrorParsers(String[] parsers) throws CoreException {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < parsers.length) {
                buf.append(parsers[i]).append(';');
                ++i;
            }
            this.putValue("org.eclipse.cdt.core.errorOutputParser", buf.toString());
        }
    }

    private static class Preference
    extends Store {
        private Preferences prefs;
        private String builderID;
        private boolean useDefaults;

        public Preference(Preferences prefs, String builderID, boolean useDefaults) {
            this.prefs = prefs;
            this.builderID = builderID;
            this.useDefaults = useDefaults;
        }

        public void putValue(String name, String value) {
            if (this.useDefaults) {
                this.prefs.setDefault(name, value);
            } else {
                this.prefs.setValue(name, value);
            }
        }

        public String getString(String property) {
            if (this.useDefaults) {
                return this.prefs.getDefaultString(property);
            }
            return this.prefs.getString(property);
        }

        protected String getBuilderID() {
            return this.builderID;
        }
    }

    private static class BuildProperty
    extends Store {
        private IProject project;
        private String builderID;
        private Map args;

        public BuildProperty(IProject project, String builderID) throws CoreException {
            this.project = project;
            this.builderID = builderID;
            ICommand builder = MakeProjectNature.getBuildSpec(project, builderID);
            if (builder == null) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, String.valueOf(MakeCorePlugin.getResourceString("BuildInfoFactory.Missing_Builder")) + builderID, null));
            }
            this.args = builder.getArguments();
        }

        public void putValue(String name, String value) throws CoreException {
            String curValue = (String)this.args.get(name);
            if (curValue != null && curValue.equals(value)) {
                return;
            }
            ICommand builder = MakeProjectNature.getBuildSpec(this.project, this.builderID);
            this.args.put(name, value);
            builder.setArguments(this.args);
            this.project.setDescription(this.project.getDescription(), null);
        }

        public String getString(String name) {
            String value = (String)this.args.get(name);
            return value == null ? "" : value;
        }

        public String getBuilderID() {
            return this.builderID;
        }
    }

    private static class BuildArguments
    extends Store {
        private Map args;
        private String builderID;

        public BuildArguments(Map args, String builderID) {
            this.args = args;
            this.builderID = builderID;
        }

        public void putValue(String name, String value) {
            this.args.put(name, value);
        }

        public String getString(String name) {
            return (String)this.args.get(name);
        }

        public String getBuilderID() {
            return this.builderID;
        }
    }
}

