/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.HashMap;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class MakeTarget
implements IMakeTarget {
    private String target;
    private String buildArguments;
    private IPath buildCommand;
    private boolean isDefaultBuildCmd;
    private boolean isStopOnError;
    private String name;
    private String targetBuilderID;
    private IContainer container;
    private MakeTargetManager manager;

    MakeTarget(MakeTargetManager manager, IProject project, String targetBuilderID, String name) throws CoreException {
        this.manager = manager;
        this.targetBuilderID = targetBuilderID;
        this.name = name;
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(project, manager.getBuilderID(targetBuilderID));
        this.buildCommand = info.getBuildCommand();
        this.buildArguments = info.getBuildArguments();
        this.isDefaultBuildCmd = info.isDefaultBuildCmd();
        this.isStopOnError = info.isStopOnError();
    }

    public void setContainer(IContainer container) {
        this.container = container;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetBuilderID() {
        return this.targetBuilderID;
    }

    public boolean isStopOnError() {
        return this.isStopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.isStopOnError = stopOnError;
    }

    public boolean isDefaultBuildCmd() {
        return this.isDefaultBuildCmd;
    }

    public void setUseDefaultBuildCmd(boolean useDefault) {
        this.isDefaultBuildCmd = useDefault;
    }

    public IPath getBuildCommand() {
        return this.buildCommand != null ? this.buildCommand : new Path("");
    }

    public void setBuildCommand(IPath command) {
        this.buildCommand = command;
    }

    public String getBuildArguments() {
        return this.buildArguments != null ? this.buildArguments : "";
    }

    public void setBuildArguments(String arguments) {
        this.buildArguments = arguments;
    }

    public IContainer getContainer() {
        return this.container;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MakeTarget) {
            MakeTarget other = (MakeTarget)obj;
            return this.container.equals((Object)other.getContainer()) && this.name.equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.container.hashCode() * 17 + this.name.hashCode();
    }

    public void build(IProgressMonitor monitor) throws CoreException {
        IProject project = this.container.getProject();
        String builderID = this.manager.getBuilderID(this.targetBuilderID);
        HashMap infoMap = new HashMap();
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(infoMap, builderID);
        if (this.buildArguments != null) {
            info.setBuildArguments(this.buildArguments);
        }
        if (this.buildCommand != null) {
            info.setBuildCommand(this.buildCommand);
        }
        info.setUseDefaultBuildCmd(this.isDefaultBuildCmd);
        info.setStopOnError(this.isStopOnError);
        info.setFullBuildEnable(true);
        info.setFullBuildTarget(this.target);
        if (this.container != null) {
            info.setBuildLocation(this.container.getFullPath());
        }
        IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(project, builderID);
        info.setErrorParsers(projectInfo.getErrorParsers());
        project.build(6, builderID, infoMap, monitor);
    }

    public void setBuildTarget(String target) {
        this.target = target;
    }

    public String getBuildTarget() {
        return this.target;
    }
}

