/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeTarget;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectTargets {
    private static final String BUILD_TARGET_ELEMENT = "buildTargets";
    private static final String TARGET_ELEMENT = "target";
    private static final String TARGET_ATTR_ID = "targetID";
    private static final String TARGET_ATTR_PATH = "path";
    private static final String TARGET_ATTR_NAME = "name";
    private static final String TARGET_STOP_ON_ERROR = "stopOnError";
    private static final String TARGET_USE_DEFAULT_CMD = "useDefaultCommand";
    private static final String TARGET_ARGUMENTS = "buildArguments";
    private static final String TARGET_COMMAND = "buildCommand";
    private static final String TARGET = "buidlTarget";
    private HashMap targetMap = new HashMap();
    private IProject project;
    private MakeTargetManager manager;

    public ProjectTargets(MakeTargetManager manager, IProject project) {
        this.project = project;
        this.manager = manager;
    }

    public ProjectTargets(MakeTargetManager manager, IProject project, InputStream input) {
        this(manager, project);
        Node document = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = parser.parse(input);
        }
        catch (Exception e) {
            MakeCorePlugin.log(e);
        }
        Node node = document.getFirstChild();
        if (node.getNodeName().equals(BUILD_TARGET_ELEMENT)) {
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                node = list.item(i);
                if (node.getNodeName().equals(TARGET_ELEMENT)) {
                    Object container = null;
                    NamedNodeMap attr = node.getAttributes();
                    String path = attr.getNamedItem(TARGET_ATTR_PATH).getNodeValue();
                    container = path != null && !path.equals("") ? project.getFolder(path) : project;
                    try {
                        MakeTarget target = new MakeTarget(manager, project, attr.getNamedItem(TARGET_ATTR_ID).getNodeValue(), attr.getNamedItem(TARGET_ATTR_NAME).getNodeValue());
                        target.setContainer((IContainer)container);
                        String option = this.getString(node, TARGET_STOP_ON_ERROR);
                        if (option != null) {
                            target.setStopOnError(Boolean.valueOf(option));
                        }
                        if ((option = this.getString(node, TARGET_USE_DEFAULT_CMD)) != null) {
                            target.setUseDefaultBuildCmd(Boolean.valueOf(option));
                        }
                        if ((option = this.getString(node, TARGET_COMMAND)) != null) {
                            target.setBuildCommand((IPath)new Path(option));
                        }
                        if ((option = this.getString(node, TARGET_ARGUMENTS)) != null) {
                            target.setBuildArguments(option);
                        }
                        if ((option = this.getString(node, TARGET)) != null) {
                            target.setBuildTarget(option);
                        }
                        this.add(target);
                    }
                    catch (CoreException e) {
                        MakeCorePlugin.log(e);
                    }
                }
                ++i;
            }
        }
    }

    protected String getString(Node target, String tagName) {
        Node node = this.searchNode(target, tagName);
        return node != null ? (node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue()) : null;
    }

    protected Node searchNode(Node target, String tagName) {
        NodeList list = target.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeName().equals(tagName)) {
                return list.item(i);
            }
            ++i;
        }
        return null;
    }

    public IMakeTarget[] get(IContainer container) {
        ArrayList list = (ArrayList)this.targetMap.get(container);
        if (list != null) {
            return list.toArray(new IMakeTarget[list.size()]);
        }
        return new IMakeTarget[0];
    }

    public IMakeTarget findTarget(IContainer container, String name) {
        ArrayList list = (ArrayList)this.targetMap.get(container);
        if (list != null) {
            Iterator targets = ((AbstractList)list).iterator();
            while (targets.hasNext()) {
                IMakeTarget target = (IMakeTarget)targets.next();
                if (!target.getName().equals(name)) continue;
                return target;
            }
        }
        return null;
    }

    public void add(MakeTarget target) throws CoreException {
        ArrayList<MakeTarget> list = (ArrayList<MakeTarget>)this.targetMap.get(target.getContainer());
        if (list != null && list.contains(target)) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeCorePlugin.getResourceString("MakeTargetManager.target_exists"), null));
        }
        if (list == null) {
            list = new ArrayList<MakeTarget>();
            this.targetMap.put(target.getContainer(), list);
        }
        list.add(target);
    }

    public boolean contains(MakeTarget target) {
        ArrayList list = (ArrayList)this.targetMap.get(target.getContainer());
        return list != null && list.contains(target);
    }

    public void remove(IMakeTarget target) {
        ArrayList list = (ArrayList)this.targetMap.get(target.getContainer());
        if (list != null && !list.contains(target)) {
            return;
        }
        ((AbstractCollection)list).remove(target);
        if (list.size() == 0) {
            this.targetMap.remove(list);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    protected Document getAsXML() throws IOException {
        DocumentImpl doc = new DocumentImpl();
        Element targetsRootElement = doc.createElement(BUILD_TARGET_ELEMENT);
        doc.appendChild(targetsRootElement);
        Iterator container = this.targetMap.entrySet().iterator();
        while (container.hasNext()) {
            List targets = (List)container.next().getValue();
            int i = 0;
            while (i < targets.size()) {
                MakeTarget target = (MakeTarget)targets.get(i);
                targetsRootElement.appendChild(this.createTargetElement((Document)doc, target));
                ++i;
            }
        }
        return doc;
    }

    private Node createTargetElement(Document doc, MakeTarget target) {
        Element targetElem = doc.createElement(TARGET_ELEMENT);
        targetElem.setAttribute(TARGET_ATTR_NAME, target.getName());
        targetElem.setAttribute(TARGET_ATTR_ID, target.getTargetBuilderID());
        targetElem.setAttribute(TARGET_ATTR_PATH, target.getContainer().getProjectRelativePath().toString());
        Element elem = doc.createElement(TARGET_COMMAND);
        targetElem.appendChild(elem);
        elem.appendChild(doc.createTextNode(target.getBuildCommand().toString()));
        elem = doc.createElement(TARGET_ARGUMENTS);
        elem.appendChild(doc.createTextNode(target.getBuildArguments()));
        targetElem.appendChild(elem);
        elem = doc.createElement(TARGET);
        elem.appendChild(doc.createTextNode(target.getBuildTarget()));
        targetElem.appendChild(elem);
        elem = doc.createElement(TARGET_STOP_ON_ERROR);
        elem.appendChild(doc.createTextNode(new Boolean(target.isStopOnError()).toString()));
        targetElem.appendChild(elem);
        elem = doc.createElement(TARGET_USE_DEFAULT_CMD);
        elem.appendChild(doc.createTextNode(new Boolean(target.isDefaultBuildCmd()).toString()));
        targetElem.appendChild(elem);
        return targetElem;
    }

    public void saveTargets(OutputStream output) throws IOException {
        Document doc = this.getAsXML();
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setPreserveSpace(true);
        format.setLineSeparator(System.getProperty("line.separator"));
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter(output, "UTF8"), format);
        serializer.asDOMSerializer().serialize(doc);
    }
}

