/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.posix;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.internal.core.makefile.AbstractMakefile;
import org.eclipse.cdt.make.internal.core.makefile.BadDirective;
import org.eclipse.cdt.make.internal.core.makefile.Command;
import org.eclipse.cdt.make.internal.core.makefile.Comment;
import org.eclipse.cdt.make.internal.core.makefile.DefaultRule;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.EmptyLine;
import org.eclipse.cdt.make.internal.core.makefile.IgnoreRule;
import org.eclipse.cdt.make.internal.core.makefile.InferenceRule;
import org.eclipse.cdt.make.internal.core.makefile.MacroDefinition;
import org.eclipse.cdt.make.internal.core.makefile.MakefileReader;
import org.eclipse.cdt.make.internal.core.makefile.PosixRule;
import org.eclipse.cdt.make.internal.core.makefile.PreciousRule;
import org.eclipse.cdt.make.internal.core.makefile.Rule;
import org.eclipse.cdt.make.internal.core.makefile.SccsGetRule;
import org.eclipse.cdt.make.internal.core.makefile.SilentRule;
import org.eclipse.cdt.make.internal.core.makefile.SpecialRule;
import org.eclipse.cdt.make.internal.core.makefile.SuffixesRule;
import org.eclipse.cdt.make.internal.core.makefile.Target;
import org.eclipse.cdt.make.internal.core.makefile.TargetRule;
import org.eclipse.cdt.make.internal.core.makefile.Util;
import org.eclipse.cdt.make.internal.core.makefile.posix.PosixMakefileUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PosixMakefile
extends AbstractMakefile {
    IDirective[] builtins = null;

    public PosixMakefile() {
        super(null);
    }

    public void parse(String name) throws IOException {
        FileReader stream = new FileReader(name);
        this.parse(stream);
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void parse(Reader reader) throws IOException {
        this.parse(new MakefileReader(reader));
    }

    protected void parse(MakefileReader reader) throws IOException {
        String line;
        Rule[] rules = null;
        int startLine = 0;
        int endLine = 0;
        while ((line = reader.readLine()) != null) {
            int i;
            int pound;
            startLine = endLine + 1;
            endLine = reader.getLineNumber();
            if (PosixMakefileUtil.isCommand(line)) {
                Command cmd = new Command(this, line);
                cmd.setLines(startLine, endLine);
                if (rules != null) {
                    int i2 = 0;
                    while (i2 < rules.length) {
                        rules[i2].addDirective(cmd);
                        rules[i2].setEndLine(endLine);
                        ++i2;
                    }
                    continue;
                }
            }
            if ((pound = Util.indexOfComment(line)) != -1) {
                Comment cmt = new Comment(this, line.substring(pound + 1));
                cmt.setLines(startLine, endLine);
                if (rules != null) {
                    i = 0;
                    while (i < rules.length) {
                        rules[i].addDirective(cmt);
                        rules[i].setEndLine(endLine);
                        ++i;
                    }
                } else {
                    this.addDirective(cmt);
                }
                line = line.substring(0, pound);
                if (Util.isEmptyLine(line)) continue;
            }
            if (Util.isEmptyLine(line)) {
                EmptyLine empty = new EmptyLine(this);
                empty.setLines(startLine, endLine);
                if (rules != null) {
                    i = 0;
                    while (i < rules.length) {
                        rules[i].addDirective(empty);
                        rules[i].setEndLine(endLine);
                        ++i;
                    }
                    continue;
                }
                this.addDirective(empty);
                continue;
            }
            rules = null;
            SpecialRule special = this.processSpecialRule(line);
            if (special != null) {
                rules = new Rule[]{special};
                special.setLines(startLine, endLine);
                this.addDirective(special);
                continue;
            }
            if (PosixMakefileUtil.isInferenceRule(line)) {
                InferenceRule irule = this.parseInferenceRule(line);
                irule.setLines(startLine, endLine);
                this.addDirective(irule);
                rules = new Rule[]{irule};
                continue;
            }
            if (PosixMakefileUtil.isMacroDefinition(line)) {
                MacroDefinition stmt = this.parseMacroDefinition(line);
                stmt.setLines(startLine, endLine);
                this.addDirective(stmt);
                continue;
            }
            if (PosixMakefileUtil.isTargetRule(line)) {
                TargetRule[] trules = this.parseTargetRule(line);
                int i3 = 0;
                while (i3 < trules.length) {
                    trules[i3].setLines(startLine, endLine);
                    this.addDirective(trules[i3]);
                    ++i3;
                }
                rules = trules;
                continue;
            }
            BadDirective stmt = new BadDirective(this, line);
            stmt.setLines(startLine, endLine);
            this.addDirective(stmt);
        }
        this.setLines(1, endLine);
    }

    public IDirective[] getBuiltins() {
        if (this.builtins == null) {
            String location = "builtin" + File.separator + "posix.mk";
            try {
                InputStream stream = MakeCorePlugin.getDefault().openStream((IPath)new Path(location));
                PosixMakefile gnu = new PosixMakefile();
                gnu.parse(new InputStreamReader(stream));
                this.builtins = gnu.getDirectives();
                int i = 0;
                while (i < this.builtins.length) {
                    if (this.builtins[i] instanceof MacroDefinition) {
                        ((MacroDefinition)this.builtins[i]).setFromDefault(true);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
            if (this.builtins == null) {
                this.builtins = new IDirective[0];
            }
        }
        return this.builtins;
    }

    protected SpecialRule processSpecialRule(String line) {
        line = line.trim();
        String keyword = null;
        String[] reqs = null;
        SpecialRule special = null;
        int index = Util.indexOf(line, ':');
        if (index != -1) {
            keyword = line.substring(0, index).trim();
            String req = line.substring(index + 1);
            reqs = PosixMakefileUtil.findPrerequisites(req);
        } else {
            keyword = line;
            reqs = new String[]{};
        }
        if (".IGNORE".equals(keyword)) {
            special = new IgnoreRule((Directive)this, reqs);
        } else if (".POSIX".equals(keyword)) {
            special = new PosixRule(this);
        } else if (".PRECIOUS".equals(keyword)) {
            special = new PreciousRule((Directive)this, reqs);
        } else if (".SILENT".equals(keyword)) {
            special = new SilentRule((Directive)this, reqs);
        } else if (".SUFFIXES".equals(keyword)) {
            special = new SuffixesRule((Directive)this, reqs);
        } else if (".DEFAULT".equals(keyword)) {
            special = new DefaultRule((Directive)this, new Command[0]);
        } else if (".SCCS_GET".equals(keyword)) {
            special = new SccsGetRule((Directive)this, new Command[0]);
        }
        return special;
    }

    protected InferenceRule parseInferenceRule(String line) {
        int index = Util.indexOf(line, ':');
        String tgt = index != -1 ? line.substring(0, index) : line;
        return new InferenceRule(this, new Target(tgt));
    }

    protected MacroDefinition parseMacroDefinition(String line) {
        String value;
        String name;
        int index = Util.indexOf(line, '=');
        if (index != -1) {
            name = line.substring(0, index).trim();
            value = line.substring(index + 1).trim();
        } else {
            name = line;
            value = "";
        }
        return new MacroDefinition(this, name, new StringBuffer(value));
    }

    protected TargetRule[] parseTargetRule(String line) {
        String[] reqs;
        String[] targets;
        String cmd = null;
        int index = Util.indexOf(line, ':');
        if (index != -1) {
            String target = line.substring(0, index);
            targets = PosixMakefileUtil.findTargets(target);
            String req = line.substring(index + 1);
            int semicolon = Util.indexOf(req, ';');
            if (semicolon != -1) {
                String c = req.substring(semicolon + 1).trim();
                if (c.length() > 0) {
                    cmd = c;
                }
                req = req.substring(0, semicolon);
            }
            reqs = PosixMakefileUtil.findPrerequisites(req);
        } else {
            targets = PosixMakefileUtil.findTargets(line);
            reqs = new String[]{};
        }
        TargetRule[] targetRules = new TargetRule[targets.length];
        int i = 0;
        while (i < targets.length) {
            targetRules[i] = new TargetRule((Directive)this, new Target(targets[i]), reqs);
            if (cmd != null) {
                Command command = new Command(this, cmd);
                targetRules[i].addDirective(command);
            }
            ++i;
        }
        return targetRules;
    }

    public static void main(String[] args) {
        try {
            String filename = "Makefile";
            if (args.length == 1) {
                filename = args[0];
            }
            PosixMakefile makefile = new PosixMakefile();
            makefile.parse(filename);
            IDirective[] directives = makefile.getDirectives();
            int i = 0;
            while (i < directives.length) {
                System.out.print(directives[i]);
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

