/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.StringTokenizer;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public class MIInfoProgramInfo
extends MIInfo {
    int pid;

    public MIInfoProgramInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public int getPID() {
        return this.pid;
    }

    void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord cons = (MIStreamRecord)oobs[i];
                    String str = cons.getString();
                    this.parseLine(str);
                }
                ++i;
            }
        }
    }

    void parseLine(String str) {
        if (str != null && str.length() > 0) {
            str = str.replace('.', ' ');
            if ((str = str.trim()).startsWith("Using")) {
                StringTokenizer st = new StringTokenizer(str);
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (!Character.isDigit(s.charAt(0))) continue;
                    try {
                        this.pid = Integer.decode(s);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
    }
}

