/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIMemory {
    long addr;
    long[] data = new long[0];
    String ascii = "";

    public MIMemory(MITuple tuple) {
        this.parse(tuple);
    }

    public long getAddress() {
        return this.addr;
    }

    public long[] getData() {
        return this.data;
    }

    public String getAscii() {
        return this.ascii;
    }

    public String toSting() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("addr=\"" + Long.toHexString(this.addr) + "\"");
        buffer.append("data=[");
        int i = 0;
        while (i < this.data.length) {
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append('\"').append(Long.toHexString(this.data[i])).append('\"');
            ++i;
        }
        buffer.append(']');
        if (this.ascii.length() > 0) {
            buffer.append(",ascii=\"" + this.ascii + "\"");
        }
        return buffer.toString();
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("addr")) {
                try {
                    this.addr = Long.decode(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("data")) {
                if (value != null && value instanceof MIList) {
                    this.parseData((MIList)value);
                }
            } else if (var.equals("ascii")) {
                this.ascii = str;
            }
            ++i;
        }
    }

    void parseData(MIList list) {
        MIValue[] values = list.getMIValues();
        this.data = new long[values.length];
        int i = 0;
        while (i < values.length) {
            if (values[i] instanceof MIConst) {
                String str = ((MIConst)values[i]).getCString();
                try {
                    this.data[i] = Long.decode(str.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    this.data[i] = 0L;
                }
            }
            ++i;
        }
    }
}

