/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;
import org.eclipse.cdt.debug.mi.core.output.MIVar;

public class MIVarListChildrenInfo
extends MIInfo {
    MIVar[] children;
    int numchild;

    public MIVarListChildrenInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    public MIVar[] getMIVars() {
        return this.children;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        ArrayList aList = new ArrayList();
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                if (var.equals("numchild")) {
                    if (value instanceof MIConst) {
                        String str = ((MIConst)value).getString();
                        try {
                            this.numchild = Integer.parseInt(str.trim());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (var.equals("children") && value instanceof MITuple) {
                    this.parseChildren((MITuple)value, aList);
                }
                ++i;
            }
        }
        this.children = aList.toArray(new MIVar[aList.size()]);
    }

    void parseChildren(MITuple tuple, List aList) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            MIValue value;
            String var = results[i].getVariable();
            if (var.equals("child") && (value = results[i].getMIValue()) instanceof MITuple) {
                aList.add(new MIVar((MITuple)value));
            }
            ++i;
        }
    }
}

