/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class RunToLineRulerAction
extends Action
implements IUpdate,
ISelectionListener,
INullSelectionListener {
    private IVerticalRulerInfo fInfo;
    private ITextEditor fTextEditor;
    private IRunToLine fTarget = null;

    public RunToLineRulerAction(IVerticalRulerInfo info, ITextEditor editor) {
        this.setInfo(info);
        this.setTextEditor(editor);
        this.setText("Run To Line");
        this.initializeTarget();
        this.update();
    }

    public void update() {
        boolean enabled = false;
        IFile file = this.getFile();
        int lineNumber = this.getLineNumber();
        IDocumentProvider provider = this.getTextEditor().getDocumentProvider();
        IDocument doc = provider.getDocument((Object)this.getTextEditor().getEditorInput());
        if (file != null && lineNumber <= doc.getNumberOfLines() && lineNumber > 0) {
            enabled = this.getTarget() != null && this.getTarget().canRunToLine(file, lineNumber);
        }
        this.setEnabled(enabled);
    }

    public void run() {
        this.runToLine(this.getFile(), this.getLineNumber());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IRunToLine target = null;
        if (part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            Object element;
            if (selection != null && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IRunToLine) {
                target = (IRunToLine)element;
            }
            this.setTarget(target);
            this.update();
        }
    }

    protected void initializeTarget() {
        this.setTarget(null);
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null && context instanceof IRunToLine) {
            this.setTarget((IRunToLine)context);
        }
    }

    protected void setTarget(IRunToLine target) {
        this.fTarget = target;
    }

    protected IRunToLine getTarget() {
        return this.fTarget;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo info) {
        this.fInfo = info;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    protected IFile getFile() {
        IEditorInput input = this.getTextEditor().getEditorInput();
        if (input != null && input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    protected int getLineNumber() {
        return this.getInfo().getLineOfLastMouseButtonActivity() + 1;
    }

    protected void runToLine(IFile file, int lineNumber) {
        if (!this.getTarget().canRunToLine(file, lineNumber)) {
            this.getTextEditor().getSite().getShell().getDisplay().beep();
            return;
        }
        try {
            this.getTarget().runToLine(file, lineNumber);
        }
        catch (DebugException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), e);
        }
    }
}

