/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.ui.AbstractDebugView;

public class MemoryViewEventHandler
extends AbstractDebugEventHandler {
    public MemoryViewEventHandler(AbstractDebugView view) {
        super(view);
    }

    protected void doHandleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 16: {
                    if (!(event.getSource() instanceof IFormattedMemoryBlock) || event.getDetail() != 512) break;
                    this.refresh(event.getSource());
                    this.getView().updateObjects();
                    return;
                }
                case 8: {
                    if (!(event.getSource() instanceof IFormattedMemoryBlock)) break;
                    this.remove(event.getSource());
                    this.getView().updateObjects();
                    return;
                }
            }
            ++i;
        }
    }

    protected void refresh(Object element) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            ((MemoryViewer)this.getViewer()).refresh(element);
        }
    }

    public void refresh() {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getViewer().refresh();
        }
    }

    protected void remove(Object element) {
        ((MemoryViewer)this.getViewer()).remove(element);
    }
}

