/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template;

public class Template {
    private String fName;
    private String fDescription;
    private String fContextTypeName;
    private String fPattern;
    private boolean fEnabled = true;

    public Template() {
        this("", "", "", "");
    }

    public Template(Template template) {
        this(template.getName(), template.getDescription(), template.getContextTypeName(), template.getPattern());
    }

    public Template(String name, String description, String contextTypeName, String pattern) {
        this.fName = name;
        this.fDescription = description;
        this.fContextTypeName = contextTypeName;
        this.fPattern = pattern;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Template)) {
            return false;
        }
        Template template = (Template)object;
        if (template == this) {
            return true;
        }
        return template.fName.equals(this.fName) && template.fPattern.equals(this.fPattern) && template.fContextTypeName.equals(this.fContextTypeName);
    }

    public int hashCode() {
        return this.fName.hashCode() ^ this.fPattern.hashCode() ^ this.fContextTypeName.hashCode();
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setContext(String contextTypeName) {
        this.fContextTypeName = contextTypeName;
    }

    public String getContextTypeName() {
        return this.fContextTypeName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setPattern(String pattern) {
        this.fPattern = pattern;
    }

    public String getPattern() {
        return this.fPattern;
    }

    public void setEnabled(boolean enable) {
        this.fEnabled = enable;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean matches(String prefix, String contextTypeName) {
        return this.fEnabled && this.fContextTypeName.equals(contextTypeName) && prefix.length() != 0 && this.fName.toLowerCase().startsWith(prefix.toLowerCase());
    }
}

