/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;

public class ElementNameSorter
extends ViewerSorter {
    private ILabelProvider _labelProvider;

    public int compare(Viewer viewer, Object e1, Object e2) {
        int compare;
        String name1 = null;
        String name2 = null;
        ISearchResultViewEntry entry1 = null;
        ISearchResultViewEntry entry2 = null;
        if (e1 instanceof ISearchResultViewEntry) {
            name1 = this._labelProvider.getText(e1);
            entry1 = (ISearchResultViewEntry)e1;
        }
        if (e2 instanceof ISearchResultViewEntry) {
            name2 = this._labelProvider.getText(e2);
            entry2 = (ISearchResultViewEntry)e2;
        }
        if (name1 == null) {
            name1 = "";
        }
        if (name2 == null) {
            name2 = "";
        }
        if ((compare = this.getCollator().compare(name1, name2)) == 0) {
            int startPos1 = -1;
            int startPos2 = -1;
            IMarker marker1 = entry1.getSelectedMarker();
            IMarker marker2 = entry2.getSelectedMarker();
            if (marker1 != null) {
                startPos1 = marker1.getAttribute("charStart", -1);
            }
            if (marker2 != null) {
                startPos2 = marker2.getAttribute("charStart", -1);
            }
            compare = startPos1 - startPos2;
        }
        return compare;
    }

    public boolean isSorterProperty(Object element, String property) {
        return true;
    }

    public void sort(Viewer viewer, Object[] elements) {
        ISearchResultView view = SearchUI.getSearchResultView();
        if (view == null) {
            return;
        }
        this._labelProvider = view.getLabelProvider();
        if (this._labelProvider instanceof CSearchResultLabelProvider) {
            ((CSearchResultLabelProvider)this._labelProvider).setOrder(1);
            super.sort(viewer, elements);
        }
    }
}

