/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.drag;

import java.util.Arrays;
import org.eclipse.cdt.internal.ui.drag.TransferDragSourceListener;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;

public class DelegatingDragAdapter
implements DragSourceListener {
    private final ISelectionProvider provider;
    private final TransferDragSourceListener[] listeners;
    private final boolean[] actives;
    private TransferDragSourceListener selected;

    public DelegatingDragAdapter(ISelectionProvider provider, TransferDragSourceListener[] listeners) {
        Assert.isNotNull((Object)provider);
        Assert.isNotNull((Object)listeners);
        this.provider = provider;
        this.listeners = listeners;
        this.actives = new boolean[listeners.length];
        this.selected = null;
    }

    public void dragStart(DragSourceEvent event) {
        this.selected = null;
        if (this.provider.getSelection().isEmpty()) {
            event.doit = false;
            return;
        }
        DragSource dragSource = (DragSource)event.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            event.doit = false;
            return;
        }
        Object saveData = event.data;
        boolean saveDoit = event.doit;
        int listenerCount = this.listeners.length;
        int transferCount = 0;
        int i = 0;
        while (i < listenerCount) {
            TransferDragSourceListener listener = this.listeners[i];
            event.data = saveData;
            event.doit = saveDoit;
            listener.dragStart(event);
            this.actives[i] = event.doit;
            if (this.actives[i]) {
                ++transferCount;
            }
            ++i;
        }
        event.data = saveData;
        event.doit = transferCount != 0;
        if (event.doit) {
            Transfer[] transferArray = new Transfer[transferCount];
            int i2 = listenerCount;
            while (--i2 >= 0) {
                if (!this.actives[i2]) continue;
                transferArray[--transferCount] = this.listeners[i2].getTransfer();
            }
            dragSource.setTransfer(transferArray);
        }
    }

    public void dragSetData(DragSourceEvent event) {
        this.selected = this.getListener(event.dataType);
        if (this.selected != null) {
            this.selected.dragSetData(event);
        }
    }

    public void dragFinished(DragSourceEvent event) {
        try {
            if (this.selected == null) {
                this.selected = this.getListener(event.dataType);
            }
            if (this.selected != null) {
                this.selected.dragFinished(event);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Arrays.fill(this.actives, false);
            this.selected = null;
            throw throwable;
        }
        Object var2_4 = null;
        Arrays.fill(this.actives, false);
        this.selected = null;
    }

    private TransferDragSourceListener getListener(TransferData type) {
        if (type != null) {
            int i = 0;
            while (i < this.actives.length) {
                TransferDragSourceListener listener;
                if (this.actives[i] && (listener = this.listeners[i]).getTransfer().isSupportedType(type)) {
                    return listener;
                }
                ++i;
            }
        }
        return null;
    }
}

